/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.oai.dataprovider20.token;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import nl.b3p.commons.oai.dataprovider20.error.BadResumptionToken;
import nl.b3p.commons.oai.dataprovider20.token.IdentifierToken;
import nl.b3p.commons.oai.dataprovider20.token.RecordsToken;
import nl.b3p.commons.oai.dataprovider20.token.SetToken;
import nl.b3p.commons.oai.dataprovider20.token.Token;

public class TokenModem {
    public static String encode(Token token) {
        try {
            if (token.getType() == 1) {
                return URLEncoder.encode("v=s&c=" + token.getCursor(), "UTF-8");
            }
            if (token.getType() == 2) {
                IdentifierToken t = (IdentifierToken)token;
                String result = URLEncoder.encode("v=i&c=" + t.getCursor() + TokenModem.clear("f", t.from) + TokenModem.clear("u", t.until) + TokenModem.clear("s", t.set) + TokenModem.clear("m", t.metadataPrefix), "UTF-8");
                System.out.println(result);
                return result;
            }
            if (token.getType() == 3) {
                RecordsToken t = (RecordsToken)token;
                return URLEncoder.encode("v=r&c=" + t.getCursor() + TokenModem.clear("f", t.from) + TokenModem.clear("u", t.until) + TokenModem.clear("s", t.set) + TokenModem.clear("m", t.metadataPrefix), "UTF-8");
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Token decode(String token) throws BadResumptionToken {
        Token t = null;
        try {
            String value = URLDecoder.decode(token, "UTF-8");
            Hashtable<String, String> saver = new Hashtable<String, String>();
            StringTokenizer st = new StringTokenizer(value, "&");
            while (st.hasMoreTokens()) {
                String piece = st.nextToken();
                saver.put(piece.substring(0, 1), piece.substring(2));
            }
            String type = (String)saver.get("v");
            if (type.equals("s")) {
                t = new SetToken();
            } else if (type.equals("r")) {
                RecordsToken record = new RecordsToken();
                record.metadataPrefix = (String)saver.get("m");
                record.from = (String)saver.get("f");
                record.until = (String)saver.get("u");
                record.set = (String)saver.get("s");
                t = record;
            } else if (type.equals("i")) {
                IdentifierToken record = new IdentifierToken();
                record.from = (String)saver.get("f");
                record.until = (String)saver.get("u");
                record.set = (String)saver.get("s");
                record.metadataPrefix = (String)saver.get("m");
                t = record;
            }
            t.setCursor(Integer.parseInt((String)saver.get("c")));
        }
        catch (Exception e) {
            System.out.println(e);
            throw new BadResumptionToken("token format error");
        }
        return t;
    }

    private static String clear(String label, String value) {
        if (value == null) {
            return "";
        }
        return "&" + label + "=" + value;
    }
}

