/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.security;

import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.security.SessionCounter;
import nl.b3p.commons.security.xml.Role;
import nl.b3p.commons.security.xml.User;
import nl.b3p.commons.security.xml.WebappUsers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class XmlSecurityDatabase
extends HttpServlet {
    private static final Log log = LogFactory.getLog(XmlSecurityDatabase.class);
    private static WebappUsers securityDatabase = null;
    private static HashMap userpasswords = null;
    private static HashMap userroles = null;
    private static int maxNumOfSessions = 0;
    private static boolean initialized = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String configLocation = this.getServletContext().getRealPath(config.getInitParameter("config"));
            this.log("config pad: " + configLocation);
            FileReader fr = new FileReader(configLocation);
            if (fr == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"config reader is null");
                }
            } else {
                try {
                    securityDatabase = WebappUsers.unmarshal(fr);
                }
                catch (MarshalException me) {
                    log.error((Object)"MarshalException", (Throwable)me);
                }
                catch (ValidationException ve) {
                    log.error((Object)"MarshalException", (Throwable)ve);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Xml Security Database load exception", (Throwable)e);
            throw new UnavailableException("Cannot load xml security database");
        }
        if (securityDatabase != null && log != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Xml Database is not null.");
            }
            maxNumOfSessions = securityDatabase.getMaxsessions();
            log.debug((Object)("Max number of active sessions: " + maxNumOfSessions + " (0 = no limit)"));
            userpasswords = new HashMap();
            userroles = new HashMap();
            int userCount = securityDatabase.getUserCount();
            for (int i = 0; i < userCount; ++i) {
                User aUser = null;
                try {
                    aUser = securityDatabase.getUser(i);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    break;
                }
                if (aUser == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Init user: " + aUser.getUsername()));
                }
                userpasswords.put(aUser.getUsername(), aUser.getPassword());
                String theRoles = aUser.getRoles();
                if (theRoles == null || theRoles.length() == 0) continue;
                ArrayList<String> roleList = new ArrayList<String>();
                int roleCount = securityDatabase.getRoleCount();
                for (int j = 0; j < roleCount; ++j) {
                    Role aRole = null;
                    try {
                        aRole = securityDatabase.getRole(j);
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        break;
                    }
                    if (aRole == null || theRoles.indexOf(aRole.getRolename()) < 0) continue;
                    roleList.add(aRole.getRolename());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("  adding role: " + aRole.getRolename()));
                }
                userroles.put(aUser.getUsername(), roleList);
            }
            initialized = true;
            if (log.isInfoEnabled()) {
                log.debug((Object)"Initializing Xml Security Database servlet");
            }
        } else {
            System.out.println("XML Security Database servlet not initialized!");
        }
    }

    public void destroy() {
        securityDatabase = null;
        userpasswords = null;
        userroles = null;
        super.destroy();
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public static boolean booleanAuthenticate(String username, String password) {
        if (!XmlSecurityDatabase.isInitialized()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to login: " + username + " with password: " + password));
        }
        int nos = SessionCounter.getActiveSessions();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of active sessions: " + nos));
        }
        if (maxNumOfSessions > 0 && nos > maxNumOfSessions) {
            return false;
        }
        if (userpasswords == null) {
            return false;
        }
        if (username == null || password == null) {
            return false;
        }
        return userpasswords.containsKey(username) && password.equals((String)userpasswords.get(username));
    }

    public static boolean isUserInRole(String username, String role) {
        ArrayList roleList;
        if (!XmlSecurityDatabase.isInitialized()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking role: " + role + " for user: " + username));
        }
        int nos = SessionCounter.getActiveSessions();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of active sessions: " + nos));
        }
        if (maxNumOfSessions > 0 && nos > maxNumOfSessions) {
            return false;
        }
        if (userroles == null) {
            return false;
        }
        if (username == null || role == null) {
            return false;
        }
        if (userroles.containsKey(username) && (roleList = (ArrayList)userroles.get(username)).contains(role)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  OK!");
            }
            return true;
        }
        return false;
    }

    public static WebappUsers getSecurityDatabase() {
        return securityDatabase;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public String getServletInfo() {
        return "XML Security Database servlet";
    }
}

