/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.security.aselect;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.security.aselect.ASelectAgentClient;
import nl.b3p.commons.security.aselect.ASelectAgentTicket;
import nl.b3p.commons.security.aselect.ASelectAuthorizationException;
import nl.b3p.commons.security.aselect.ASelectClient;
import nl.b3p.commons.security.aselect.ASelectConstants;
import nl.b3p.commons.security.aselect.ASelectTicket;
import nl.b3p.commons.security.aselect.ASelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;

public class ASelectAuthorizationFilter
implements Filter,
ASelectConstants {
    private static Log log = LogFactory.getLog(ASelectAuthorizationFilter.class);
    private static final int ASELECT_API_AGENT = 0;
    private static final int ASELECT_API_SERVER = 1;
    private static final int ASELECT_API_WEBSERVERFILTER = 2;
    private static final String ASELECT_ORIGINAL_APP_URL = ASelectAuthorizationFilter.class.getName() + ".ORIGINAL_APP_URL";
    private static final String ASELECT_REDIRECT_BACK = "aselect__redirect_back";
    private static final String ASELECT_FORCE_LOGIN = ASelectAuthorizationFilter.class.getName() + ".FORCE_LOGIN";
    private boolean configOK = false;
    private FilterConfig filterConfig = null;
    private int api;
    private String appId;
    private boolean avoidURLParamsInRedirect;
    private ASelectClient client;

    public void init(FilterConfig filterConfig) {
        if (log.isInfoEnabled()) {
            log.info((Object)"init");
        }
        this.configOK = false;
        try {
            this.filterConfig = filterConfig;
            String apiString = filterConfig.getInitParameter("api");
            if (apiString != null) {
                apiString = apiString.toLowerCase();
            }
            if (!apiString.equals("agent")) {
                throw new IllegalArgumentException("invalid \"api\" init parameter");
            }
            this.api = 0;
            this.client = new ASelectAgentClient(this.filterConfigToProperties(filterConfig));
            this.appId = filterConfig.getInitParameter("app_id");
            if (this.appId == null) {
                throw new IllegalArgumentException("\"app_id\" init parameter required");
            }
            this.avoidURLParamsInRedirect = "true".equals(filterConfig.getInitParameter("avoid_url_params_in_redirect"));
            this.configOK = true;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("error initializing filter " + filterConfig.getFilterName()), (Throwable)e);
        }
        if (!this.configOK) {
            log.error((Object)"bad config; disallowing access to application");
        }
    }

    private Properties filterConfigToProperties(FilterConfig c) {
        Properties result = new Properties();
        Enumeration params = c.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            result.setProperty(name, c.getInitParameter(name));
        }
        return result;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        MDC.remove((String)"ASelectUid");
        MDC.remove((String)"ASelectTicket");
        if (!this.configOK) {
            throw new ServletException("Invalid filter configuration");
        }
        boolean authorized = false;
        try {
            authorized = this.checkAuthorization((HttpServletRequest)request, (HttpServletResponse)response);
            if (authorized) {
                chain.doFilter(request, response);
            }
        }
        catch (ASelectAuthorizationException ae) {
            if (log.isErrorEnabled()) {
                log.error((Object)("ASelectAuthorizationException: " + ae.getMessage()));
            }
            throw new ServletException((Throwable)ae);
        }
    }

    public void destroy() {
    }

    public static void forceLogin(HttpSession session) {
        session.setAttribute(ASELECT_FORCE_LOGIN, (Object)"true");
    }

    private boolean checkAuthorization(HttpServletRequest request, HttpServletResponse response) throws ASelectAuthorizationException, ServletException, IOException {
        if (this.api == 2) {
            return this.verifyWebFilterCookies(request);
        }
        String asRid = request.getParameter("rid");
        String asCredentials = request.getParameter("aselect_credentials");
        if (asRid != null && asCredentials != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"verifying credentials");
            }
            if (!this.verifyCredentials(request, asRid, asCredentials)) {
                throw new ServletException("Credentials could not be verified");
            }
            if (this.avoidURLParamsInRedirect && "true".equals(request.getParameter(ASELECT_REDIRECT_BACK))) {
                HttpSession sess = request.getSession();
                String originalURL = (String)sess.getAttribute(ASELECT_ORIGINAL_APP_URL);
                if (originalURL == null) {
                    throw new ServletException("Invalid state: no original app URL in session to redirect to");
                }
                sess.removeAttribute(ASELECT_ORIGINAL_APP_URL);
                if (log.isInfoEnabled()) {
                    log.info((Object)("redirecting to original app URL: " + originalURL));
                }
                response.sendRedirect(originalURL);
                return false;
            }
            return true;
        }
        ASelectTicket ticket = ASelectTicket.getFromSession(request.getSession());
        if (ticket != null) {
            try {
                ticket.verify();
            }
            catch (IOException e) {
                throw new ServletException("Error verifying ticket", (Throwable)e);
            }
            MDC.put((String)"ASelectUid", (Object)ticket.getUid());
            MDC.put((String)"ASelectTicket", (Object)ticket.getTicketId());
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"redirecting to A-Select server");
        }
        this.redirectToASelect(request, response);
        return false;
    }

    private boolean verifyWebFilterCookies(HttpServletRequest request) throws ASelectAuthorizationException {
        throw new ASelectAuthorizationException("not implemented");
    }

    private boolean isUserError(String code) {
        return "010b".equals(code) || "010a".equals(code) || "0109".equals(code) || "0102".equals(code);
    }

    private boolean verifyCredentials(HttpServletRequest request, String rid, String credentials) throws ServletException, ASelectAuthorizationException {
        Date expTime;
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("request", "verify_credentials");
        params.put("rid", rid);
        params.put("aselect_credentials", credentials);
        Map asResponse = null;
        try {
            asResponse = this.client.performRequest(params);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        String asResult = (String)asResponse.get("result_code");
        String asTicket = (String)asResponse.get("ticket");
        String asTicketExpTime = (String)asResponse.get("ticket_exp_time");
        String asUid = (String)asResponse.get("uid");
        String asOrganization = (String)asResponse.get("organization");
        String asAuthSPLevel = (String)asResponse.get("authsp_level");
        String asAuthSP = (String)asResponse.get("authsp");
        String asAttributes = (String)asResponse.get("attributes");
        if (!"0000".equals(asResult)) {
            log.info((Object)("Received error code \"" + asResult + "\" from A-Select when verifying credentials (from IP: " + request.getRemoteHost() + ")"));
            if (this.isUserError(asResult)) {
                return false;
            }
            throw new ServletException("A-Select communication error");
        }
        Date startTime = this.api == 0 ? new Date(Long.parseLong((String)asResponse.get("ticket_start_time"))) : new Date();
        try {
            expTime = new Date(Long.parseLong(asTicketExpTime));
            log.debug((Object)("Ticket start date/time:      " + startTime));
            log.debug((Object)("Ticket expiration date/time: " + expTime));
            if (startTime.compareTo(expTime) > 0) {
                throw new ServletException("A-Select server specified ticket expiration time in the past");
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"invalid date received from A-Select server", (Throwable)nfe);
            throw new ServletException("A-Select communication error");
        }
        ASelectTicket ticket = this.api == 0 ? new ASelectAgentTicket(asTicket, this.appId, startTime, expTime, asUid, asOrganization, asAuthSPLevel, asAuthSP, asAttributes, (ASelectAgentClient)this.client) : null;
        ticket.putOnSession(request.getSession());
        return true;
    }

    private void redirectToASelect(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StringBuffer appURL;
        String queryString = request.getQueryString();
        String completeURL = request.getRequestURL() + (queryString != null ? "?" + queryString : "");
        if (log.isWarnEnabled() && !"GET".equals(request.getMethod())) {
            log.warn((Object)("redirect to A-Select for request with other method than GET (" + request.getMethod() + " " + completeURL + ")"));
        }
        if (this.api == 0 && this.avoidURLParamsInRedirect) {
            HttpSession sess = request.getSession();
            sess.setAttribute(ASELECT_ORIGINAL_APP_URL, (Object)completeURL);
            appURL = request.getRequestURL();
            appURL.append("?aselect__redirect_back=true");
        } else {
            appURL = new StringBuffer(completeURL);
        }
        Map asResponse = null;
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("request", "authenticate");
            params.put("app_id", this.appId);
            params.put("app_url", appURL.toString());
            if (request.getSession().getAttribute(ASELECT_FORCE_LOGIN) != null) {
                params.put("forced_logon", "true");
                request.getSession().removeAttribute(ASELECT_FORCE_LOGIN);
            }
            asResponse = this.client.performRequest(params);
        }
        catch (IOException e) {
            log.error((Object)"error initiating authentication with A-Select", (Throwable)e);
            throw new ServletException("A-Select communication error");
        }
        String asResult = (String)asResponse.get("result_code");
        String asURL = (String)asResponse.get("as_url");
        String asServer = (String)asResponse.get("a-select-server");
        String asRId = (String)asResponse.get("rid");
        if (!"0000".equals(asResult) && log.isErrorEnabled()) {
            throw new ServletException("A-Select communication error; result code " + asResult);
        }
        if (asURL == null || asServer == null || asRId == null) {
            log.error((Object)("missing result parameters; response: " + asResponse.get("complete_response")));
            throw new ServletException("A-Select communication error");
        }
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("a-select-server", asServer);
        params.put("rid", asRId);
        try {
            String redirectURL = ASelectUtils.appendQueryParameters(asURL, params, this.client.getCharset());
            response.sendRedirect(redirectURL);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException("Internal error", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

