/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.clieop3;

public class PadUtils {
    public static final char[] PADDING_SPACES = new char[10];
    public static final char[] PADDING_ZEROES;
    private static final int PAD_PART_SIZE = 10;

    private static void fillChars(char[] dest, int count, char ch) {
        for (int i = 0; i < count; ++i) {
            dest[i] = ch;
        }
    }

    private PadUtils() {
    }

    public static void pad(int count, char[] padding, StringBuffer appendTo) {
        while (count > 0) {
            int padLen = Math.min(count, padding.length);
            appendTo.append(padding, 0, padLen);
            count -= padLen;
        }
    }

    public static void postPadAppend(String str, int length, StringBuffer appendTo, char[] padding) {
        int len = str.length();
        if (len == length) {
            appendTo.append(str);
        } else if (len > length) {
            appendTo.append(str.substring(0, length));
        } else {
            appendTo.append(str);
            PadUtils.pad(length - len, padding, appendTo);
        }
    }

    public static void prePadAppend(String str, int length, StringBuffer appendTo, char[] padding) {
        int len = str.length();
        if (len > length) {
            throw new IllegalArgumentException("value \"" + str + "\" does not fit in field of length " + length);
        }
        if (len < length) {
            PadUtils.pad(length - len, padding, appendTo);
        }
        appendTo.append(str);
    }

    public static void padText(String text, int length, StringBuffer appendTo) {
        PadUtils.postPadAppend(text, length, appendTo, PADDING_SPACES);
    }

    public static void padNumber(String number, int length, StringBuffer appendTo) {
        PadUtils.prePadAppend(number, length, appendTo, PADDING_ZEROES);
    }

    public static void padRecord(StringBuffer appendTo, int length) {
        PadUtils.pad(length - appendTo.length(), PADDING_SPACES, appendTo);
    }

    static {
        PadUtils.fillChars(PADDING_SPACES, PADDING_SPACES.length, ' ');
        PADDING_ZEROES = new char[10];
        PadUtils.fillChars(PADDING_ZEROES, PADDING_ZEROES.length, '0');
    }
}

