/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.clieop3.record;

import java.text.SimpleDateFormat;
import java.util.Date;
import nl.b3p.commons.clieop3.ClieOp3OutputStream;
import nl.b3p.commons.clieop3.PadUtils;
import nl.b3p.commons.clieop3.record.Record;

public class BestandStart
extends Record {
    private static final String RECORDCODE = "0001";
    private static final char VARIANTCODE = 'A';
    private static final String BESTANDSNAAM = "CLIEOP03";
    private Date aanmaakDatum;
    private String identificatie;
    private int volgnummer;
    private boolean isDuplicaat;

    public BestandStart(Date aanmaakDatum, String identificatie, int volgnummer, boolean isDuplicaat) {
        super(RECORDCODE, 'A');
        this.aanmaakDatum = aanmaakDatum;
        this.identificatie = ClieOp3OutputStream.cleanClieOp3String(identificatie);
        this.volgnummer = volgnummer;
        this.isDuplicaat = isDuplicaat;
    }

    public Date getAanmaakDatum() {
        return this.aanmaakDatum;
    }

    public String getIdentificatie() {
        return this.identificatie;
    }

    public int getVolgnummer() {
        return this.volgnummer;
    }

    public boolean isDuplicaat() {
        return this.isDuplicaat;
    }

    @Override
    protected void appendRecordContents(StringBuffer buf) {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String date = df.format(this.aanmaakDatum);
        buf.append(date);
        buf.append(BESTANDSNAAM);
        PadUtils.padText(this.identificatie, 5, buf);
        buf.append(date.substring(0, 2));
        PadUtils.padNumber(this.volgnummer + "", 2, buf);
        buf.append(this.isDuplicaat ? (char)'2' : '1');
    }

    public static void main(String[] args) {
        BestandStart entry = new BestandStart(new Date(), "TEST", 1, false);
        System.out.println(entry.getRecordData());
    }
}

