/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.security.aselect;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.security.aselect.ASelectAuthorizationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ASelectTicket {
    protected static Log log = LogFactory.getLog(ASelectTicket.class);
    private static final String TICKET_SESSION_KEY = ASelectTicket.class.getName() + ".TICKET";
    private String ticket;
    private String appId;
    private String uid;
    private String organization;
    private Date startTime;
    private Date expirationTime;
    private String authSPLevel;
    private String authSP;
    private String attributes;
    private HttpSession session;

    protected ASelectTicket(String ticket, String appId, Date startTime, Date expTime, String uid, String organization, String authSPLevel, String authSP, String attributes) {
        this.ticket = ticket;
        this.appId = appId;
        this.startTime = startTime;
        this.expirationTime = expTime;
        this.uid = uid;
        this.organization = organization;
        this.authSPLevel = authSPLevel;
        this.attributes = attributes;
    }

    protected abstract void doVerify() throws IOException, ASelectAuthorizationException;

    public void verify() throws IOException, ASelectAuthorizationException {
        try {
            this.doVerify();
        }
        catch (ASelectAuthorizationException aae) {
            this.removeFromSession();
            throw aae;
        }
    }

    protected abstract void doKill() throws IOException;

    public void kill() throws IOException {
        this.doKill();
        this.removeFromSession();
    }

    private void removeFromSession() {
        if (this.session != null) {
            this.session.removeAttribute(TICKET_SESSION_KEY);
        }
    }

    void putOnSession(HttpSession session) {
        this.session = session;
        session.setAttribute(TICKET_SESSION_KEY, (Object)this);
    }

    public static ASelectTicket getFromSession(HttpSession session) {
        ASelectTicket t = null;
        try {
            t = (ASelectTicket)session.getAttribute(TICKET_SESSION_KEY);
        }
        catch (IllegalStateException ise) {
            log.error((Object)"getFromSession(): session IllegalStateException");
        }
        catch (ClassCastException cce) {
            log.error((Object)"getFromSession(): not an ASelectTicket object in session", (Throwable)cce);
        }
        return t;
    }

    public String getTicketId() {
        return this.ticket;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getUid() {
        return this.uid;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getUndecodedAttributes() {
        return this.attributes;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public String getAuthSPLevel() {
        return this.authSPLevel;
    }

    public String getAuthSP() {
        return this.authSP;
    }
}

