/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.stripes;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.DefaultPopulationStrategy;
import net.sourceforge.stripes.tag.InputTagSupport;
import net.sourceforge.stripes.tag.PopulationStrategy;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.stripes.CustomPopulationStrategy;

public class SelectivePopulationStrategy
implements PopulationStrategy {
    private static final Log LOG = Log.getInstance(SelectivePopulationStrategy.class);
    private Configuration config;
    private PopulationStrategy defaultDelegate;
    private Map<Class<? extends PopulationStrategy>, PopulationStrategy> delegates = new HashMap<Class<? extends PopulationStrategy>, PopulationStrategy>();
    private Map<Class<? extends ActionBean>, PopulationStrategy> actionBeanStrategies = new HashMap<Class<? extends ActionBean>, PopulationStrategy>();

    protected PopulationStrategy getDelegate(InputTagSupport tag) throws StripesJspException {
        ActionBean actionBean = tag.getActionBean();
        if (actionBean == null) {
            return this.defaultDelegate;
        }
        Class<?> beanType = actionBean.getClass();
        PopulationStrategy delegate = this.actionBeanStrategies.get(beanType);
        if (delegate != null) {
            return delegate;
        }
        CustomPopulationStrategy annotation = beanType.getAnnotation(CustomPopulationStrategy.class);
        if (annotation == null) {
            delegate = this.defaultDelegate;
        } else {
            Class<? extends PopulationStrategy> type = annotation.value();
            delegate = this.delegates.get(type);
            if (delegate == null) {
                try {
                    delegate = type.newInstance();
                    delegate.init(this.config);
                    this.delegates.put(type, delegate);
                }
                catch (Exception e) {
                    delegate = this.defaultDelegate;
                    LOG.info(new Object[]{"Could not instantiate population strategy of name [" + type + "]", e});
                }
            }
        }
        this.actionBeanStrategies.put(beanType, delegate);
        return delegate;
    }

    public Object getValue(InputTagSupport tag) throws StripesJspException {
        PopulationStrategy strategy = this.getDelegate(tag);
        Object value = strategy.getValue(tag);
        return value;
    }

    public void init(Configuration configuration) throws Exception {
        this.config = configuration;
        this.defaultDelegate = new DefaultPopulationStrategy();
        this.defaultDelegate.init(this.config);
    }
}

