/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.csv;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import nl.b3p.commons.csv.CsvFormatException;

public class CsvInputStream {
    private static final char QUOTE = '\"';
    private static final int OK_HAVE_MORE_FIELDS = 0;
    private static final int OK_END_OF_RECORD = 1;
    private static final int EOF = 2;
    private LineNumberReader input;
    private int recordNumber;
    private char separator = (char)44;
    private int columnCount = -1;
    private boolean checkColumnCount;
    private String inputDescription = "csv file";
    private StringCharacterIterator currentLine;
    private StringBuffer field;

    public CsvInputStream(Reader input) {
        this.input = new LineNumberReader(input);
    }

    public List readRecordAsList() throws IOException, CsvFormatException {
        int recordState;
        ArrayList<String> fields = new ArrayList<String>(this.columnCount == -1 ? 10 : this.columnCount);
        int columns = 0;
        do {
            if ((recordState = this.getNextField()) != 2) {
                fields.add(this.field.toString());
                ++columns;
                continue;
            }
            if (columns != 0) continue;
            return null;
        } while (recordState == 0 && (this.columnCount == -1 || columns < this.columnCount));
        if (this.checkColumnCount) {
            if (this.columnCount != -1) {
                if (columns < this.columnCount) {
                    throw new CsvFormatException(this.getExceptionMessage("More columns expected"));
                }
                if (recordState == 0) {
                    throw new CsvFormatException(this.getExceptionMessage("More columns than expected (" + this.columnCount + ") at pos " + this.currentLine.getIndex() + 1));
                }
            } else {
                this.columnCount = columns;
            }
        }
        ++this.recordNumber;
        return fields;
    }

    public String[] readRecord() throws IOException, CsvFormatException {
        List fields = this.readRecordAsList();
        if (fields == null) {
            return null;
        }
        return fields.toArray(new String[0]);
    }

    private String getExceptionMessage(String s) {
        return this.inputDescription + " at line " + this.input.getLineNumber() + ": " + s;
    }

    private int getNextField() throws IOException, CsvFormatException {
        if (this.currentLine == null) {
            String s = this.input.readLine();
            if (s == null) {
                return 2;
            }
            this.currentLine = new StringCharacterIterator(s);
        }
        boolean inQuote = false;
        int fieldBeginPos = this.currentLine.getIndex();
        this.field = new StringBuffer();
        while (true) {
            char c = this.currentLine.current();
            int pos = this.currentLine.getIndex();
            if (c == '\uffff') {
                if (inQuote) {
                    String s = this.input.readLine();
                    if (s == null) {
                        throw new CsvFormatException("EOF before end of multi-line field");
                    }
                    this.currentLine = new StringCharacterIterator(s);
                    fieldBeginPos = -1;
                    this.field.append('\n');
                    continue;
                }
                this.currentLine = null;
                return 1;
            }
            if (c == '\"') {
                if (inQuote) {
                    c = this.currentLine.next();
                    if (c == '\"') {
                        this.field.append('\"');
                        this.currentLine.next();
                        continue;
                    }
                    if (c == '\uffff') {
                        this.currentLine = null;
                        return 1;
                    }
                    if (c == this.separator) {
                        this.currentLine.next();
                        return 0;
                    }
                    throw new CsvFormatException(this.getExceptionMessage("Expected separator '" + this.separator + "' but found '" + c + "' at pos " + (this.currentLine.getIndex() + 1)));
                }
                if (pos == fieldBeginPos) {
                    inQuote = true;
                    this.currentLine.next();
                    continue;
                }
            }
            if (!inQuote && c == this.separator) {
                this.currentLine.next();
                return 0;
            }
            this.field.append(c);
            this.currentLine.next();
        }
    }

    public int getLastRecordNumber() {
        return this.recordNumber;
    }

    public int getLineNumber() {
        return this.input.getLineNumber();
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public boolean getCheckColumnCount() {
        return this.checkColumnCount;
    }

    public void setCheckColumnCount(boolean checkColumnCount) {
        this.checkColumnCount = checkColumnCount;
    }

    public int getColumnCount() {
        if (this.columnCount == -1) {
            throw new IllegalStateException("No record read yet, column count unknown");
        }
        return this.columnCount;
    }

    public String getInputDescription() {
        return this.inputDescription;
    }

    public void setInputDescription(String inputDescription) {
        this.inputDescription = inputDescription;
    }
}

