/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.CountingOutputStream;

public class SizeLimitedOutputStream
extends CountingOutputStream {
    private long maxBytes = -1L;

    public SizeLimitedOutputStream(OutputStream out) {
        super(out);
    }

    public SizeLimitedOutputStream(OutputStream out, long maxBytes) {
        super(out);
        this.maxBytes = maxBytes;
    }

    private static void maxBytesExceeded() throws IOException {
        throw new IOException("Maximum number of bytes exceeded.");
    }

    public void write(byte[] b) throws IOException {
        if (this.getByteCount() + (long)b.length > this.maxBytes) {
            SizeLimitedOutputStream.maxBytesExceeded();
        }
        super.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.getByteCount() + (long)Math.min(b.length - off, len) > this.maxBytes) {
            SizeLimitedOutputStream.maxBytesExceeded();
        }
        super.write(b, off, len);
    }

    public void write(int b) throws IOException {
        if (this.getByteCount() + 1L > this.maxBytes) {
            SizeLimitedOutputStream.maxBytesExceeded();
        }
        super.write(b);
    }
}

