/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.stripes;

import java.beans.Statement;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.OnwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Intercepts(value={LifecycleStage.ActionBeanResolution, LifecycleStage.EventHandling, LifecycleStage.RequestComplete})
public class JpaTransactionInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(JpaTransactionInterceptor.class);
    public static final String OPEN_SESSION_IN_VIEW = "openSessionInView";
    public static final String TRANSACTION_PERSISTENCE_UNIT = "transactionPersistenceUnit";

    private String getActiveTransactionPersistenceUnit(ExecutionContext ctx) {
        return (String)ctx.getActionBeanContext().getRequest().getAttribute(TRANSACTION_PERSISTENCE_UNIT);
    }

    public void setActiveTransactionPersistenceUnit(ExecutionContext ctx, String persistenceUnit) {
        ctx.getActionBeanContext().getRequest().setAttribute(TRANSACTION_PERSISTENCE_UNIT, (Object)persistenceUnit);
    }

    public Resolution intercept(ExecutionContext ctx) throws Exception {
        Resolution resolution;
        try {
            resolution = ctx.proceed();
        }
        catch (Throwable e) {
            this.rollbackTransaction(ctx);
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception(e);
        }
        if (ctx.getLifecycleStage() == LifecycleStage.ActionBeanResolution) {
            ActionBean bean = ctx.getActionBean();
            if (bean != null && bean.getClass().isAnnotationPresent(Transactional.class)) {
                if (this.getActiveTransactionPersistenceUnit(ctx) != null) {
                    log.debug((Object)"Transaction already started - using open-session-in-view with useActionBean tag? Not starting another transaction");
                } else {
                    String persistenceUnit = bean.getClass().getAnnotation(Transactional.class).persistenceUnit();
                    log.debug((Object)("Starting transaction for ActionBean " + bean.getClass().getName()));
                    this.startTransaction(ctx, persistenceUnit);
                    try {
                        Statement stmt = new Statement(bean, "setEntityManager", new Object[]{this.getEntityManager(ctx)});
                        stmt.execute();
                        log.debug((Object)("Injected entityManager property in ActionBean " + bean.getClass().toString()));
                    }
                    catch (Exception e) {
                        log.debug((Object)("Error injecting entityManager property in ActionBean " + bean.getClass().toString()));
                    }
                }
            }
        } else if (ctx.getLifecycleStage() == LifecycleStage.EventHandling) {
            Object[] param;
            boolean openSessionInView = Boolean.TRUE.equals(ctx.getActionBeanContext().getRequest().getAttribute(OPEN_SESSION_IN_VIEW));
            if (resolution != null && resolution instanceof OnwardResolution && (param = (Object[])((OnwardResolution)resolution).getParameters().get(OPEN_SESSION_IN_VIEW)) != null && param.length > 0) {
                openSessionInView = Boolean.TRUE.equals(param[0]);
            }
            if (!openSessionInView) {
                this.commitTransaction(ctx);
            } else {
                log.debug((Object)"Leaving transaction open for view");
            }
        } else if (ctx.getLifecycleStage() == LifecycleStage.RequestComplete) {
            this.commitTransaction(ctx);
        }
        return resolution;
    }

    private EntityManager getEntityManager(ExecutionContext ctx) {
        String persistenceUnit = this.getActiveTransactionPersistenceUnit(ctx);
        if (persistenceUnit == null) {
            return null;
        }
        return persistenceUnit.equals("[default]") ? JpaUtilServlet.getThreadEntityManager() : JpaUtilServlet.getThreadEntityManager(persistenceUnit);
    }

    private void closeEntityManager(String persistenceUnit) {
        log.debug((Object)("Closing EntityManager for persistence unit " + persistenceUnit));
        if (persistenceUnit.equals("[default]")) {
            JpaUtilServlet.closeThreadEntityManager();
        } else {
            JpaUtilServlet.closeThreadEntityManager(persistenceUnit);
        }
    }

    private void startTransaction(ExecutionContext ctx, String persistenceUnit) {
        this.setActiveTransactionPersistenceUnit(ctx, persistenceUnit);
        EntityManager em = this.getEntityManager(ctx);
        EntityTransaction tx = em.getTransaction();
        log.debug((Object)("Starting transaction for persistence unit " + persistenceUnit));
        tx.begin();
    }

    private void commitTransaction(ExecutionContext ctx) {
        EntityManager em = this.getEntityManager(ctx);
        if (em != null) {
            EntityTransaction tx = em.getTransaction();
            if (tx.isActive()) {
                log.debug((Object)"Committing active transaction");
                tx.commit();
                this.closeEntityManager(this.getActiveTransactionPersistenceUnit(ctx));
                this.setActiveTransactionPersistenceUnit(ctx, null);
            } else {
                log.debug((Object)"Transaction is not active - not committing");
            }
        }
    }

    private void rollbackTransaction(ExecutionContext ctx) {
        EntityManager em = this.getEntityManager(ctx);
        if (em != null) {
            EntityTransaction tx = em.getTransaction();
            if (!tx.isActive()) {
                log.debug((Object)"Exception occurred but the transaction is not active - not rolling back");
            } else {
                log.error((Object)"Exception occurred - rolling back active transaction");
                try {
                    tx.rollback();
                    this.closeEntityManager(this.getActiveTransactionPersistenceUnit(ctx));
                    this.setActiveTransactionPersistenceUnit(ctx, null);
                }
                catch (Exception e) {
                    log.error((Object)"Exception rolling back transaction", (Throwable)e);
                }
            }
        }
    }
}

