/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.GetServiceFileServlet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetServiceFileSecureServlet
extends GetServiceFileServlet {
    private static Log log = LogFactory.getLog(GetServiceFileSecureServlet.class);
    private static final String HASHSTRING = "secretHashString";
    private static final String CODE = "code";
    private static String hashString = null;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing Secure File Getter");
        }
        if ((hashString = config.getInitParameter(HASHSTRING)) == null || hashString.length() == 0) {
            hashString = null;
            log.error((Object)"SecretHashString initParameter not set !!!");
        }
    }

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, UnsupportedEncodingException {
        if (hashString == null) {
            log.error((Object)"SecretHashString initParameter not set !!!");
            this.writeErrorMessage(response, "Servlet not configured properly, see log file");
            return;
        }
        String code = request.getParameter(CODE);
        String fileString = request.getParameter("file");
        File file = this.getCorrectedFile(fileString);
        if (file == null) {
            this.writeFileNotFoundMessage(response, fileString);
            return;
        }
        if ((code == null || code.length() == 0) && request.getRequestURL().toString().startsWith("http://localhost")) {
            this.writeFileToHtml(request, response, file);
            return;
        }
        try {
            String hashedFile = this.getFileHash(fileString);
            if (hashedFile.equals(code)) {
                super.processRequest(request, response);
            } else {
                this.writeErrorMessage(response, "Access not allowed for this file.");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ServletException("Error while getting file, cause: ", (Throwable)ex);
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    @Override
    public String getServletInfo() {
        return "Short description";
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        System.out.println("Secret HashString: ");
        String hash = br.readLine();
        System.out.println("File path: ");
        String filePath = br.readLine();
        String code = GetServiceFileSecureServlet.getHash(hash + filePath);
        String params = "?file=" + filePath + "&" + CODE + "=" + code;
        System.out.println(params);
    }

    private String getFileHash(String filePath) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return GetServiceFileSecureServlet.getHash(hashString + filePath);
    }

    private static String getHash(String stringToHash) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(stringToHash.getBytes("UTF-8"));
        byte[] md5hash = md.digest();
        return new String(Hex.encodeHex((byte[])md5hash));
    }

    @Override
    protected String createFileUrl(HttpServletRequest request, File f) {
        String url = super.createFileUrl(request, f);
        try {
            url = url + "&code=" + this.getFileHash(f.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)"Error while creating file url");
        }
        return url;
    }
}

