/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.struts.validator.DynaValidatorForm;

public final class FormUtils {
    public static int BooleanToInt(boolean thisbool) {
        return !thisbool ? 0 : 1;
    }

    public static boolean IntToBoolean(int thisint) {
        return thisint != 0;
    }

    public static Integer BooleanToInteger(boolean thisbool) {
        return !thisbool ? new Integer(0) : new Integer(1);
    }

    public static boolean IntegerToBoolean(Integer thisint) {
        if (thisint == null) {
            return false;
        }
        return thisint != 0;
    }

    public static Date StringToDate(String thisdate, Locale locale) {
        if (thisdate == null || thisdate.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("dd-MM-yyyy");
        Date soughtDate = null;
        try {
            soughtDate = sdf.parse(thisdate);
        }
        catch (Exception pe2) {
            return null;
        }
        return soughtDate;
    }

    public static Date FormStringToDate(String thisdate, Locale locale) {
        if (thisdate == null || thisdate.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("yyyy-MM-dd");
        Date soughtDate = null;
        try {
            soughtDate = sdf.parse(thisdate);
        }
        catch (Exception pe2) {
            return null;
        }
        return soughtDate;
    }

    public static String reformatDateString(String thisdate) {
        if (thisdate == null || thisdate.trim().length() != 8) {
            return null;
        }
        String theYear = thisdate.trim().substring(0, 4);
        String theMonth = thisdate.trim().substring(4, 6);
        String theDay = thisdate.trim().substring(6, 8);
        String newdate = theDay + "-" + theMonth + "-" + theYear;
        return newdate;
    }

    public static String reformatDateBigDecimal(BigDecimal thisdate) {
        if (thisdate == null) {
            return null;
        }
        return FormUtils.reformatDateString(Integer.toString(thisdate.intValue()));
    }

    public static Date reformatBigDecimalToDate(BigDecimal thisdate) {
        if (thisdate == null) {
            return null;
        }
        return FormUtils.FormStringToDate(FormUtils.reformatDateString(Integer.toString(thisdate.intValue())), null);
    }

    public static Date SortStringToDate(String thisdate, Locale locale) {
        return FormUtils.StringToDate(FormUtils.reformatDateString(thisdate), locale);
    }

    public static Date StringToTimestamp(String ts) {
        if (ts == null || ts.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
        Date soughtDate = null;
        try {
            soughtDate = sdf.parse(ts);
        }
        catch (Exception pe2) {
            return null;
        }
        return soughtDate;
    }

    public static String DateToString(Date thisdate, Locale locale) {
        if (thisdate != null) {
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("dd-MM-yyyy");
            return sdf.format(thisdate);
        }
        return "";
    }

    public static String DateToFormString(Date thisdate, Locale locale) {
        if (thisdate != null) {
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("yyyy-MM-dd");
            return sdf.format(thisdate);
        }
        return "";
    }

    public static String TimestampToString(Date thisdate) {
        if (thisdate != null) {
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("yyyy-MM-dd HH:mm:sss");
            return sdf.format(thisdate);
        }
        return "";
    }

    public static String DateToSortString(Date thisdate, Locale locale) {
        if (thisdate != null) {
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("yyyyMMdd");
            return sdf.format(thisdate);
        }
        return "";
    }

    public static int StringToInt(String thisstring) {
        try {
            return Integer.parseInt(thisstring);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String IntToString(int thisint) {
        return Integer.toString(thisint);
    }

    public static Integer StringToInteger(String thisstring) {
        try {
            return new Integer(thisstring);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long StringToLong(String thisstring) {
        try {
            return new Long(thisstring);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Short StringToShort(String thisstring) {
        try {
            return new Short(thisstring);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String IntegerToString(Integer thisint) {
        if (thisint == null) {
            return "";
        }
        return thisint.toString();
    }

    public static String LongToString(Long thislong) {
        if (thislong == null) {
            return "";
        }
        return thislong.toString();
    }

    public static String ShortToString(Short thisshort) {
        if (thisshort == null) {
            return "";
        }
        return thisshort.toString();
    }

    public static double StringToDbl(String thisstring) {
        if (thisstring == null) {
            return 0.0;
        }
        try {
            return new Double(thisstring);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static String DblToString(double thisdouble) {
        return new Double(thisdouble).toString();
    }

    public static Double StringToDouble(String thisstring) {
        if (thisstring == null) {
            return new Double("0");
        }
        try {
            return new Double(thisstring);
        }
        catch (NumberFormatException e) {
            return new Double("0");
        }
    }

    public static String DoubleToString(Double thisdouble) {
        if (thisdouble == null) {
            return "";
        }
        return thisdouble.toString();
    }

    public static String getString(String thisstring) {
        if (thisstring == null) {
            return "";
        }
        return thisstring;
    }

    public static String formatDouble(Double d, NumberFormat format) {
        if (d == null) {
            return "";
        }
        return format.format(d);
    }

    public static String formatDouble(double d, NumberFormat format) {
        return format.format(d);
    }

    public static Double parseDoubleAllowNull(String s, NumberFormat format) throws ParseException {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return new Double(format.parse(s).doubleValue());
    }

    public static double parseDouble(String s, NumberFormat format) throws ParseException {
        return format.parse(s).doubleValue();
    }

    public static String formatBigDecimal(BigDecimal bd, NumberFormat format) {
        if (bd == null) {
            return "";
        }
        return format.format(bd.doubleValue());
    }

    public static BigDecimal parseBigDecimal(String s, NumberFormat format) throws ParseException {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return new BigDecimal(format.parse(s).doubleValue());
    }

    public static String nullIfEmpty(String s) {
        if (s != null && s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    public static int intValue(BigDecimal val) {
        int tempInt = 0;
        if (val != null) {
            tempInt = val.intValue();
        }
        return tempInt;
    }

    public static float floatValue(BigDecimal val) {
        float tempFloat = 0.0f;
        if (val != null) {
            tempFloat = val.floatValue();
        }
        return tempFloat;
    }

    public static String stringValue(BigDecimal val) {
        String tempString = "";
        if (val != null) {
            tempString = val.toString();
        }
        return tempString;
    }

    public static boolean equalBD(BigDecimal val1, BigDecimal val2) {
        if (val1 == null && val2 == null) {
            return true;
        }
        if (val1 == null && val2 != null || val2 == null && val1 != null) {
            return false;
        }
        return val1.compareTo(val2) == 0;
    }

    public static BigDecimal bdValue(String ff) {
        if (ff == null) {
            return null;
        }
        BigDecimal retval = null;
        try {
            retval = new BigDecimal(ff);
        }
        catch (NumberFormatException nfe) {
            retval = new BigDecimal("0");
        }
        return retval;
    }

    public static BigDecimal bdValueNull(String ff) {
        if (ff == null) {
            return null;
        }
        BigDecimal retval = null;
        try {
            retval = new BigDecimal(ff);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return retval;
    }

    public static BigDecimal bdSure(BigDecimal bD) {
        if (bD == null) {
            return new BigDecimal("0");
        }
        return bD;
    }

    public static BigDecimal multiplyFactor(BigDecimal val, float factor) {
        int scale = 5;
        return FormUtils.multiplyFactor(val, factor, scale);
    }

    public static BigDecimal multiplyFactor(BigDecimal val, float factor, int scale) {
        if (val == null) {
            return new BigDecimal("0");
        }
        BigDecimal bdFactor = new BigDecimal(factor);
        BigDecimal result = val.multiply(bdFactor);
        return result.setScale(scale, 4);
    }

    public static boolean nullOrEmpty(String astr) {
        return astr == null || astr.length() == 0;
    }

    public static String[] getStringArray(DynaValidatorForm dynaform, String param) {
        return (String[])dynaform.get(param);
    }

    public static int getInteger(DynaValidatorForm dynaform, String param) {
        Integer i = (Integer)dynaform.get(param);
        return i != null ? i : -1;
    }

    public static boolean getBoolean(DynaValidatorForm dynaform, String param) {
        Boolean bo = (Boolean)dynaform.get(param);
        return bo != null && bo != false;
    }

    public static String bytesToSizeFormat(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        NumberFormat f = NumberFormat.getNumberInstance(new Locale("nl"));
        f.setMaximumFractionDigits(1);
        f.setMinimumFractionDigits(1);
        if (bytes < 0x100000L) {
            return f.format((double)bytes / 1024.0) + " kB";
        }
        if (bytes < 0x40000000L) {
            return f.format((double)bytes / 1048576.0) + " MB";
        }
        return f.format((double)bytes / 1.073741824E9) + " GB";
    }
}

