/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.clieop3;

import java.math.BigInteger;

public class RekeningnummerChecker {
    private RekeningnummerChecker() {
    }

    public static boolean isMogelijkGiroNummer(BigInteger rekeningnummer) {
        if (rekeningnummer.signum() != 1) {
            return false;
        }
        int len = rekeningnummer.toString().length();
        return len > 0 && len <= 7;
    }

    public static boolean isMogelijkBankrekeningNummer(BigInteger rekeningnummer) {
        if (rekeningnummer.signum() != 1) {
            return false;
        }
        int len = rekeningnummer.toString().length();
        return len == 9 || len == 10;
    }

    public static boolean voldoetAanElfProef(BigInteger bankrekeningNummer) {
        int len;
        if (!RekeningnummerChecker.isMogelijkBankrekeningNummer(bankrekeningNummer)) {
            return false;
        }
        String rekNr = bankrekeningNummer.toString();
        int m = len = rekNr.length();
        int v = 0;
        for (int i = 0; i < len; ++i) {
            char c = rekNr.charAt(i);
            int cijfer = c - 48;
            v += cijfer * m--;
        }
        return v % 11 == 0;
    }
}

