/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.oai.util.xml;

import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XMLTool {
    public static Document createDocumentRoot() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            return doc;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static void Dom2Stream(Document doc, Writer writer) {
        if (doc == null) {
            System.out.println("doc is null");
        } else {
            System.out.println(doc);
        }
        if (writer == null) {
            System.out.println("writer is null");
        }
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (Exception e) {
            try {
                writer.write(XMLTool.output(doc));
                e.printStackTrace();
            }
            catch (Exception ex) {
                System.out.println(e);
            }
        }
    }

    public static String output(Document doc) {
        String out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        out = out + XMLTool.showElement(doc.getDocumentElement());
        return out;
    }

    public static String showElement(Element e) {
        String out = "<" + e.getNodeName() + " ";
        NamedNodeMap map = e.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            out = out + map.item(i).getNodeName() + "=\"" + map.item(i).getNodeValue() + "\" ";
        }
        out = out + ">\n";
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() == 1) {
                out = out + XMLTool.showElement((Element)nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeType() == 3) {
                out = out + nl.item(i).getNodeValue();
                continue;
            }
            System.out.println("other node");
        }
        out = out + "</" + e.getNodeName() + ">";
        return out;
    }
}

