/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.security.aselect;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.security.aselect.ASelectTicket;
import org.securityfilter.authenticator.Authenticator;
import org.securityfilter.config.SecurityConfig;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.filter.URLPatternMatcher;
import org.securityfilter.realm.SecurityRealmInterface;

public class ASelectFilterAuthenticator
implements Authenticator {
    protected SecurityRealmInterface realm;
    protected String realmName;
    public static final String ERROR_NO_ASELECT_TICKET = "Geen A-Select ticket!";
    public static final String ERROR_USERNAME_NOT_AUTHORIZED = "A-Select gebruiker niet geauthoriseerd voor deze applicatie!";

    public void init(FilterConfig filterConfig, SecurityConfig securityConfig) throws Exception {
        this.realm = securityConfig.getRealm();
        this.realmName = securityConfig.getRealmName();
    }

    public String getAuthMethod() {
        return "ASELECTFILTER";
    }

    public boolean processLogin(SecurityRequestWrapper request, HttpServletResponse response) throws Exception {
        if (request.getUserPrincipal() == null) {
            ASelectTicket ticket = ASelectTicket.getFromSession(request.getSession());
            if (ticket == null) {
                return false;
            }
            Principal principal = this.realm.authenticate(ticket.getUid(), "");
            if (principal != null) {
                request.setUserPrincipal(principal);
            } else {
                return false;
            }
        }
        return false;
    }

    public void showLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ASelectTicket ticket = ASelectTicket.getFromSession(request.getSession());
        response.sendError(403, ticket == null ? ERROR_NO_ASELECT_TICKET : ERROR_USERNAME_NOT_AUTHORIZED);
    }

    public boolean bypassSecurityForThisRequest(SecurityRequestWrapper request, URLPatternMatcher patternMatcher) {
        return false;
    }

    public boolean processLogout(SecurityRequestWrapper request, HttpServletResponse response, URLPatternMatcher patternMatcher) {
        return false;
    }
}

