/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.clieop3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import nl.b3p.commons.clieop3.BatchTotalen;
import nl.b3p.commons.clieop3.record.BatchEnd;
import nl.b3p.commons.clieop3.record.BatchStart;
import nl.b3p.commons.clieop3.record.BestandEnd;
import nl.b3p.commons.clieop3.record.BestandStart;
import nl.b3p.commons.clieop3.record.Betalingskenmerk;
import nl.b3p.commons.clieop3.record.NaamBegunstigde;
import nl.b3p.commons.clieop3.record.Omschrijving;
import nl.b3p.commons.clieop3.record.Opdrachtgever;
import nl.b3p.commons.clieop3.record.Record;
import nl.b3p.commons.clieop3.record.Transactie;
import nl.b3p.commons.clieop3.record.VasteOmschrijving;
import nl.b3p.commons.clieop3.record.WoonplaatsBegunstigde;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClieOp3OutputStream {
    private static final Log log = LogFactory.getLog(ClieOp3OutputStream.class);
    public static final int MAX_POSTEN = 100000;
    public static final int RECORD_LENGTH = 50;
    private static final int MAX_REGELS = 4;
    private OutputStreamWriter writer;
    private BatchState batchState = null;
    private int batchCount = 0;
    private BigInteger totaalRekeningnummers = new BigInteger("0");
    private static final String allowed = " .()+&$*:;-/,%?@='\"";

    public ClieOp3OutputStream(OutputStream out, BestandStart bestand) throws IOException {
        this.writer = new OutputStreamWriter(out, "US-ASCII");
        this.writeRecord(bestand);
    }

    private void writeRecord(Record record) throws IOException {
        this.writer.write(record.getRecordData(), 0, 50);
        this.writer.write(13);
        this.writer.write(10);
    }

    public static String replaceForbiddenChars(String text) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || allowed.indexOf(c) != -1) continue;
            chars[i] = 63;
        }
        return new String(chars);
    }

    public static String cleanClieOp3String(String str) {
        return ClieOp3OutputStream.replaceForbiddenChars(str);
    }

    public void endBestand() throws IOException {
        if (this.batchState != null) {
            this.endBatch();
        }
        this.writeRecord(new BestandEnd());
        this.writer.flush();
    }

    public void startBatch(BatchStart batch, VasteOmschrijving[] vasteOmschrijvingRegels, Opdrachtgever opdrachtgever) throws IOException {
        if (this.batchState != null) {
            this.endBatch();
        }
        batch.setVolgnummer(++this.batchCount);
        this.writeRecord(batch);
        this.batchState = new BatchState();
        this.batchState.postCount = 0;
        this.batchState.totaalBedragCenten = new BigInteger("0");
        this.batchState.totaalRekeningnummers = new BigInteger("0");
        if (vasteOmschrijvingRegels != null) {
            this.batchState.vasteOmschrijvingenCount = vasteOmschrijvingRegels.length;
            int max = Math.min(4, this.batchState.vasteOmschrijvingenCount);
            for (int i = 0; i < max; ++i) {
                this.writeRecord(vasteOmschrijvingRegels[i]);
            }
        }
        this.writeRecord(opdrachtgever);
    }

    public void addBetaalPost(Transactie transactie, Betalingskenmerk betalingskenmerk, Omschrijving[] omschrijvingsRegels, NaamBegunstigde naamBegunstigde, WoonplaatsBegunstigde woonplaatsBegunstigde) throws IOException {
        if (this.batchState == null) {
            throw new IllegalStateException("niet in batch");
        }
        if (this.batchState.postCount == 100000) {
            throw new IllegalStateException("maximaal aantal posten bereikt");
        }
        this.writeRecord(transactie);
        this.batchState.totaalBedragCenten = this.batchState.totaalBedragCenten.add(transactie.getBedragCenten());
        this.batchState.totaalRekeningnummers = this.batchState.totaalRekeningnummers.add(transactie.getRekeningnummberBegunstigde());
        this.batchState.totaalRekeningnummers = this.batchState.totaalRekeningnummers.add(transactie.getRekeningnummerBetaler());
        if (betalingskenmerk != null) {
            this.writeRecord(betalingskenmerk);
        }
        if (omschrijvingsRegels != null) {
            int maxOmschrijvingen = 4;
            maxOmschrijvingen -= this.batchState.vasteOmschrijvingenCount;
            if (betalingskenmerk != null) {
                --maxOmschrijvingen;
            }
            int max = Math.min(maxOmschrijvingen, omschrijvingsRegels.length);
            for (int i = 0; i < max; ++i) {
                this.writeRecord(omschrijvingsRegels[i]);
            }
        }
        if (naamBegunstigde != null) {
            this.writeRecord(naamBegunstigde);
        }
        if (woonplaatsBegunstigde != null) {
            this.writeRecord(woonplaatsBegunstigde);
        }
        ++this.batchState.postCount;
    }

    public BatchTotalen endBatch() throws IOException {
        if (this.batchState == null) {
            throw new IllegalStateException("niet in batch");
        }
        if (this.batchState.postCount == 0) {
            throw new IllegalStateException("minimaal een post per batch");
        }
        this.writeRecord(new BatchEnd(this.batchState.totaalBedragCenten, this.batchState.totaalRekeningnummers, this.batchState.postCount));
        BatchTotalen result = new BatchTotalen(this.batchState.totaalBedragCenten, this.batchState.totaalRekeningnummers, this.batchState.postCount, this.batchCount);
        this.batchState = null;
        return result;
    }

    private class BatchState {
        int vasteOmschrijvingenCount;
        BigInteger totaalBedragCenten;
        BigInteger totaalRekeningnummers;
        int postCount = 0;

        private BatchState() {
        }
    }
}

