/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.jpa;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JpaUtilServlet
implements Servlet {
    private static final Log log = LogFactory.getLog(JpaUtilServlet.class);
    private ServletConfig config;
    private static final Map<String, EntityManagerFactory> entityManagerFactories = new HashMap<String, EntityManagerFactory>();
    private static final ThreadLocal<Map<String, EntityManager>> entityManagers = new ThreadLocal();
    private static String defaultPersistenceUnit;

    public String getServletInfo() {
        return this.getClass().getName();
    }

    public static void setDefaultPersistenceUnit(String pu) {
        defaultPersistenceUnit = pu;
    }

    public void init(ServletConfig config) throws ServletException {
        String initializePersistenceUnits;
        this.config = config;
        String defaultPu = config.getInitParameter("default-persistence-unit");
        if (defaultPu != null && defaultPu.trim().length() > 0) {
            defaultPersistenceUnit = defaultPu;
            log.info((Object)("Default persistence unit set to " + defaultPu + " - returning this unit for JpaUtilServlet.getEntityManager()"));
        }
        if ((initializePersistenceUnits = config.getInitParameter("initialize-persistence-units")) != null && initializePersistenceUnits.trim().length() > 0) {
            String[] units = initializePersistenceUnits.trim().split(",");
            for (int i = 0; i < units.length; ++i) {
                String pu = units[i];
                long startTime = System.currentTimeMillis();
                try {
                    log.info((Object)("Initializing entity manager factory for persistence unit " + pu));
                    EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)pu);
                    entityManagerFactories.put(pu, emf);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Exception initializing entity manager factory for persistence unit " + pu;
                    log.error((Object)msg, (Throwable)e);
                    throw new ServletException(msg, (Throwable)e);
                }
                finally {
                    if (log.isDebugEnabled()) {
                        long timeMs = System.currentTimeMillis() - startTime;
                        String time = NumberFormat.getInstance(Locale.ENGLISH).format((double)timeMs / 1000.0);
                        log.debug((Object)("Initializing entity manager factory for persistence unit " + pu + " took " + time + " s"));
                    }
                }
            }
            if (defaultPersistenceUnit == null && units.length == 1) {
                defaultPersistenceUnit = units[0];
                log.info((Object)("Automatically setting default persistence unit to the only unit to initialize: " + defaultPersistenceUnit + "- returning this unit for JpaUtilServlet.getEntityManager()"));
            }
        } else {
            log.warn((Object)"No persistence unit configured to be initialized - will be initialized on request for EntityManager; use the \"initialize-persistence-units\" init parameter");
        }
    }

    public static EntityManager getThreadEntityManager() throws IllegalArgumentException {
        if (defaultPersistenceUnit == null) {
            throw new IllegalArgumentException("No default persistence unit configured");
        }
        return JpaUtilServlet.getThreadEntityManager(defaultPersistenceUnit);
    }

    public static EntityManager getThreadEntityManager(String persistenceUnit) {
        EntityManager em;
        Map<String, EntityManager> ems = entityManagers.get();
        if (ems == null) {
            ems = new HashMap<String, EntityManager>();
            entityManagers.set(ems);
        }
        if ((em = ems.get(persistenceUnit)) == null) {
            EntityManagerFactory emf = JpaUtilServlet.getEntityManagerFactory(persistenceUnit);
            em = emf.createEntityManager();
            ems.put(persistenceUnit, em);
        }
        return em;
    }

    public static EntityManagerFactory getEntityManagerFactory() {
        if (defaultPersistenceUnit == null) {
            throw new IllegalArgumentException("No default persistence unit configured");
        }
        return JpaUtilServlet.getEntityManagerFactory(defaultPersistenceUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityManagerFactory getEntityManagerFactory(String persistenceUnit) {
        EntityManagerFactory emf = null;
        Map<String, EntityManagerFactory> map = entityManagerFactories;
        synchronized (map) {
            emf = entityManagerFactories.get(persistenceUnit);
            if (emf == null) {
                log.info((Object)("Initializing entity manager factory for persistance unit " + persistenceUnit));
                emf = Persistence.createEntityManagerFactory((String)persistenceUnit);
                entityManagerFactories.put(persistenceUnit, emf);
            }
        }
        return emf;
    }

    public static void closeThreadEntityManager() {
        if (defaultPersistenceUnit == null) {
            throw new IllegalArgumentException("No default persistence unit configured");
        }
        JpaUtilServlet.closeThreadEntityManager(defaultPersistenceUnit);
    }

    public static void closeThreadEntityManager(String persistenceUnit) {
        EntityManager em;
        Map<String, EntityManager> ems = entityManagers.get();
        if (ems != null && (em = ems.get(persistenceUnit)) != null) {
            ems.remove(persistenceUnit);
            em.close();
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
        Collection<EntityManagerFactory> factories = entityManagerFactories.values();
        if (!factories.isEmpty()) {
            for (EntityManagerFactory emf : factories) {
                emf.close();
            }
        }
    }
}

