/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MIMETypes {
    private static final Map mimeTypes;

    public static String getMIMETypeForExt(String ext) {
        return (String)mimeTypes.get(ext.trim().toLowerCase());
    }

    public static String getMIMETypeForFilename(String filename) {
        int dotPos = filename.lastIndexOf(46);
        int dirSepPos = Math.max(filename.lastIndexOf(92), filename.lastIndexOf(47));
        if (dotPos == -1 || dotPos == filename.length() - 1 || dotPos < dirSepPos) {
            return null;
        }
        String ext = filename.substring(dotPos + 1);
        return MIMETypes.getMIMETypeForExt(ext);
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("asc", "text/plain");
        m.put("bmp", "image/bmp");
        m.put("css", "text/css");
        m.put("doc", "application/msword");
        m.put("dtd", "application/xml-dtd");
        m.put("eps", "application/postscript");
        m.put("gif", "image/gif");
        m.put("htm", "text/html");
        m.put("html", "text/html");
        m.put("jpeg", "image/jpeg");
        m.put("jpg", "image/jpeg");
        m.put("pdf", "application/pdf");
        m.put("png", "image/png");
        m.put("ppt", "application/vnd.ms-powerpoint");
        m.put("ps", "application/postscript");
        m.put("rtf", "text/rtf");
        m.put("tif", "image/tiff");
        m.put("tiff", "image/tiff");
        m.put("txt", "text/plain");
        m.put("xht", "application/xhtml+xml");
        m.put("xhtml", "application/xhtml+xml");
        m.put("xls", "application/vnd.ms-excel");
        m.put("xml", "application/xml");
        m.put("xsl", "application/xml");
        m.put("xslt", "application/xslt+xml");
        m.put("zip", "application/zip");
        m.put("hqx", "application/mac-binhex40");
        m.put("bin", "application/octet-stream");
        m.put("exe", "application/octet-stream");
        m.put("class", "application/octet-stream");
        m.put("so", "application/octet-stream");
        m.put("dll", "application/octet-stream");
        m.put("ogg", "application/ogg");
        m.put("js", "application/x-javascript");
        m.put("swf", "application/x-shockwave-flash");
        m.put("sit", "application/x-stuffit");
        m.put("tar", "application/x-tar");
        m.put("au", "audio/basic");
        m.put("snd", "audio/basic");
        m.put("mid", "audio/midi");
        m.put("midi", "audio/midi");
        m.put("mpga", "audio/mpeg");
        m.put("mp2", "audio/mpeg");
        m.put("mp3", "audio/mpeg");
        m.put("aif", "audio/x-aiff");
        m.put("aiff", "audio/x-aiff");
        m.put("aiffc", "audio/x-aiff");
        m.put("wav", "audio/x-wav");
        m.put("svg", "image/svg+xml");
        m.put("mpeg", "video/mpeg");
        m.put("mpg", "video/mpeg");
        m.put("mpe", "video/mpeg");
        m.put("qt", "video/quicktime");
        m.put("mov", "video/quicktime");
        m.put("avi", "video/x-msvideo");
        mimeTypes = Collections.unmodifiableMap(m);
    }
}

