/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.clieop3.record;

import java.math.BigInteger;
import nl.b3p.commons.clieop3.PadUtils;
import nl.b3p.commons.clieop3.RekeningnummerChecker;
import nl.b3p.commons.clieop3.record.Record;

public class Transactie
extends Record {
    private static final String RECORDCODE = "0100";
    private static final char VARIANTCODE = 'A';
    public static final String TRANSACTIE_ONZUIVERE_CREDITEURENBETALING = "0000";
    public static final String TRANSACTIE_ONZUIVERE_SALARISBETALING = "0003";
    public static final String TRANSACTIE_ZUIVERE_CREDITEURENBETALING = "0005";
    public static final String TRANSACTIE_ZUIVERE_SALARISBETALING = "0008";
    public static final String TRANSACTIE_ZUIVERE_INCASSO = "1001";
    public static final String TRANSACTIE_ONZUIVERE_INCASSO = "1002";
    public static final int TRANSACTIE_BETALING = 0;
    public static final int TRANSATIIE_SALARIS = 1;
    public static final int TRANSACTIE_INCASSO = 2;
    private String transactieSoort;
    private BigInteger bedragCenten;
    private BigInteger rekeningnummerBetaler;
    private BigInteger rekeningnummerBegunstigde;

    public Transactie(String transactieSoort, BigInteger bedragCenten, BigInteger rekeningnummerBetaler, BigInteger rekeningnummerBegunstigde) {
        super(RECORDCODE, 'A');
        this.transactieSoort = transactieSoort;
        this.bedragCenten = bedragCenten;
        this.rekeningnummerBetaler = rekeningnummerBetaler;
        this.rekeningnummerBegunstigde = rekeningnummerBegunstigde;
    }

    public String getTransactieSoort() {
        return this.transactieSoort;
    }

    public BigInteger getBedragCenten() {
        return this.bedragCenten;
    }

    public BigInteger getRekeningnummerBetaler() {
        return this.rekeningnummerBetaler;
    }

    public BigInteger getRekeningnummberBegunstigde() {
        return this.rekeningnummerBegunstigde;
    }

    @Override
    protected void appendRecordContents(StringBuffer buf) {
        buf.append(this.transactieSoort);
        PadUtils.padNumber(this.bedragCenten.toString(), 12, buf);
        PadUtils.padNumber(this.rekeningnummerBetaler.toString(), 10, buf);
        PadUtils.padNumber(this.rekeningnummerBegunstigde.toString(), 10, buf);
    }

    public static String getTransactieSoort(BigInteger rekeningnummer, int soort) {
        if (RekeningnummerChecker.voldoetAanElfProef(rekeningnummer)) {
            switch (soort) {
                case 0: {
                    return TRANSACTIE_ZUIVERE_CREDITEURENBETALING;
                }
                case 1: {
                    return TRANSACTIE_ZUIVERE_SALARISBETALING;
                }
                case 2: {
                    return TRANSACTIE_ZUIVERE_INCASSO;
                }
            }
            throw new IllegalArgumentException("ongeldige soort: " + soort);
        }
        if (RekeningnummerChecker.isMogelijkGiroNummer(rekeningnummer)) {
            switch (soort) {
                case 0: {
                    return TRANSACTIE_ONZUIVERE_CREDITEURENBETALING;
                }
                case 1: {
                    return TRANSACTIE_ONZUIVERE_SALARISBETALING;
                }
                case 2: {
                    return TRANSACTIE_ONZUIVERE_INCASSO;
                }
            }
            throw new IllegalArgumentException("ongeldige soort: " + soort);
        }
        throw new IllegalArgumentException("ongeldig rekeningnummer: " + rekeningnummer);
    }
}

