/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.MDC;

public class HttpInfoMDCLoggerFilter
implements Filter {
    boolean createSession;
    private static final String KEY_REMOTE_ADDR = "HttpRemoteAddr";
    private static final String KEY_REMOTE_PORT = "HttpRemotePort";
    private static final String KEY_REQUEST_URI = "HttpRequestURI";
    private static final String KEY_SESSION_ID = "HttpSessionId";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.createSession = "true".equals(filterConfig.getInitParameter("createSession"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        MDC.put((String)KEY_REMOTE_ADDR, (Object)req.getRemoteAddr());
        MDC.put((String)KEY_REMOTE_PORT, (Object)(req.getRemotePort() + ""));
        MDC.put((String)KEY_REQUEST_URI, (Object)req.getRequestURI());
        if (this.createSession) {
            MDC.put((String)KEY_SESSION_ID, (Object)req.getSession().getId());
        } else {
            HttpSession sess = req.getSession(false);
            if (sess != null) {
                MDC.put((String)KEY_SESSION_ID, (Object)req.getSession().getId());
            } else {
                MDC.remove((String)KEY_SESSION_ID);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

