/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.commons.services.B3pCommonsException;
import nl.b3p.commons.services.FormBaseBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;

public abstract class EditBaseBean
extends FormBaseBean {
    protected Log log = LogFactory.getLog(this.getClass());
    private String newAction = null;
    protected Object theObject = null;
    protected ArrayList subObjects = new ArrayList();
    public static final String INVALID_ACTION = "INVALID";
    public static final String CANCELLED_ACTION = "CANCELLED";
    public static final String START_ACTION = "Start";
    public static final String EDIT_ACTION = "Edit";
    public static final String NEW_ACTION = "New";
    public static final String SAVE_ACTION = "Save";
    public static final String SAVENEW_ACTION = "SaveNew";
    public static final String DELETE_ACTION = "Delete";
    public static final String SUBDELETE_ACTION = "SubDelete";
    public static final String SUBNEW_ACTION = "SubNew";
    public static final String SUBSAVENEW_ACTION = "SubSaveNew";
    public static final String SUBSAVE_ACTION = "SubSave";
    public static final String SUBEDIT_ACTION = "SubEdit";
    public static final String OK_BUTTON = "ok";
    public static final String CANCEL_BUTTON = "cancel";
    public static final String DELETE_BUTTON = "delete";
    public static final String NEW_BUTTON = "new";
    public static final String SAVE_BUTTON = "save";
    public static final String SAVENEW_BUTTON = "savenew";
    public static final String EDIT_BUTTON = "edit";
    public static final String SUBNEW_BUTTON = "subnew";
    public static final String SUBSAVE_BUTTON = "subsave";
    public static final String SUBSAVENEW_BUTTON = "subsavenew";
    public static final String SUBDELETE_BUTTON = "subdelete";
    public static final String SUBEDIT_BUTTON = "subedit";
    public static final String NEWJOIN_BUTTON = "newjoin";
    public static final String DELETEJOIN_BUTTON = "deletejoin";
    public static final String MAIN_MESSAGE = "MAIN_MESSAGE";
    public static final String SUB_MESSAGE = "SUB_MESSAGE";
    protected static int TEMPNEW_ID = -1;
    private boolean directSave = false;
    private boolean directDelete = false;
    private boolean directSubSave = false;
    private boolean directSubDelete = false;
    private boolean returnAfterSubSave = true;
    private boolean allowEdits = true;

    public EditBaseBean(HttpServletRequest req, DynaValidatorForm dform, ActionMapping mapp) {
        this(req, null, null, null, dform, mapp);
    }

    public EditBaseBean(HttpServletRequest req, Locale loc, MessageResources mess, ActionMessages err, DynaValidatorForm dform, ActionMapping mapp) {
        super(req, loc, mess, err, dform, mapp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward process(boolean tokenValid, boolean transactionCancelled, ActionErrors validateErrors) {
        if (!this.isInit) {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("error.invoerenrecord.general"));
            return this.mapping.findForward("failure");
        }
        ActionForward f = null;
        try {
            int subNum;
            int numOfSubs;
            ActionErrors verrs = this.determineAction(tokenValid, transactionCancelled, validateErrors);
            this.determineObjects();
            if (this.buttonPressed(OK_BUTTON)) {
                f = this.confirmButton(verrs);
            } else if (this.buttonPressed(CANCEL_BUTTON)) {
                f = this.cancelButton();
            } else if (this.buttonPressed(DELETE_BUTTON)) {
                f = this.deleteButton();
            } else if (this.buttonPressed(NEW_BUTTON)) {
                f = this.newButton();
            } else if (this.buttonPressed(SAVE_BUTTON)) {
                f = this.saveButton(verrs);
            } else if (this.buttonPressed(SAVENEW_BUTTON)) {
                f = this.saveNewButton(verrs);
            } else if (this.buttonPressed(EDIT_BUTTON)) {
                f = this.editButton(verrs);
            } else {
                numOfSubs = this.subObjects.size();
                for (subNum = 1; subNum <= numOfSubs; ++subNum) {
                    if (this.buttonPressed(SUBNEW_BUTTON + subNum)) {
                        f = this.subNewButton(subNum);
                        break;
                    }
                    if (this.buttonPressed(SUBSAVE_BUTTON + subNum)) {
                        f = this.subSaveButton(subNum, verrs);
                        break;
                    }
                    if (this.buttonPressed(SUBSAVENEW_BUTTON + subNum)) {
                        f = this.subSaveNewButton(subNum, verrs);
                        break;
                    }
                    if (this.buttonPressed(SUBDELETE_BUTTON + subNum)) {
                        f = this.subDeleteButton(subNum);
                        break;
                    }
                    if (this.buttonPressed(SUBEDIT_BUTTON + subNum)) {
                        f = this.subEditButton(subNum);
                        break;
                    }
                    if (this.buttonPressed(NEWJOIN_BUTTON + subNum)) {
                        f = this.newJoinButton(subNum, verrs);
                        break;
                    }
                    if (!this.buttonPressed(DELETEJOIN_BUTTON + subNum)) continue;
                    f = this.deleteJoinButton(subNum, verrs);
                    break;
                }
            }
            if (f != null) {
                return f;
            }
            f = this.populateMainForm();
            if (f != null) {
                return f;
            }
            if (this.theObject != null) {
                numOfSubs = this.subObjects.size();
                for (subNum = 1; subNum <= numOfSubs; ++subNum) {
                    f = this.populateSubForms(subNum);
                    if (f == null) continue;
                    return f;
                }
            }
            this.determineNewAction();
        }
        catch (Exception e) {
            this.log.error((Object)"error: ", (Throwable)e);
            this.errors.add(MAIN_MESSAGE, new ActionMessage("error.database", (Object)e.getMessage()));
            return this.mapping.findForward("failure");
        }
        try {
            this.createJoinList();
            this.createLists();
            f = this.userProcess(tokenValid, transactionCancelled, validateErrors);
            if (f == null) return this.mapping.findForward("success");
            if (!f.getName().equals("none")) return f;
            return null;
        }
        catch (B3pCommonsException be) {
            this.log.error((Object)"error2: ", (Throwable)be);
            this.errors.add(MAIN_MESSAGE, new ActionMessage("error.invoerenrecord.general", (Object)be.getMessage()));
            return this.mapping.findForward("failure");
        }
    }

    protected ActionErrors determineAction(boolean tokenValid, boolean transactionCancelled, ActionErrors validateErrors) throws B3pCommonsException {
        this.newAction = this.action = this.getParamAsString("action");
        if (EditBaseBean.nullOrEmpty(this.action)) {
            this.action = START_ACTION;
            this.newAction = EDIT_ACTION;
        }
        if (!this.isAction(START_ACTION)) {
            if (!tokenValid) {
                this.errors.add(MAIN_MESSAGE, new ActionMessage("error.transaction.token"));
                this.action = INVALID_ACTION;
                this.newAction = EDIT_ACTION;
            }
        } else {
            validateErrors = null;
            this.action = EDIT_ACTION;
            this.newAction = EDIT_ACTION;
        }
        if (transactionCancelled) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" Transaction '" + this.action + "' was cancelled"));
            }
            this.action = CANCELLED_ACTION;
            this.newAction = EDIT_ACTION;
        }
        return validateErrors;
    }

    protected void determineObjects() {
        this.theObject = null;
        try {
            this.theObject = this.getMainObject();
        }
        catch (B3pCommonsException ex) {
            this.log.debug((Object)"no main object!");
        }
        if (this.theObject == null) {
            return;
        }
        int subNum = 1;
        do {
            try {
                this.subObjects.add(this.getSubObject(subNum));
            }
            catch (B3pCommonsException ex) {
                this.log.debug((Object)("no subobject" + subNum + "!"));
            }
        } while (++subNum <= 10);
    }

    protected ActionForward userProcess(boolean tokenValid, boolean transactionCancelled, ActionErrors validateErrors) throws B3pCommonsException {
        return null;
    }

    protected ActionForward confirmButton(ActionErrors validateErrors) throws B3pCommonsException {
        if (this.allowEdits) {
            if (this.isAction(SAVE_ACTION)) {
                return this.saveAction(validateErrors);
            }
            if (this.isAction(DELETE_ACTION) && this.theObject != null) {
                return this.deleteAction();
            }
            int numOfSubs = this.subObjects.size();
            for (int subNum = 1; subNum <= numOfSubs; ++subNum) {
                String subSaveAction;
                Object subObject = this.subObjects.get(subNum - 1);
                if ((subObject != null || Integer.toString(TEMPNEW_ID).equals(this.getSubID(subNum))) && (subSaveAction = SUBSAVE_ACTION + subNum).equals(this.action)) {
                    return this.subSaveAction(subNum, validateErrors);
                }
                String subDeleteAction = SUBDELETE_ACTION + subNum;
                if (!subDeleteAction.equals(this.action) || subObject == null) continue;
                return this.subDeleteAction(subNum);
            }
        } else {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
            this.newAction = EDIT_ACTION;
        }
        return null;
    }

    protected ActionForward cancelButton() throws B3pCommonsException {
        this.log.info((Object)" Cancel action");
        int numOfSubs = this.subObjects.size();
        for (int subNum = 1; subNum <= numOfSubs; ++subNum) {
            Object subObject = this.getNewSubObject(subNum);
            this.subObjects.set(subNum - 1, subObject);
            this.setSubID(subNum, "");
        }
        this.newAction = EDIT_ACTION;
        return null;
    }

    protected ActionForward deleteButton() throws B3pCommonsException {
        if (this.isAction(EDIT_ACTION) && this.allowEdits && this.theObject != null) {
            if (this.directDelete) {
                return this.deleteAction();
            }
            this.log.debug((Object)" delete");
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.delete"));
            this.newAction = DELETE_ACTION;
        } else {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
        }
        return null;
    }

    protected ActionForward newButton() throws B3pCommonsException {
        if (this.isAction(EDIT_ACTION) && this.allowEdits) {
            this.log.debug((Object)(" Reset DynaForm bean under key " + this.mapping.getAttribute()));
            this.form.initialize(this.mapping);
            this.theObject = this.getNewObject();
            this.setID(Integer.toString(TEMPNEW_ID));
            int numOfSubs = this.subObjects.size();
            for (int subNum = 1; subNum <= numOfSubs; ++subNum) {
                this.setSubID(subNum, null);
                Object subObject = this.getNewSubObject(subNum);
                this.subObjects.set(subNum - 1, subObject);
            }
            this.log.debug((Object)" create new");
        } else {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
        }
        this.newAction = EDIT_ACTION;
        return null;
    }

    protected ActionForward saveButton(ActionErrors validateErrors) throws B3pCommonsException {
        if (this.isAction(EDIT_ACTION) && this.allowEdits) {
            if (this.directSave) {
                return this.saveAction(validateErrors);
            }
            if (this.theObject != null) {
                this.log.debug((Object)" save existing");
                this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.save"));
            } else {
                this.log.debug((Object)" create new");
                this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.new"));
            }
            this.newAction = SAVE_ACTION;
        } else {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
        }
        return null;
    }

    protected ActionForward saveNewButton(ActionErrors validateErrors) throws B3pCommonsException {
        if (this.isAction(EDIT_ACTION) && this.allowEdits) {
            this.log.debug((Object)" save current");
            this.saveAction(validateErrors);
            this.form.initialize(this.mapping);
            this.theObject = this.getNewObject();
            this.setID(Integer.toString(TEMPNEW_ID));
            int numOfSubs = this.subObjects.size();
            for (int subNum = 1; subNum <= numOfSubs; ++subNum) {
                this.setSubID(subNum, null);
                Object subObject = this.getNewSubObject(subNum);
                this.subObjects.set(subNum - 1, subObject);
            }
            this.log.debug((Object)" create new");
        } else {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
        }
        return null;
    }

    protected ActionForward editButton(ActionErrors validateErrors) throws B3pCommonsException {
        this.newAction = EDIT_ACTION;
        return null;
    }

    protected ActionForward subNewButton(int subNum) throws B3pCommonsException {
        String subEditAction = SUBEDIT_ACTION + subNum;
        if ((this.isAction(EDIT_ACTION) || this.isAction(subEditAction)) && this.allowEdits) {
            Object subObject = this.subObjects.get(subNum - 1);
            this.setSubID(subNum, Integer.toString(TEMPNEW_ID));
            subObject = this.getNewSubObject(subNum);
            this.subObjects.set(subNum - 1, subObject);
            this.newAction = SUBEDIT_ACTION + subNum;
        } else {
            this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.notallowed"));
            this.newAction = EDIT_ACTION;
        }
        return null;
    }

    protected ActionForward subSaveButton(int subNum, ActionErrors validateErrors) throws B3pCommonsException {
        Object subObject = this.subObjects.get(subNum - 1);
        String subEditAction = SUBEDIT_ACTION + subNum;
        if (this.isAction(subEditAction) && this.allowEdits) {
            if (this.directSubSave) {
                return this.subSaveAction(subNum, validateErrors);
            }
            if (subObject != null) {
                this.log.debug((Object)" subsave existing");
                this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.subsave", (Object)this.getSubNames(subNum)));
            } else {
                this.log.debug((Object)" create subnew");
                this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.subnew", (Object)this.getSubNames(subNum)));
            }
            this.newAction = SUBSAVE_ACTION + subNum;
        } else {
            this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.notallowed"));
        }
        return null;
    }

    protected ActionForward subSaveNewButton(int subNum, ActionErrors validateErrors) throws B3pCommonsException {
        Object subObject = this.subObjects.get(subNum - 1);
        String subEditAction = SUBEDIT_ACTION + subNum;
        if (this.isAction(subEditAction) && this.allowEdits) {
            this.subSaveAction(subNum, validateErrors);
            this.setSubID(subNum, Integer.toString(TEMPNEW_ID));
            subObject = this.getNewSubObject(subNum);
            this.subObjects.set(subNum - 1, subObject);
        } else {
            this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.notallowed"));
        }
        return null;
    }

    protected ActionForward subDeleteButton(int subNum) throws B3pCommonsException {
        Object subObject = this.subObjects.get(subNum - 1);
        String subEditAction = SUBEDIT_ACTION + subNum;
        if (this.isAction(subEditAction) && this.allowEdits && subObject != null) {
            if (this.directSubDelete) {
                return this.subDeleteAction(subNum);
            }
            this.log.debug((Object)" delete subrecord");
            this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.subdelete", (Object)this.getSubNames(subNum)));
            this.newAction = SUBDELETE_ACTION + subNum;
        } else {
            this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.notallowed"));
            this.newAction = EDIT_ACTION;
        }
        return null;
    }

    protected ActionForward subEditButton(int subNum) throws B3pCommonsException {
        Object subObject = this.subObjects.get(subNum - 1);
        if (subObject != null) {
            this.log.debug((Object)" edit subrecord");
            this.newAction = SUBEDIT_ACTION + subNum;
        } else {
            this.log.debug((Object)" edit subrecord, but no subrecord present");
        }
        return null;
    }

    protected ActionForward newJoinButton(int subNum, ActionErrors validateErrors) throws B3pCommonsException {
        if (this.isAction(EDIT_ACTION) && this.allowEdits) {
            this.createJoin(subNum);
        } else {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
            this.newAction = EDIT_ACTION;
        }
        return null;
    }

    protected ActionForward deleteJoinButton(int subNum, ActionErrors validateErrors) throws B3pCommonsException {
        if (this.isAction(EDIT_ACTION) && this.allowEdits) {
            this.deleteJoin(subNum);
        } else {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
            this.newAction = EDIT_ACTION;
        }
        return null;
    }

    protected ActionForward deleteAction() throws B3pCommonsException {
        this.log.info((Object)(" Deleting Record '" + this.theObject.toString() + "'"));
        int numOfSubs = this.subObjects.size();
        for (int subNum = 1; subNum <= numOfSubs; ++subNum) {
            Object subObject = this.subObjects.get(subNum - 1);
            if (subObject == null) continue;
            this.deleteSubObject(subNum);
            subObject = null;
            this.subObjects.set(subNum - 1, subObject);
            this.setSubID(subNum, null);
        }
        this.deleteObject();
        this.theObject = null;
        this.setID(null);
        this.log.debug((Object)(" Reset DynaForm bean under key " + this.mapping.getAttribute()));
        this.form.initialize(this.mapping);
        this.subObjects = new ArrayList();
        this.newAction = EDIT_ACTION;
        if (this.directDelete) {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.deletedone"));
        }
        return null;
    }

    protected ActionForward subDeleteAction(int subNum) throws B3pCommonsException {
        Object subObject = this.subObjects.get(subNum - 1);
        this.log.info((Object)(" deleting subrecord '" + subObject.toString() + "'"));
        this.deleteSubObject(subNum);
        subObject = this.getNewSubObject(subNum);
        this.subObjects.set(subNum - 1, subObject);
        this.setSubID(subNum, null);
        this.newAction = EDIT_ACTION;
        if (this.directSubDelete) {
            this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.subdeletedone", (Object)this.getSubNames(subNum)));
        }
        return null;
    }

    protected ActionForward saveAction(ActionErrors validateErrors) throws B3pCommonsException {
        if (this.reduceMainErrors(validateErrors)) {
            this.log.info((Object)"Validation error!");
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.savewitherrors"));
            this.newAction = SAVE_ACTION;
        } else {
            if (this.theObject == null && Integer.toString(TEMPNEW_ID).equals(this.getMainID())) {
                this.theObject = this.getNewObject();
                this.subObjects = new ArrayList();
            }
            if (this.theObject != null) {
                this.populateObject();
                this.syncID();
                this.log.debug((Object)" Populating database object from form bean");
            }
            this.newAction = EDIT_ACTION;
            if (this.directSave) {
                this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.savedone"));
            }
        }
        return null;
    }

    protected ActionForward subSaveAction(int subNum, ActionErrors validateErrors) throws B3pCommonsException {
        Object subObject = this.subObjects.get(subNum - 1);
        String subEditAction = SUBEDIT_ACTION + subNum;
        String subSaveAction = SUBSAVE_ACTION + subNum;
        if (this.reduceSubErrors(subNum, validateErrors)) {
            this.log.info((Object)"Validation error subform!");
            this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.subsavewitherrors", (Object)this.getSubNames(subNum)));
            this.newAction = subSaveAction;
        } else {
            if (subObject == null && Integer.toString(TEMPNEW_ID).equals(this.getSubID(subNum))) {
                subObject = this.getNewSubObject(subNum);
                this.subObjects.set(subNum - 1, subObject);
            }
            if (subObject != null) {
                this.log.info((Object)(" Adding Subrecord " + subNum + " '" + subObject.toString() + "'"));
                this.populateSubObject(subNum);
                this.syncSubID(subNum);
            }
            this.newAction = this.returnAfterSubSave ? EDIT_ACTION : subEditAction;
            if (this.directSubSave) {
                this.errors.add(SUB_MESSAGE + subNum, new ActionMessage("warning.invoerenrecord.subsavedone", (Object)this.getSubNames(subNum)));
            }
        }
        return null;
    }

    protected ActionForward saveAllAction(ActionErrors validateErrors) throws B3pCommonsException {
        if (validateErrors != null && !validateErrors.isEmpty()) {
            this.log.info((Object)"Validation error!");
            this.errors.add((ActionMessages)validateErrors);
            return null;
        }
        if (this.theObject == null && Integer.toString(TEMPNEW_ID).equals(this.getMainID())) {
            this.theObject = this.getNewObject();
            this.subObjects = new ArrayList();
        }
        if (this.theObject != null) {
            this.populateObject();
            this.syncID();
            int numOfSubs = this.subObjects.size();
            for (int subNum = 1; subNum <= numOfSubs; ++subNum) {
                Object subObject = this.subObjects.get(subNum - 1);
                if (subObject == null && Integer.toString(TEMPNEW_ID).equals(this.getSubID(subNum))) {
                    subObject = this.getNewSubObject(subNum);
                    this.subObjects.set(subNum - 1, subObject);
                }
                if (subObject == null) continue;
                this.populateSubObject(subNum);
                this.syncSubID(subNum);
            }
            this.log.debug((Object)" Populating database object and subobjects from form bean");
        }
        this.newAction = EDIT_ACTION;
        if (this.directSave) {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.savedone"));
        }
        return null;
    }

    protected ActionForward populateMainForm() throws B3pCommonsException {
        if (this.theObject == null) {
            return null;
        }
        if (!this.isNewAction(SAVE_ACTION)) {
            this.populateForm();
            this.log.debug((Object)(" Populating form from " + this.theObject.toString()));
        }
        return null;
    }

    protected ActionForward populateSubForms(int subNum) throws B3pCommonsException {
        Object subObject = this.subObjects.get(subNum - 1);
        if (subObject == null) {
            return null;
        }
        String subSaveAction = SUBSAVE_ACTION + subNum;
        if (!this.isNewAction(subSaveAction)) {
            this.populateSubForm(subNum);
            this.log.debug((Object)(" Populating subform from " + subObject.toString()));
        }
        return null;
    }

    protected boolean reduceMainErrors(ActionErrors ve) {
        if (ve == null || ve.isEmpty()) {
            return false;
        }
        Iterator it = ve.properties();
        boolean errorsFound = false;
        ArrayList mp = this.getMainProperties();
        while (it.hasNext()) {
            String ep = (String)it.next();
            Iterator it2 = ve.get(ep);
            if (mp != null && !mp.contains(ep)) continue;
            while (it2.hasNext()) {
                errorsFound = true;
                ActionMessage am = (ActionMessage)it2.next();
                this.errors.add(MAIN_MESSAGE, am);
            }
        }
        return errorsFound;
    }

    protected boolean reduceSubErrors(int subForm, ActionErrors ve) {
        if (ve == null || ve.isEmpty()) {
            return false;
        }
        Iterator it = ve.properties();
        boolean errorsFound = false;
        ArrayList mp = this.getSubProperties(subForm);
        while (it.hasNext()) {
            String ep = (String)it.next();
            Iterator it2 = ve.get(ep);
            if (mp != null && !mp.contains(ep)) continue;
            while (it2.hasNext()) {
                errorsFound = true;
                ActionMessage am = (ActionMessage)it2.next();
                this.errors.add(SUB_MESSAGE + subForm, am);
            }
        }
        return errorsFound;
    }

    protected void determineNewAction() throws B3pCommonsException {
        this.setForm("action", this.newAction);
    }

    protected B3pCommonsException getNoSubFormException(int subForm) {
        return new B3pCommonsException(this.messages.getMessage(this.locale, "error.invoerenrecord.noform", (Object)new Integer(subForm)));
    }

    protected String getNewAction() {
        return this.newAction;
    }

    protected void setNewAction(String newAction) {
        this.newAction = newAction;
    }

    protected boolean isNewAction(String lact) {
        if (lact == null) {
            return false;
        }
        return lact.equals(this.getNewAction());
    }

    protected String getMainID() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected Object getMainObject() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected ArrayList getMainProperties() {
        return null;
    }

    protected Object getNewObject() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected String getSubID(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected Object getSubObject(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected ArrayList getSubProperties(int subForm) {
        return null;
    }

    protected String getSubNames(int subForm) {
        return Integer.toString(subForm);
    }

    protected Object getNewSubObject(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected void setSubID(int subForm, String subid) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected void setID(String id) throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void syncID() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void syncSubID(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected void deleteObject() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void deleteSubObject(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected void populateObject() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void populateSubObject(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected void populateForm() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void populateSubForm(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected void createLists() throws B3pCommonsException {
    }

    protected void createJoinList() throws B3pCommonsException {
    }

    protected void createJoin(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    protected void deleteJoin(int subForm) throws B3pCommonsException {
        throw this.getNoSubFormException(subForm);
    }

    public boolean isDirectSave() {
        return this.directSave;
    }

    public void setDirectSave(boolean directSave) {
        this.directSave = directSave;
    }

    public boolean isDirectDelete() {
        return this.directDelete;
    }

    public void setDirectDelete(boolean directDelete) {
        this.directDelete = directDelete;
    }

    public boolean isDirectSubSave() {
        return this.directSubSave;
    }

    public void setDirectSubSave(boolean directSubSave) {
        this.directSubSave = directSubSave;
    }

    public boolean isDirectSubDelete() {
        return this.directSubDelete;
    }

    public void setDirectSubDelete(boolean directSubDelete) {
        this.directSubDelete = directSubDelete;
    }

    public boolean isReturnAfterSubSave() {
        return this.returnAfterSubSave;
    }

    public void setReturnAfterSubSave(boolean returnAfterSubSave) {
        this.returnAfterSubSave = returnAfterSubSave;
    }

    public boolean isAllowEdits() {
        return this.allowEdits;
    }

    public void setAllowEdits(boolean allowEdits) {
        this.allowEdits = allowEdits;
    }
}

