/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.services;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.commons.services.B3pCommonsException;
import nl.b3p.commons.services.FormBaseBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;

public abstract class SimpleCrudBaseBean
extends FormBaseBean {
    protected Log log = LogFactory.getLog(this.getClass());
    private String newAction = null;
    protected Object theObject = null;
    public static final String INVALID_ACTION = "INVALID";
    public static final String CANCELLED_ACTION = "CANCELLED";
    public static final String START_ACTION = "Start";
    public static final String EDIT_ACTION = "Edit";
    public static final String NEW_ACTION = "New";
    public static final String SAVE_ACTION = "Save";
    public static final String DELETE_ACTION = "Delete";
    public static final String OK_BUTTON = "ok";
    public static final String CANCEL_BUTTON = "cancel";
    public static final String DELETE_BUTTON = "delete";
    public static final String NEW_BUTTON = "new";
    public static final String SAVE_BUTTON = "save";
    public static final String EDIT_BUTTON = "edit";
    public static final String MAIN_MESSAGE = "MAIN_MESSAGE";
    protected static int TEMPNEW_ID = -1;
    private boolean directSave = false;
    private boolean directDelete = false;
    private boolean allowEdits = true;

    public SimpleCrudBaseBean(HttpServletRequest req, DynaValidatorForm dform, ActionMapping mapp) {
        this(req, null, null, null, dform, mapp);
    }

    public SimpleCrudBaseBean(HttpServletRequest req, Locale loc, MessageResources mess, ActionMessages err, DynaValidatorForm dform, ActionMapping mapp) {
        super(req, loc, mess, err, dform, mapp);
    }

    public ActionForward processAction(boolean tokenValid, boolean transactionCancelled, ActionErrors validateErrors) {
        if (!this.isInit) {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("error.invoerenrecord.general"));
            return this.mapping.findForward("failure");
        }
        ActionErrors verrs = this.determineAction(tokenValid, transactionCancelled, validateErrors);
        this.determineObjects();
        ActionForward f = null;
        f = this.doCreateAction();
        if (f != null) {
            return f;
        }
        f = this.doDeleteAction();
        if (f != null) {
            return f;
        }
        f = this.doSaveAction(verrs);
        if (f != null) {
            return f;
        }
        f = this.doEditAction(verrs);
        if (f != null) {
            return f;
        }
        f = this.populateMainForm();
        if (f != null) {
            return f;
        }
        this.determineNewAction();
        return null;
    }

    public ActionForward processLists() {
        try {
            this.createLists();
        }
        catch (B3pCommonsException be) {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("error.invoerenrecord.general"));
            return this.mapping.findForward("failure");
        }
        return null;
    }

    protected ActionErrors determineAction(boolean tokenValid, boolean transactionCancelled, ActionErrors validateErrors) {
        block8: {
            try {
                this.action = this.getParamAsString("action");
            }
            catch (B3pCommonsException be) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error((Object)be);
            }
        }
        this.newAction = this.action;
        if (SimpleCrudBaseBean.nullOrEmpty(this.action)) {
            this.action = START_ACTION;
            this.newAction = EDIT_ACTION;
        }
        if (!this.isAction(START_ACTION)) {
            if (!tokenValid) {
                this.errors.add(MAIN_MESSAGE, new ActionMessage("error.transaction.token"));
                this.action = INVALID_ACTION;
                this.newAction = EDIT_ACTION;
            }
        } else {
            validateErrors = null;
            this.action = EDIT_ACTION;
            this.newAction = EDIT_ACTION;
        }
        if (transactionCancelled) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" Transaction '" + this.action + "' was cancelled"));
            }
            this.action = CANCELLED_ACTION;
            this.newAction = EDIT_ACTION;
        }
        return validateErrors;
    }

    protected void determineObjects() {
        this.theObject = null;
        try {
            this.theObject = this.getMainObject();
        }
        catch (B3pCommonsException b3pCommonsException) {
            // empty catch block
        }
        if (this.theObject == null) {
            return;
        }
    }

    protected ActionForward doCreateAction() {
        if (this.isAction(NEW_ACTION) && this.buttonPressed(OK_BUTTON)) {
            if (this.allowEdits) {
                if (this.theObject != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" process this, save existing");
                    }
                    this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.save"));
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" process this, create new");
                    }
                    this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.new"));
                }
                this.newAction = SAVE_ACTION;
            } else {
                this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
                this.newAction = EDIT_ACTION;
            }
        }
        if (this.isAction(NEW_ACTION) && this.buttonPressed(CANCEL_BUTTON)) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)" Cancel new action");
            }
            this.newAction = EDIT_ACTION;
        }
        return null;
    }

    protected ActionForward doDeleteAction() {
        if (this.isAction(DELETE_ACTION) && this.buttonPressed(OK_BUTTON) && this.theObject != null) {
            if (this.allowEdits) {
                return this.deleteAction();
            }
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
            this.newAction = EDIT_ACTION;
        }
        if (this.isAction(DELETE_ACTION) && this.buttonPressed(CANCEL_BUTTON)) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)" Cancel delete action");
            }
            this.newAction = EDIT_ACTION;
        }
        return null;
    }

    protected ActionForward deleteAction() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)(" Deleting Record '" + this.theObject.toString() + "'"));
        }
        try {
            this.deleteObject();
            this.theObject = null;
            this.setID(null);
        }
        catch (B3pCommonsException dbe) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"  Database error deleting: ", (Throwable)dbe);
            }
            this.errors.add(MAIN_MESSAGE, new ActionMessage("error.database", (Object)dbe.getMessage()));
            return this.mapping.findForward("failure");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" Reset DynaForm bean under key " + this.mapping.getAttribute()));
        }
        this.form.initialize(this.mapping);
        this.newAction = EDIT_ACTION;
        if (this.directDelete) {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.deletedone"));
        }
        return null;
    }

    protected ActionForward doSaveAction(ActionErrors validateErrors) {
        if (this.isAction(SAVE_ACTION) && this.buttonPressed(OK_BUTTON)) {
            if (this.allowEdits) {
                return this.saveAction(validateErrors);
            }
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
            this.newAction = EDIT_ACTION;
        }
        if (this.isAction(SAVE_ACTION) && this.buttonPressed(CANCEL_BUTTON)) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)" Cancel save action");
            }
            this.newAction = EDIT_ACTION;
        }
        return null;
    }

    protected ActionForward saveAction(ActionErrors validateErrors) {
        if (this.reduceMainErrors(validateErrors)) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Validation error!");
            }
            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.savewitherrors"));
            this.newAction = SAVE_ACTION;
        } else {
            try {
                if (this.theObject == null && Integer.toString(TEMPNEW_ID).equals(this.getMainID())) {
                    this.theObject = this.getNewObject();
                }
                if (this.theObject != null) {
                    this.populateObject();
                    this.syncID();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" Populating database object from form bean");
                    }
                }
            }
            catch (Exception dbe) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"  Database error creating object: ", (Throwable)dbe);
                }
                this.errors.add(MAIN_MESSAGE, new ActionMessage("error.database", (Object)dbe.getMessage()));
                return this.mapping.findForward("failure");
            }
            this.newAction = EDIT_ACTION;
            if (this.directSave) {
                this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.savedone"));
            }
        }
        return null;
    }

    protected ActionForward doEditAction(ActionErrors validateErrors) {
        if (this.isAction(EDIT_ACTION)) {
            ActionForward p;
            if (this.buttonPressed(NEW_BUTTON)) {
                if (this.allowEdits) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(" Reset DynaForm bean under key " + this.mapping.getAttribute()));
                    }
                    this.form.initialize(this.mapping);
                    try {
                        this.theObject = this.getNewObject();
                        this.setID(Integer.toString(TEMPNEW_ID));
                    }
                    catch (B3pCommonsException b3pCommonsException) {
                        // empty catch block
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" create new");
                    }
                } else {
                    this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
                }
                this.newAction = EDIT_ACTION;
            }
            if (this.buttonPressed(SAVE_BUTTON)) {
                if (this.allowEdits) {
                    if (this.directSave) {
                        p = this.saveAction(validateErrors);
                        if (p != null) {
                            return p;
                        }
                    } else {
                        if (this.reduceMainErrors(validateErrors)) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info((Object)"Validation error!");
                            }
                            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.savewitherrors"));
                        } else if (this.theObject != null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)" save existing");
                            }
                            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.save"));
                        } else {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)" create new");
                            }
                            this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.new"));
                        }
                        this.newAction = SAVE_ACTION;
                    }
                } else {
                    this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
                }
            }
            if (this.buttonPressed(DELETE_BUTTON)) {
                if (this.allowEdits) {
                    if (this.directDelete) {
                        p = this.deleteAction();
                        if (p != null) {
                            return p;
                        }
                    } else if (this.theObject != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)" delete");
                        }
                        this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.delete"));
                        this.newAction = DELETE_ACTION;
                    } else {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)" delete, but no record");
                        }
                        this.errors.add(MAIN_MESSAGE, new ActionMessage("error.invoerenrecord.nodelete"));
                    }
                } else {
                    this.errors.add(MAIN_MESSAGE, new ActionMessage("warning.invoerenrecord.notallowed"));
                }
            }
            if (this.buttonPressed(CANCEL_BUTTON)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)" Cancel edit action????");
                }
                this.newAction = EDIT_ACTION;
            }
        }
        return null;
    }

    protected ActionForward populateMainForm() {
        if (this.theObject == null) {
            return null;
        }
        try {
            if (!this.isNewAction(SAVE_ACTION)) {
                this.populateForm();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(" Populating form from " + this.theObject.toString()));
                }
            }
        }
        catch (B3pCommonsException pe) {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("error.invoerenrecord.general"));
            return this.mapping.findForward("failure");
        }
        return null;
    }

    protected boolean reduceMainErrors(ActionErrors ve) {
        return ve != null && !ve.isEmpty();
    }

    protected void determineNewAction() {
        try {
            this.setForm("action", this.newAction);
        }
        catch (B3pCommonsException pe) {
            this.errors.add(MAIN_MESSAGE, new ActionMessage("error.invoerenrecord.general"));
        }
    }

    protected String getNewAction() {
        return this.newAction;
    }

    protected void setNewAction(String newAction) {
        this.newAction = newAction;
    }

    protected boolean isNewAction(String lact) {
        if (lact == null) {
            return false;
        }
        return lact.equals(this.getNewAction());
    }

    protected String getMainID() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected Object getMainObject() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected Object getNewObject() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void setID(String id) throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void syncID() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void deleteObject() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void populateObject() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void populateForm() throws B3pCommonsException {
        throw new B3pCommonsException("not implemented!");
    }

    protected void createLists() throws B3pCommonsException {
    }

    public boolean isDirectSave() {
        return this.directSave;
    }

    public void setDirectSave(boolean directSave) {
        this.directSave = directSave;
    }

    public boolean isDirectDelete() {
        return this.directDelete;
    }

    public void setDirectDelete(boolean directDelete) {
        this.directDelete = directDelete;
    }

    public boolean isAllowEdits() {
        return this.allowEdits;
    }

    public void setAllowEdits(boolean allowEdits) {
        this.allowEdits = allowEdits;
    }
}

