/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.commons.taglib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import nl.b3p.commons.services.FormUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;

public class WriteFormattedTag
extends TagSupport {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected String name = null;
    protected String property = null;
    protected String format = null;
    protected String formatClass = null;
    protected String scope = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormatClass() {
        return this.formatClass;
    }

    public void setFormatClass(String formatClass) {
        this.formatClass = formatClass;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int doStartTag() throws JspException {
        Object valueObject;
        Locale locale;
        block47: {
            Object value = null;
            if (this.name != null) {
                if (TagUtils.getInstance().lookup(this.pageContext, this.name, this.scope) == null) {
                    return 0;
                }
                value = TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, this.scope);
            }
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            locale = request.getLocale();
            valueObject = null;
            if (!(value == null || value instanceof String && ((String)value).trim().length() == 0)) {
                String stringValue = value.toString();
                try {
                    if (this.formatClass.equals("java.lang.Boolean")) {
                        valueObject = new Boolean(stringValue);
                    } else if (this.formatClass.equals("java.lang.BigDecimal")) {
                        valueObject = new BigDecimal(stringValue);
                    } else if (this.formatClass.equals("java.lang.BigInteger")) {
                        valueObject = new BigInteger(stringValue);
                    } else if (this.formatClass.equals("java.lang.Byte")) {
                        valueObject = new Byte(stringValue);
                    } else if (this.formatClass.equals("java.lang.Double")) {
                        valueObject = new Double(stringValue);
                    } else if (this.formatClass.equals("java.lang.Float")) {
                        valueObject = new Float(stringValue);
                    } else if (this.formatClass.equals("java.lang.Integer")) {
                        valueObject = new Integer(stringValue);
                    } else if (this.formatClass.equals("java.lang.Long")) {
                        valueObject = new Long(stringValue);
                    } else if (this.formatClass.equals("java.lang.Short")) {
                        valueObject = new Short(stringValue);
                    } else if (this.formatClass.equals("java.lang.String")) {
                        char[] strChars = stringValue.toCharArray();
                        StringBuffer newStr = new StringBuffer();
                        int strLength = strChars.length;
                        if (strLength == 0) {
                            newStr.append("-");
                        }
                        for (int i = 0; i < strLength; ++i) {
                            newStr.append(strChars[i]);
                            if (strChars[i] != '\n') continue;
                            newStr.append("<br>");
                        }
                        valueObject = newStr.toString();
                    } else {
                        valueObject = this.formatClass.equals("java.util.Date") ? FormUtils.StringToDate(stringValue, locale) : (this.formatClass.equals("java.util.Date2") ? FormUtils.FormStringToDate(stringValue, locale) : (this.formatClass.equals("java.util.Date3") ? FormUtils.SortStringToDate(stringValue, locale) : (this.formatClass.equals("java.sql.Date") ? new Date(Long.parseLong(stringValue)) : (this.formatClass.equals("java.sql.Time") ? new Time(Long.parseLong(stringValue)) : (this.formatClass.equals("java.sql.Timestamp") ? new Timestamp(Long.parseLong(stringValue)) : null)))));
                    }
                }
                catch (NumberFormatException nfe) {
                    valueObject = null;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("NumberFormat Exception: " + nfe));
                    }
                }
                catch (IllegalArgumentException iare) {
                    valueObject = null;
                    if (!this.log.isDebugEnabled()) break block47;
                    this.log.debug((Object)("Illegal Argument Exception: " + iare));
                }
            }
        }
        String output = "";
        Format formatter = null;
        if (valueObject != null && this.format != null) {
            if (valueObject instanceof Number) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Format using Number");
                }
                try {
                    formatter = NumberFormat.getNumberInstance(locale);
                    ((DecimalFormat)formatter).applyPattern(this.format);
                }
                catch (IllegalArgumentException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("writeFormatted Number error: " + e));
                    }
                }
            } else if (valueObject instanceof java.util.Date) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Format using Date");
                }
                formatter = new SimpleDateFormat(this.format);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Format using toString for class: " + valueObject.getClass().getName()));
            }
        }
        if (valueObject != null) {
            if (formatter != null && this.format != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Formatter");
                }
                output = formatter.format(valueObject);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"No formatter");
                }
                output = valueObject.toString();
            }
        } else {
            output = "-";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Output: " + output));
        }
        TagUtils.getInstance().write(this.pageContext, output);
        return 0;
    }

    public void release() {
        super.release();
        this.name = null;
        this.property = null;
        this.scope = null;
        this.format = null;
        this.formatClass = null;
    }
}

