/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.csw.client;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;
import nl.b3p.csw.client.CswRequestCreator;
import nl.b3p.csw.client.CswSmartRequestCreator;
import nl.b3p.csw.client.FilterCreator;
import nl.b3p.csw.client.InputById;
import nl.b3p.csw.client.InputBySearch;
import nl.b3p.csw.client.OutputById;
import nl.b3p.csw.client.OutputBySearch;
import nl.b3p.csw.client.OwsException;
import nl.b3p.csw.jaxb.csw.Constraint;
import nl.b3p.csw.jaxb.csw.DeleteType;
import nl.b3p.csw.jaxb.csw.GetRecords;
import nl.b3p.csw.jaxb.csw.Harvest;
import nl.b3p.csw.jaxb.csw.HarvestResponse;
import nl.b3p.csw.jaxb.csw.HarvestResponseType;
import nl.b3p.csw.jaxb.csw.HarvestType;
import nl.b3p.csw.jaxb.csw.InsertType;
import nl.b3p.csw.jaxb.csw.QueryConstraintType;
import nl.b3p.csw.jaxb.csw.Transaction;
import nl.b3p.csw.jaxb.csw.TransactionResponse;
import nl.b3p.csw.jaxb.csw.TransactionResponseType;
import nl.b3p.csw.jaxb.csw.TransactionType;
import nl.b3p.csw.jaxb.csw.UpdateType;
import nl.b3p.csw.jaxb.filter.BinaryComparisonOpType;
import nl.b3p.csw.jaxb.filter.BinaryLogicOpType;
import nl.b3p.csw.jaxb.filter.ExpressionType;
import nl.b3p.csw.jaxb.filter.Filter;
import nl.b3p.csw.jaxb.filter.FilterType;
import nl.b3p.csw.jaxb.filter.Literal;
import nl.b3p.csw.jaxb.filter.LiteralType;
import nl.b3p.csw.jaxb.filter.Or;
import nl.b3p.csw.jaxb.filter.PropertyIsEqualTo;
import nl.b3p.csw.jaxb.filter.PropertyName;
import nl.b3p.csw.jaxb.filter.PropertyNameType;
import nl.b3p.csw.jaxb.filter.Within;
import nl.b3p.csw.server.CswServable;
import nl.b3p.csw.server.GeoNetworkCswServer;
import nl.b3p.csw.util.CswClientFactory;
import nl.b3p.csw.util.MarshallUtil;
import nl.b3p.csw.util.OnlineResource;
import nl.b3p.csw.util.Protocol;
import nl.b3p.csw.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class CswClient {
    protected static Log log = LogFactory.getLog(CswClient.class);
    protected CswServable server = null;
    protected Schema cswSchema = null;
    protected String CSW_XSD_PATH = "nl/b3p/csw/xsd/csw/2.0.2/CSW-publication.xsd";

    protected CswClient() {
    }

    public CswClient(CswServable server) {
        this.init(server, this.CSW_XSD_PATH);
    }

    public CswClient(CswServable server, String cswSchemaPath) {
        this.init(server, cswSchemaPath);
    }

    private void init(CswServable server, String cswSchemaPath) {
        this.server = server;
        try {
            this.cswSchema = null;
        }
        catch (Exception e) {
            log.warn((Object)"Schema validation not possible.", (Throwable)e);
        }
    }

    public CswServable getServer() {
        return this.server;
    }

    public void setServer(CswServable server) {
        this.server = server;
    }

    public Schema getCswSchema() {
        return this.cswSchema;
    }

    public void setCswSchema(Schema schema) {
        this.cswSchema = schema;
    }

    public void setCswSchema(String validationPath) throws SAXException, URISyntaxException {
        this.cswSchema = Util.createSchema(validationPath);
    }

    public OutputById search(InputById input) throws IOException, JDOMException, JAXBException, OwsException {
        return new OutputById(this.doRequest(input.getRequest()));
    }

    public OutputBySearch search(InputBySearch input) throws IOException, JDOMException, JAXBException, OwsException {
        return new OutputBySearch(this.doRequest(input.getRequest()));
    }

    protected Document doRequest(JAXBElement jaxbElement) throws IOException, JDOMException, JAXBException, OwsException {
        if (jaxbElement == null) {
            throw new IllegalArgumentException("Provided jaxbElement must be non-null.");
        }
        log.debug((Object)MarshallUtil.marshall(jaxbElement, null));
        String marshalledCswXml = MarshallUtil.marshall(jaxbElement, this.cswSchema);
        Document doc = new SAXBuilder().build((Reader)new StringReader(marshalledCswXml));
        doc.getRootElement().addNamespaceDeclaration(Namespace.getNamespace((String)"apiso", (String)"http://www.opengis.net/cat/csw/apiso/1.0"));
        marshalledCswXml = new XMLOutputter().outputString(doc);
        Document responseDocument = (Document)this.server.doRequest(marshalledCswXml);
        return responseDocument;
    }

    protected Transaction createTransaction(Object object) {
        TransactionType transactionType = new TransactionType();
        transactionType.setService("CSW");
        transactionType.setVersion("2.0.2");
        transactionType.getInsertOrUpdateOrDelete().add(object);
        return new Transaction(transactionType);
    }

    protected TransactionResponse createTransactionResponse(Document responseDocument) throws JDOMException, JAXBException {
        JAXBElement transactionResponse = MarshallUtil.unMarshall(responseDocument, this.cswSchema, TransactionResponseType.class);
        return new TransactionResponse((TransactionResponseType)transactionResponse.getValue());
    }

    protected InsertType createInsertType(org.w3c.dom.Document document) {
        InsertType insertType = new InsertType();
        insertType.setTypeName("gmd:MD_Metadata");
        insertType.setHandle("insertHandle");
        insertType.getAny().add(document.getDocumentElement());
        return insertType;
    }

    public TransactionResponse insert(org.w3c.dom.Document document) throws IOException, JDOMException, JAXBException, OwsException {
        return this.insert(this.createInsertType(document));
    }

    public TransactionResponse insert(InsertType insertType) throws IOException, JDOMException, JAXBException, OwsException {
        Document responseDocument = this.doRequest(this.createTransaction(insertType));
        return this.createTransactionResponse(responseDocument);
    }

    public TransactionResponse update(String fileIdentifier, org.w3c.dom.Document document) throws Exception {
        UpdateType update = new UpdateType();
        update.setHandle("update_" + fileIdentifier);
        update.setAny(document.getDocumentElement());
        QueryConstraintType qct = new QueryConstraintType();
        qct.setVersion("1.0.0");
        FilterType ft = new FilterType();
        ArrayList<JAXBElement<? extends ExpressionType>> operators = new ArrayList<JAXBElement<? extends ExpressionType>>();
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        l.add((Serializable)((Object)"apiso:identifier"));
        operators.add(new PropertyName(new PropertyNameType(l)));
        l = new ArrayList();
        l.add((Serializable)((Object)fileIdentifier));
        operators.add(new Literal(new LiteralType(l)));
        PropertyIsEqualTo eq = new PropertyIsEqualTo(new BinaryComparisonOpType(operators, null));
        ft.setComparisonOps(eq);
        qct.setFilter(new Filter(ft));
        update.setConstraint(new Constraint(qct));
        return this.update(update);
    }

    public TransactionResponse update(Document document) throws IOException, JDOMException, JAXBException, OwsException {
        UpdateType updateType = new UpdateType();
        updateType.setAny(new XMLOutputter().outputString(document));
        return this.update(updateType);
    }

    public TransactionResponse update(UpdateType updateType) throws IOException, JDOMException, JAXBException, OwsException {
        Document responseDocument = this.doRequest(this.createTransaction(updateType));
        return this.createTransactionResponse(responseDocument);
    }

    public DeleteType createDeleteType(String uuid) {
        DeleteType deleteType = new DeleteType();
        deleteType.setTypeName("gmd:MD_Metadata");
        deleteType.setHandle("deleteHandle");
        PropertyIsEqualTo propertyIsEqualTo = FilterCreator.createPropertyIsEqualTo(uuid, "apiso:identifier", null);
        FilterType filterType = new FilterType();
        filterType.setComparisonOps(propertyIsEqualTo);
        QueryConstraintType queryConstraintType = new QueryConstraintType();
        queryConstraintType.setVersion("1.1.0");
        queryConstraintType.setFilter(new Filter(filterType));
        deleteType.setConstraint(new Constraint(queryConstraintType));
        return deleteType;
    }

    public DeleteType createDeleteType(String[] uuids) {
        if (uuids.length == 1) {
            return this.createDeleteType(uuids[0]);
        }
        DeleteType deleteType = new DeleteType();
        deleteType.setTypeName("gmd:MD_Metadata");
        deleteType.setHandle("deleteHandle");
        BinaryLogicOpType binaryLogicOpType = new BinaryLogicOpType();
        for (String uuid : uuids) {
            PropertyIsEqualTo propertyIsEqualTo = FilterCreator.createPropertyIsEqualTo(uuid, "apiso:identifier", null);
            binaryLogicOpType.getComparisonOpsOrSpatialOpsOrLogicOps().add(propertyIsEqualTo);
        }
        Or or = new Or(binaryLogicOpType);
        FilterType filterType = new FilterType();
        filterType.setLogicOps(or);
        QueryConstraintType queryConstraintType = new QueryConstraintType();
        queryConstraintType.setVersion("1.1.0");
        queryConstraintType.setFilter(new Filter(filterType));
        deleteType.setConstraint(new Constraint(queryConstraintType));
        return deleteType;
    }

    public TransactionResponse delete(String uuid) throws IOException, JDOMException, JAXBException, OwsException {
        return this.delete(this.createDeleteType(uuid));
    }

    public TransactionResponse delete(DeleteType deleteType) throws IOException, JDOMException, JAXBException, OwsException {
        Document responseDocument = this.doRequest(this.createTransaction(deleteType));
        return this.createTransactionResponse(responseDocument);
    }

    public HarvestResponse harvest(HarvestType harvestType) throws IOException, JDOMException, JAXBException, OwsException {
        Document responseDocument = this.doRequest(new Harvest(harvestType));
        JAXBElement harvestResponse = MarshallUtil.unMarshall(responseDocument, this.cswSchema, HarvestResponseType.class);
        return new HarvestResponse((HarvestResponseType)harvestResponse.getValue());
    }

    public static void main(String[] args) {
        GeoNetworkCswServer server = new GeoNetworkCswServer("http://dev.b3p.nl/geonetwork/srv/en/xml.user.login", "http://dev.b3p.nl/geonetwork/srv/en/csw", "admin", "japikola");
        String testWktInput = "POLYGON ((280 380, 280 200, 60 200, 60 380, 180 220, 280 380),(40 160, 260 160, 240 60, 20 80, 40 160))";
        try {
            GetRecords getRTest = CswSmartRequestCreator.createSmartCswRequest("test in nog een test");
            System.out.println("Test smart csw");
            System.out.println(MarshallUtil.marshall(getRTest, null));
            GetRecords getRecords = CswRequestCreator.createCswRequest(new Within(), "anyText", testWktInput);
            System.out.println(MarshallUtil.marshall(getRecords, null));
            CswClient client = new CswClient(server);
            InputBySearch inputBySearch = new InputBySearch("archeo");
            XMLOutputter outputter = new XMLOutputter();
            System.out.println(MarshallUtil.marshall(inputBySearch.getRequest(), null));
            OutputBySearch outputBySearch = client.search(inputBySearch);
            System.out.println("searchresults empty: " + outputBySearch.isEmpty());
            Document outputXmlDoc = outputBySearch.getXml();
            outputter.output(outputXmlDoc, (OutputStream)System.out);
            List<Element> mdList = outputBySearch.getSearchResults();
            System.out.println("mdList size: " + mdList.size());
            for (Element elem : mdList) {
                System.out.println("elem: " + elem.toString());
            }
            Document transformedXmlDoc = outputBySearch.getTransformedXml("C:/dev_erik/b3p-commons/b3p-commons-csw/xml/md-response.xsl");
            outputter.output(transformedXmlDoc, (OutputStream)System.out);
            Document xmlDoc2 = CswClientFactory.searchSimpleAsXml("*eologie", server);
            outputter.output(xmlDoc2, (OutputStream)System.out);
            Map<URI, List<OnlineResource>> map = outputBySearch.getResourcesMap();
            for (List<OnlineResource> resourceList : map.values()) {
                for (OnlineResource resource : resourceList) {
                    Protocol prot;
                    String desc;
                    String name;
                    URI url = resource.getUrl();
                    if (url != null) {
                        System.out.println("Resource URL: " + url.toString());
                    }
                    if ((name = resource.getName()) != null) {
                        System.out.println("Name: " + name);
                    }
                    if ((desc = resource.getDescription()) != null) {
                        System.out.println("Description: " + desc);
                    }
                    if ((prot = resource.getProtocol()) != null) {
                        System.out.println("Protocol: " + prot.getName());
                    }
                    System.out.println();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

