/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.csw.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import nl.b3p.csw.client.OwsException;
import nl.b3p.csw.util.MarshallUtil;
import nl.b3p.csw.util.OnlineResource;
import nl.b3p.csw.util.OperatesOn;
import nl.b3p.csw.util.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Output
implements Iterable<Element> {
    protected static final Log log = LogFactory.getLog(Output.class);
    protected static final Namespace cswNameSpace = Namespace.getNamespace((String)"http://www.opengis.net/cat/csw/2.0.2");
    protected static final Namespace gmdNameSpace = Namespace.getNamespace((String)"http://www.isotc211.org/2005/gmd");
    protected static final Namespace gcoNameSpace = Namespace.getNamespace((String)"http://www.isotc211.org/2005/gco");
    protected static final Namespace cswPrefixNameSpace = Namespace.getNamespace((String)"csw", (String)"http://www.opengis.net/cat/csw/2.0.2");
    protected static final Namespace gmdPrefixNameSpace = Namespace.getNamespace((String)"gmd", (String)"http://www.isotc211.org/2005/gmd");
    protected static final Namespace gcoPrefixNameSpace = Namespace.getNamespace((String)"gco", (String)"http://www.isotc211.org/2005/gco");
    protected static final Namespace srvPrefixNameSpace = Namespace.getNamespace((String)"srv", (String)"http://www.isotc211.org/2005/srv");
    protected static final ElementFilter resultElementFilter = new ElementFilter("MD_Metadata", gmdNameSpace);
    protected static final ElementFilter resourceElementFilter = new ElementFilter("CI_OnlineResource", gmdNameSpace);
    protected static final ElementFilter fileIdentifierElementFilter = new ElementFilter("fileIdentifier", gmdNameSpace);
    protected static XPath titleJdomXPath;
    protected static XPath keywordsJdomXPath;
    protected static XPath identificationDateJdomXPath;
    protected static XPath responsibleOrganisationNameJdomXPath;
    protected static XPath dateStampJdomXPath;
    protected static XPath dateTimeStampJdomXPath;
    protected static XPath abstractJdomXPath;
    protected static XPath browseGraphicFileName;
    protected static XPath metadataStandardNameXPath;
    protected static XPath operatesOnXpath;
    protected static final Protocol defaultProtocol;
    protected static final List<Protocol> defaultAllowedProtocols;
    protected static final String exceptionName = "ExceptionReport";
    public static final String ISO_19115 = "ISO 19115";
    public static final String ISO_19119 = "ISO 19119";
    protected Document xmlDocument = null;
    protected JAXBElement response = null;
    protected Schema schema = null;

    public Output(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public Output(Document xmlDocument, Schema schema) {
        this(xmlDocument);
        this.schema = schema;
    }

    public Document getXml() {
        return this.xmlDocument;
    }

    public Document getTransformedXml(String transformPath) throws TransformerException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(transformPath));
            JDOMSource in = new JDOMSource(this.xmlDocument);
            JDOMResult out = new JDOMResult();
            transformer.transform((Source)in, (Result)out);
            return out.getDocument();
        }
        catch (TransformerException e) {
            throw new TransformerException("Xml Csw response could not be transformed with " + transformPath + ".\nXml: " + this.xmlDocument.toString(), e);
        }
    }

    protected JAXBElement getResponse() throws JDOMException, JAXBException, OwsException {
        return this.getResponseImpl();
    }

    private JAXBElement getResponseImpl() throws JDOMException, JAXBException {
        if (this.response == null) {
            this.response = MarshallUtil.unMarshall(this.xmlDocument, this.schema, this.getTargetType());
        }
        return this.response;
    }

    protected abstract Class getTargetType();

    @Override
    public Iterator<Element> iterator() {
        List<Element> jdomList = null;
        try {
            jdomList = this.getSearchResults();
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
        return jdomList.iterator();
    }

    public abstract List<org.w3c.dom.Element> getSearchResultsW3C() throws JDOMException, JAXBException, OwsException;

    public List<Element> getSearchResults() throws JDOMException, JAXBException, OwsException {
        List<org.w3c.dom.Element> w3cList = this.getSearchResultsW3C();
        ArrayList<Element> jdomList = new ArrayList<Element>(w3cList.size());
        DOMBuilder domBuilder = new DOMBuilder();
        for (org.w3c.dom.Element w3cElem : w3cList) {
            jdomList.add(domBuilder.build(w3cElem));
        }
        return jdomList;
    }

    public String getSearchResultsString() throws JDOMException, JAXBException, IOException, OwsException {
        return new XMLOutputter().outputString(this.getSearchResults());
    }

    public List<OnlineResource> getResourcesFlattened() {
        return this.getResourcesFlattened(defaultAllowedProtocols);
    }

    public List<OnlineResource> getResourcesFlattened(List<Protocol> allowedProtocols) {
        ArrayList<OnlineResource> resources = new ArrayList<OnlineResource>();
        Map<URI, List<OnlineResource>> resourcesMap = this.getResourcesMap(allowedProtocols);
        for (List<OnlineResource> list : resourcesMap.values()) {
            resources.addAll(list);
        }
        return resources;
    }

    public Map<URI, List<OnlineResource>> getResourcesMap() {
        return this.getResourcesMap(defaultAllowedProtocols);
    }

    public Map<URI, List<OnlineResource>> getResourcesMap(List<Protocol> allowedProtocols) {
        HashMap<URI, List<OnlineResource>> services = new HashMap<URI, List<OnlineResource>>();
        Element rootElement = this.xmlDocument.getRootElement();
        if (rootElement != null) {
            Iterator results = rootElement.getDescendants((Filter)resultElementFilter);
            while (results.hasNext()) {
                Element resultElem = (Element)results.next();
                Map<URI, List<OnlineResource>> resultServices = this.getResourcesMap(resultElem, allowedProtocols);
                for (Map.Entry<URI, List<OnlineResource>> resultService : resultServices.entrySet()) {
                    URI key = resultService.getKey();
                    List<OnlineResource> value = resultService.getValue();
                    if (services.containsKey(key)) {
                        ((List)services.get(key)).addAll(value);
                        continue;
                    }
                    services.putAll(resultServices);
                }
            }
        }
        return services;
    }

    public Map<URI, List<OnlineResource>> getResourcesMap(Element resultElem, List<Protocol> allowedProtocols) throws UnsupportedOperationException {
        HashMap<URI, List<OnlineResource>> services = new HashMap<URI, List<OnlineResource>>();
        Iterator resources = resultElem.getDescendants((Filter)resourceElementFilter);
        while (resources.hasNext()) {
            Element resourceElem = (Element)resources.next();
            OnlineResource onlineResource = this.getResource(resourceElem, allowedProtocols, resultElem);
            if (onlineResource == null) continue;
            URI url = onlineResource.getUrl();
            if (services.get(url) == null) {
                services.put(url, new ArrayList());
            }
            ((List)services.get(url)).add(onlineResource);
        }
        return services;
    }

    public String getUUID(Element rootElement) throws UnsupportedOperationException {
        return this.getUUID(rootElement, false);
    }

    public String getUUID(Element rootElement, boolean sanitize) throws UnsupportedOperationException {
        Iterator fileIdentifierResult = rootElement.getDescendants((Filter)fileIdentifierElementFilter);
        if (!fileIdentifierResult.hasNext()) {
            throw new UnsupportedOperationException("No UUID found for metadata.");
        }
        Element fileIdentifier = (Element)fileIdentifierResult.next();
        String uuid = fileIdentifier.getChildTextTrim("CharacterString", gcoNameSpace);
        if (!sanitize) {
            return uuid;
        }
        uuid = uuid.startsWith("{") ? uuid.substring(1) : uuid;
        uuid = uuid.endsWith("}") ? uuid.substring(0, uuid.length() - 1) : uuid;
        return uuid;
    }

    public String getTitle(Element recordElement) throws JDOMException {
        return titleJdomXPath.valueOf((Object)recordElement);
    }

    public List<Text> getKeyWords(Element recordElement) throws JDOMException {
        return keywordsJdomXPath.selectNodes((Object)recordElement);
    }

    public String getIdentificationDate(Element recordElement) throws JDOMException {
        return identificationDateJdomXPath.valueOf((Object)recordElement);
    }

    public String getResponsibleOrganisationName(Element recordElement) throws JDOMException {
        return responsibleOrganisationNameJdomXPath.valueOf((Object)recordElement);
    }

    public String getDateStamp(Element recordElement) throws JDOMException {
        String s = dateStampJdomXPath.valueOf((Object)recordElement);
        if (s == null || s.length() == 0) {
            s = dateTimeStampJdomXPath.valueOf((Object)recordElement);
        }
        return s;
    }

    public String getAbstractText(Element recordElement) throws JDOMException {
        return abstractJdomXPath.valueOf((Object)recordElement);
    }

    public String getBrowseGraphicFileName(Element recordElement) throws JDOMException {
        return browseGraphicFileName.valueOf((Object)recordElement);
    }

    public String getMetadataStandardName(Element recordElement) throws JDOMException {
        return metadataStandardNameXPath.valueOf((Object)recordElement);
    }

    public boolean isMetadataForService(Element recordElement) throws JDOMException {
        return ISO_19119.equalsIgnoreCase(metadataStandardNameXPath.valueOf((Object)recordElement));
    }

    private OnlineResource getResource(Element resourceElem, List<Protocol> allowedProtocols, Element metadataElement) {
        URI url = null;
        Protocol protocol = null;
        String name = null;
        String desc = null;
        try {
            Element descStringElem;
            Element descElem;
            Element nameStringElem;
            Element nameElem;
            Element protocolElem;
            Element URLElem;
            Element linkageElem = resourceElem.getChild("linkage", gmdNameSpace);
            if (linkageElem != null && (URLElem = linkageElem.getChild("URL", gmdNameSpace)) != null) {
                url = new URI(URLElem.getTextTrim());
            }
            if ((protocolElem = resourceElem.getChild("protocol", gmdNameSpace)) != null) {
                protocol = this.getProtocol(protocolElem);
            }
            if ((nameElem = resourceElem.getChild("name", gmdNameSpace)) != null && (nameStringElem = nameElem.getChild("CharacterString", gcoNameSpace)) != null) {
                name = nameStringElem.getTextTrim();
            }
            if ((descElem = resourceElem.getChild("description", gmdNameSpace)) != null && (descStringElem = descElem.getChild("CharacterString", gcoNameSpace)) != null) {
                desc = descStringElem.getTextTrim();
            }
            if (url != null && name != null && (allowedProtocols.isEmpty() || allowedProtocols.contains((Object)protocol))) {
                OnlineResource onlineResource = new OnlineResource();
                onlineResource.setUrl(url);
                onlineResource.setName(name);
                onlineResource.setDescription(desc);
                onlineResource.setProtocol(protocol);
                onlineResource.setMetadata(metadataElement);
                return onlineResource;
            }
        }
        catch (URISyntaxException ex) {
            log.error((Object)ex);
        }
        return null;
    }

    private Protocol getProtocol(Element protocolElem) {
        Protocol protocol = null;
        Element SV_ServiceTypeElem = protocolElem.getChild("SV_ServiceType", gmdNameSpace);
        Element protocolStringElem = protocolElem.getChild("CharacterString", gcoNameSpace);
        if (SV_ServiceTypeElem != null) {
            String protocolText = SV_ServiceTypeElem.getTextTrim();
            try {
                protocol = Protocol.fromValue(protocolText);
            }
            catch (Exception e) {}
        } else if (protocolStringElem != null) {
            String protocolText = protocolStringElem.getTextTrim();
            try {
                protocol = Protocol.fromValue(protocolText);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (protocol == null) {
            protocol = defaultProtocol;
        }
        return protocol;
    }

    public List<OperatesOn> getOperatesOn(Element recordElement) throws JDOMException {
        ArrayList<OperatesOn> returnList = new ArrayList<OperatesOn>();
        List elements = operatesOnXpath.selectNodes((Object)recordElement);
        for (Element el : elements) {
            returnList.add(new OperatesOn(el));
        }
        return returnList;
    }

    static {
        defaultProtocol = Protocol.WMS;
        defaultAllowedProtocols = new ArrayList<Protocol>();
        defaultAllowedProtocols.add(defaultProtocol);
        try {
            titleJdomXPath = XPath.newInstance((String)"gmd:identificationInfo/*/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString/text()");
            titleJdomXPath.addNamespace(gmdPrefixNameSpace);
            titleJdomXPath.addNamespace(gcoPrefixNameSpace);
            keywordsJdomXPath = XPath.newInstance((String)"gmd:identificationInfo/*/gmd:descriptiveKeywords/gmd:MD_Keywords/gmd:keyword/gco:CharacterString/text()");
            keywordsJdomXPath.addNamespace(gmdPrefixNameSpace);
            keywordsJdomXPath.addNamespace(gcoPrefixNameSpace);
            identificationDateJdomXPath = XPath.newInstance((String)"gmd:identificationInfo/*/gmd:citation/gmd:CI_Citation/gmd:date/gmd:CI_Date/gmd:date/gco:Date/text()");
            identificationDateJdomXPath.addNamespace(gmdPrefixNameSpace);
            identificationDateJdomXPath.addNamespace(gcoPrefixNameSpace);
            responsibleOrganisationNameJdomXPath = XPath.newInstance((String)"gmd:contact/gmd:CI_ResponsibleParty/gmd:organisationName/gco:CharacterString/text()");
            responsibleOrganisationNameJdomXPath.addNamespace(gmdPrefixNameSpace);
            responsibleOrganisationNameJdomXPath.addNamespace(gcoPrefixNameSpace);
            dateStampJdomXPath = XPath.newInstance((String)"gmd:dateStamp/gco:Date/text()");
            dateStampJdomXPath.addNamespace(gmdPrefixNameSpace);
            dateStampJdomXPath.addNamespace(gcoPrefixNameSpace);
            dateTimeStampJdomXPath = XPath.newInstance((String)"gmd:dateStamp/gco:DateTime/text()");
            dateTimeStampJdomXPath.addNamespace(gmdPrefixNameSpace);
            dateTimeStampJdomXPath.addNamespace(gcoPrefixNameSpace);
            abstractJdomXPath = XPath.newInstance((String)"gmd:identificationInfo/*/gmd:abstract/gco:CharacterString/text()");
            abstractJdomXPath.addNamespace(gmdPrefixNameSpace);
            abstractJdomXPath.addNamespace(gcoPrefixNameSpace);
            browseGraphicFileName = XPath.newInstance((String)"gmd:identificationInfo/*/gmd:graphicOverview/gmd:MD_BrowseGraphic/gmd:fileName/gco:CharacterString/text()");
            browseGraphicFileName.addNamespace(gmdPrefixNameSpace);
            browseGraphicFileName.addNamespace(gcoPrefixNameSpace);
            metadataStandardNameXPath = XPath.newInstance((String)"gmd:metadataStandardName/gco:CharacterString/text()");
            metadataStandardNameXPath.addNamespace(gmdPrefixNameSpace);
            metadataStandardNameXPath.addNamespace(gcoPrefixNameSpace);
            operatesOnXpath = XPath.newInstance((String)"gmd:identificationInfo/srv:SV_ServiceIdentification/srv:operatesOn");
            operatesOnXpath.addNamespace(gmdPrefixNameSpace);
            operatesOnXpath.addNamespace(srvPrefixNameSpace);
        }
        catch (JDOMException ex) {
            log.error((Object)"Error creating xpath expressions");
        }
    }
}

