/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.csw.server;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import nl.b3p.csw.client.JDOMResponseListener;
import nl.b3p.csw.client.OwsException;
import nl.b3p.csw.client.ResponseListenable;
import nl.b3p.csw.server.CswServable;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoNetworkCswServer
implements CswServable<Document> {
    protected static Log log;
    protected static final String host;
    protected static final int port = -1;
    protected static final int RTIMEOUT = 20000;
    protected static Cookie[] cookies;
    protected String cswUrl;
    protected String loginUrl;
    protected String cswUser;
    protected String cswPassword;
    protected ResponseListenable<Document> responseListenable = null;

    public ResponseListenable getResponseListenable() {
        return this.responseListenable;
    }

    public void setResponseListenable(ResponseListenable responseListenable) {
        this.responseListenable = responseListenable;
    }

    public GeoNetworkCswServer(String loginUrl, String cswUrl, String cswUser, String cswPassword) {
        this(loginUrl, cswUrl, cswUser, cswPassword, new JDOMResponseListener());
    }

    public GeoNetworkCswServer(String loginUrl, String cswUrl, String cswUser, String cswPassword, ResponseListenable responseListenable) {
        log = LogFactory.getLog(this.getClass());
        log.info((Object)("Initializing " + this.getClass().getSimpleName()));
        this.loginUrl = loginUrl;
        this.cswUrl = cswUrl;
        this.cswUser = cswUser;
        this.cswPassword = cswPassword;
        this.responseListenable = responseListenable;
    }

    @Override
    public Document doRequest(String cswRequestXml) throws IOException, JDOMException, JAXBException, OwsException {
        if (this.login(this.loginUrl, this.cswUser, this.cswPassword)) {
            return this.httpPostCswRequest(cswRequestXml, this.cswUrl);
        }
        return this.httpPostCswRequest(cswRequestXml, this.cswUrl, this.cswUser, this.cswPassword);
    }

    protected boolean login(String url, String username, String password) throws IOException, JDOMException, JAXBException, OwsException {
        if (url == null || username == null || password == null) {
            return false;
        }
        StringBuilder loginMessage = new StringBuilder();
        loginMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        loginMessage.append("<request>");
        loginMessage.append("<username>");
        loginMessage.append(username);
        loginMessage.append("</username>");
        loginMessage.append("<password>");
        loginMessage.append(password);
        loginMessage.append("</password>");
        loginMessage.append("</request>");
        Document responseMessage = null;
        try {
            responseMessage = this.httpPostCswRequest(loginMessage.toString(), url);
        }
        catch (IOException ex) {
            throw new IOException("Error logging in on csw-server: " + ex.getLocalizedMessage());
        }
        boolean loginSuccess = responseMessage != null;
        return loginSuccess;
    }

    protected Document httpPostCswRequest(String request, String url) throws IOException, JDOMException, JAXBException, OwsException {
        return this.httpPostCswRequest(request, url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document httpPostCswRequest(String request, String url, String username, String password) throws IOException, JDOMException, JAXBException, OwsException {
        HttpState initialState = new HttpState();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                initialState.addCookie(cookie);
            }
        }
        HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(20000);
        client.getParams().setCookiePolicy("rfc2109");
        if (username != null && password != null) {
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
            AuthScope authScope = new AuthScope(host, -1);
            initialState.setCredentials(authScope, (Credentials)defaultcreds);
        }
        client.setState(initialState);
        PostMethod method = new PostMethod(url);
        method.setRequestHeader("Accept", "text/xml");
        method.setRequestEntity((RequestEntity)new StringRequestEntity(request, "text/xml", "UTF-8"));
        InputStream responseStream = null;
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new IOException("Url: " + url + ". Reason: " + method.getStatusLine());
            }
            cookies = client.getState().getCookies();
            log.debug((Object)"Present cookies: ");
            for (Cookie cookie : cookies) {
                log.debug((Object)(" - " + cookie.toExternalForm()));
            }
            responseStream = method.getResponseBodyAsStream();
            Document document = this.responseListenable.handleResponse(responseStream);
            return document;
        }
        finally {
            method.releaseConnection();
        }
    }

    static {
        host = AuthScope.ANY_HOST;
        cookies = null;
    }
}

