/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.csw.client;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import nl.b3p.csw.client.CswRequestCreator;
import nl.b3p.csw.client.FilterCreator;
import nl.b3p.csw.jaxb.csw.GetRecords;
import nl.b3p.csw.jaxb.filter.BinaryLogicOpType;
import nl.b3p.csw.jaxb.filter.FilterType;
import nl.b3p.csw.jaxb.filter.Or;
import nl.b3p.csw.jaxb.filter.PropertyIsEqualTo;
import nl.b3p.csw.jaxb.filter.PropertyIsLike;
import nl.b3p.csw.jaxb.filter.SortBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class CswSmartRequestCreator
extends CswRequestCreator {
    private static Log log = LogFactory.getLog(CswSmartRequestCreator.class);

    public static GetRecords createSmartCswRequest(String queryString) {
        return CswSmartRequestCreator.createSmartCswRequest(queryString, null, null, null);
    }

    public static GetRecords createSmartCswRequest(String queryString, BigInteger startPosition, BigInteger maxRecords, SortBy sortBy) {
        return CswSmartRequestCreator.createSmartCswRequest(queryString, null, startPosition, maxRecords, sortBy);
    }

    public static GetRecords createSmartCswRequest(String queryString, String propertyName) {
        return CswSmartRequestCreator.createSmartCswRequest(queryString, propertyName, null, null, null);
    }

    public static GetRecords createSmartCswRequest(String queryString, String propertyName, BigInteger startPosition, BigInteger maxRecords, SortBy sortBy) {
        if ((queryString = CswSmartRequestCreator.createQueryString(queryString, false)) == null) {
            return null;
        }
        if (queryString.trim().equals("*")) {
            return CswSmartRequestCreator.createCswRequest(queryString, propertyName, startPosition, maxRecords, sortBy, null, null, null);
        }
        propertyName = CswSmartRequestCreator.createPropertyName(propertyName);
        PropertyIsEqualTo propertyIsEqualTo = FilterCreator.createPropertyIsEqualTo(queryString, propertyName);
        StandardAnalyzer standardAnalyzer = new StandardAnalyzer(DutchAnalyzer.DUTCH_STOP_WORDS);
        TokenStream tokenStream = standardAnalyzer.tokenStream("", (Reader)new StringReader(queryString));
        BinaryLogicOpType binaryLogicOpType = new BinaryLogicOpType();
        binaryLogicOpType.getComparisonOpsOrSpatialOpsOrLogicOps().add(propertyIsEqualTo);
        try {
            Token token = null;
            while ((token = tokenStream.next()) != null) {
                String tokenString = new String(token.termBuffer()).trim();
                log.debug((Object)("term: " + tokenString));
                PropertyIsLike propertyIsLike = FilterCreator.createPropertyIsLike(tokenString, propertyName);
                binaryLogicOpType.getComparisonOpsOrSpatialOpsOrLogicOps().add(propertyIsLike);
            }
        }
        catch (IOException e) {
            PropertyIsLike propertyIsLike = FilterCreator.createPropertyIsLike(queryString, propertyName);
            binaryLogicOpType.getComparisonOpsOrSpatialOpsOrLogicOps().add(propertyIsLike);
        }
        Or or = new Or(binaryLogicOpType);
        FilterType filterType = new FilterType();
        filterType.setLogicOps(or);
        return CswSmartRequestCreator.createCswRequest(filterType, startPosition, maxRecords, sortBy);
    }
}

