/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.csw.util;

import java.net.URI;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.csw.util.Protocol;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;

public class OnlineResource {
    private URI url = null;
    private Protocol protocol = null;
    private String name = "";
    private String description = "";
    private String version = null;
    private Element metadata = null;
    private String metadataDescription = "";

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Element getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Element metadata) {
        this.metadata = metadata;
    }

    public String getMetadataDescription() {
        return this.metadataDescription;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMetadataDescription(String xslDocPath) throws Exception {
        if (this.metadata == null) {
            throw new Exception("Metadata not set.");
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslDocPath));
        if (transformer == null) {
            throw new Exception("Transformer could not be created. Wrong xslDocPath? Error in xslDoc?");
        }
        JDOMSource in = new JDOMSource(this.metadata);
        JDOMResult out = new JDOMResult();
        transformer.transform((Source)in, (Result)out);
        List result = out.getResult();
        if (result.size() > 0) {
            Object o = result.get(0);
            if (o instanceof Text) {
                Text text = (Text)result.get(0);
                this.metadataDescription = text.getTextTrim();
            } else if (o instanceof Element) {
                Element elem = (Element)result.get(0);
                this.metadataDescription = new XMLOutputter().outputString(elem);
            } else {
                this.metadataDescription = "";
            }
        } else {
            this.metadataDescription = "";
        }
    }

    public String toString() {
        return this.url + "; " + this.name + "; " + (Object)((Object)this.protocol);
    }
}

