/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.csw.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.naming.OperationNotSupportedException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.jdom.JDOMException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Util {
    protected static final Log log = LogFactory.getLog(Util.class);
    protected static final int SRID_RIJKSDRIEHOEKSTELSEL = 28992;
    protected static final String GML3_NAMESPACE = "http://www.opengis.net/gml";
    protected static final String GML3_BASEGEOM_OBJECT = "_Geometry";
    protected static final QName GML3_BASEGEOM_QNAME = new QName("http://www.opengis.net/gml", "_Geometry");

    public static JAXBElement readWkt(String wktFilter) throws ParseException, OperationNotSupportedException, IOException, JDOMException, JAXBException, NoSuchAuthorityCodeException, FactoryException, SAXException, TransformerException {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        Geometry geom = new WKTReader2(gf).read(wktFilter);
        Encoder encoder = new Encoder((Configuration)new GMLConfiguration());
        Document w3cDomDoc = encoder.encodeAsDOM((Object)geom, GML3_BASEGEOM_QNAME);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"nl.b3p.csw.jaxb.gml");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (JAXBElement)unmarshaller.unmarshal((Node)w3cDomDoc);
    }

    public static Schema createSchema(String path) throws SAXException, URISyntaxException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URI uri = cl.getResource(path).toURI();
        return sf.newSchema(new File(uri));
    }
}

