/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.csw.server;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBException;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.csw.client.JDOMResponseListener;
import nl.b3p.csw.client.OwsException;
import nl.b3p.csw.client.ResponseListenable;
import nl.b3p.csw.server.CswServable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public class GeoNetworkCswServer
implements CswServable<Document> {
    protected static Log log;
    protected CookieStore cookieStore = null;
    protected String cswDiscoveryUrl;
    protected String cswPublicationUrl;
    protected String loginUrl;
    protected String cswUser;
    protected String cswPassword;
    protected ResponseListenable<Document> responseListenable = null;

    public ResponseListenable getResponseListenable() {
        return this.responseListenable;
    }

    public void setResponseListenable(ResponseListenable responseListenable) {
        this.responseListenable = responseListenable;
    }

    public GeoNetworkCswServer(String loginUrl, String cswUrl, String cswUser, String cswPassword) {
        this(loginUrl, cswUrl, cswUser, cswPassword, new JDOMResponseListener());
    }

    public GeoNetworkCswServer(String loginUrl, String cswUrl, String cswUser, String cswPassword, ResponseListenable responseListenable) {
        log = LogFactory.getLog(this.getClass());
        log.info((Object)("Initializing " + this.getClass().getSimpleName()));
        this.loginUrl = loginUrl;
        this.cswDiscoveryUrl = cswUrl;
        this.cswPublicationUrl = cswUrl + "-publication";
        this.cswUser = cswUser;
        this.cswPassword = cswPassword;
        this.responseListenable = responseListenable;
    }

    @Override
    public Document doRequest(String cswRequestXml, boolean transaction) throws IOException, JDOMException, JAXBException, OwsException {
        String cswUrl;
        boolean preLoggedIn = false;
        try {
            preLoggedIn = this.login(this.loginUrl, this.cswUser, this.cswPassword);
        }
        catch (Exception e) {
            log.error((Object)("Geonetwork probably configured for old login methode, error: " + e.getLocalizedMessage()));
        }
        String string = cswUrl = transaction ? this.cswPublicationUrl : this.cswDiscoveryUrl;
        if (preLoggedIn) {
            return this.httpPostCswRequest(cswRequestXml, cswUrl);
        }
        return this.httpPostCswRequest(cswRequestXml, cswUrl, this.cswUser, this.cswPassword);
    }

    protected boolean login(String url, String username, String password) throws IOException, JDOMException, JAXBException, OwsException {
        if (url == null || username == null || password == null) {
            return false;
        }
        if (url.contains("j_spring_security_check")) {
            return this.httpPostCswLoginRequest(url, username, password);
        }
        if (url.contains("xml.user.login")) {
            StringBuilder loginMessage = new StringBuilder();
            loginMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            loginMessage.append("<request>");
            loginMessage.append("<username>");
            loginMessage.append(username);
            loginMessage.append("</username>");
            loginMessage.append("<password>");
            loginMessage.append(password);
            loginMessage.append("</password>");
            loginMessage.append("</request>");
            Document responseMessage = null;
            try {
                responseMessage = this.httpPostCswRequest(loginMessage.toString(), url);
            }
            catch (IOException ex) {
                throw new IOException("Error logging in on csw-server in old way: " + ex.getLocalizedMessage());
            }
            return responseMessage != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean httpPostCswLoginRequest(String url, String username, String password) throws IOException, JDOMException, JAXBException, OwsException {
        HttpClientConfigured hcc = new HttpClientConfigured(null);
        HttpClientContext context = hcc.getContext();
        if (this.cookieStore != null) {
            context.setCookieStore(this.cookieStore);
        }
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/x-www-form-urlencoded");
        String data = "username=" + username + "&password=" + password;
        post.setEntity((HttpEntity)new StringEntity(data, ContentType.TEXT_XML));
        HttpResponse response = hcc.execute((HttpUriRequest)post);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            log.debug((Object)("Status code: " + statusCode));
            this.cookieStore = context.getCookieStore();
        }
        catch (Exception ex) {
            log.debug((Object)"Exception login: ", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            hcc.close(response);
            hcc.close();
        }
        return true;
    }

    protected Document httpPostCswRequest(String request, String url) throws IOException, JDOMException, JAXBException, OwsException {
        return this.httpPostCswRequest(request, url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document httpPostCswRequest(String request, String url, String username, String password) throws IOException, JDOMException, JAXBException, OwsException {
        B3PCredentials credentials = new B3PCredentials();
        credentials.setUserName(username);
        credentials.setPassword(password);
        credentials.setUrl(url);
        credentials.setPreemptive(true);
        HttpClientConfigured hcc = new HttpClientConfigured(credentials);
        HttpClientContext context = hcc.getContext();
        if (this.cookieStore != null) {
            context.setCookieStore(this.cookieStore);
        }
        HttpPost post = new HttpPost(url);
        post.addHeader("Accept", "text/xml");
        post.addHeader("Accept-Charset", "utf-8");
        post.addHeader("Content-Encoding", "utf-8");
        post.setEntity((HttpEntity)new StringEntity(request, ContentType.create((String)"text/xml", (Charset)Charset.forName("utf-8"))));
        HttpResponse response = hcc.execute((HttpUriRequest)post);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (statusCode != 200) {
                throw new IOException("Url: " + url + ". Reason: " + response.getStatusLine());
            }
            this.cookieStore = context.getCookieStore();
            log.debug((Object)"Present cookies: ");
            if (this.cookieStore != null) {
                for (Cookie cookie : this.cookieStore.getCookies()) {
                    log.debug((Object)(" - " + cookie.toString()));
                }
            }
            Document document = this.responseListenable.handleResponse(entity.getContent());
            return document;
        }
        finally {
            hcc.close(response);
            hcc.close();
        }
    }
}

