/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.csv;

import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import nl.b3p.commons.csv.CsvFormatException;
import nl.b3p.commons.csv.CsvInputStream;
import nl.b3p.gis.FeatureFactory;
import nl.b3p.gis.FeatureSchemaFactory;
import nl.b3p.gis.writers.B3pOgcSqlWriter;

public class CsvReader {
    public static final String DEFAULT_ignoredColumnName1 = "id";
    public static final String DEFAULT_geomColumnName = "the_geom";
    public static final String DEFAULT_srs = "28992";
    public static final String DEFAULT_tsColumnName = "TS";
    public static final String DEFAULT_rdxColumnName = "RDX";
    public static final String DEFAULT_rdyColumnName = "RDY";
    private String tableName;
    private String[] ignoredColumnNames;
    private String geomColumnName;
    private String srs;
    private String tsColumnName;
    private String timestamp;
    private String spaceName;
    private String spaceValue;
    private String[] uidNames;
    private String rdxColumnName;
    private String rdyColumnName;
    private Locale csvLocale;
    private DecimalFormatSymbols dfs;
    private char csvSeparator;
    private HashMap translatorMap = null;
    private boolean useMultiPoint = false;
    private String ignoreValue;
    private boolean doInsert = false;

    public CsvReader(String tableName, String spaceName, String spaceValue, String[] uidNames) {
        this(tableName, spaceName, spaceValue, uidNames, null, ',', false);
    }

    public CsvReader(String tableName, String spaceName, String spaceValue, String[] uidNames, Locale loc, char csvSeparator, boolean useMultiPoint) {
        this.setTableName(tableName);
        this.setSpaceName(spaceName);
        this.setSpaceValue(spaceValue);
        this.setUidNames(uidNames);
        this.setCsvLocale(loc);
        this.setCsvSeparator(csvSeparator);
        this.fillDefaults();
        this.useMultiPoint = useMultiPoint;
    }

    protected void fillDefaults() {
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("yyyy-MM-dd HH:mm:sss");
        this.timestamp = sdf.format(new Date());
        this.ignoredColumnNames = new String[]{DEFAULT_ignoredColumnName1};
        this.geomColumnName = DEFAULT_geomColumnName;
        this.srs = DEFAULT_srs;
        this.tsColumnName = DEFAULT_tsColumnName;
        this.rdxColumnName = DEFAULT_rdxColumnName;
        this.rdyColumnName = DEFAULT_rdyColumnName;
    }

    public void csvOgcSqlETL(Connection conn, CsvInputStream cis) throws SQLException, IOException, CsvFormatException, Exception {
        FeatureSchema fs = this.getFeatureSchema(conn);
        FeatureDataset fc = this.readFeatureDataset(fs, cis);
        this.writeFeatureDataset(conn, fc);
    }

    public FeatureSchema getFeatureSchema(Connection conn) throws SQLException, Exception {
        return FeatureSchemaFactory.createFeatureSchemaFromDbTable(conn, this.getTableName(), this.getIgnoredColumnNames());
    }

    public FeatureDataset readFeatureDataset(FeatureSchema fs, CsvInputStream cis) throws IOException, CsvFormatException {
        cis.setSeparator(this.getCsvSeparator());
        FeatureDataset fc = new FeatureDataset(fs);
        int columnCount = fs.getAttributeCount();
        List columnList = cis.readRecordAsList();
        if (columnList == null || columnList.isEmpty()) {
            throw new CsvFormatException("No file found");
        }
        if (columnCount > 1 && columnList.size() <= 1) {
            throw new CsvFormatException("More columns expected (separator used: '" + this.getCsvSeparator() + "')");
        }
        cis.setCheckColumnCount(true);
        int rdxindex = -1;
        int rdyindex = -1;
        columnList = this.processColumns(columnList);
        if (columnList != null) {
            rdxindex = columnList.indexOf(this.getRdxColumnName());
            rdyindex = columnList.indexOf(this.getRdyColumnName());
        }
        String[] columns = null;
        if (columnList != null) {
            columns = columnList.toArray(new String[0]);
        }
        List attributeList = null;
        while ((attributeList = cis.readRecordAsList()) != null) {
            attributeList = this.processAttributes(attributeList, columnList);
            double rdx = 0.0;
            double rdy = 0.0;
            if (rdxindex >= 0) {
                rdx = this.getDoubleFromString((String)attributeList.get(rdxindex));
            }
            if (rdyindex >= 0) {
                rdy = this.getDoubleFromString((String)attributeList.get(rdyindex));
            }
            Object[] attributes = attributeList.toArray(new Object[0]);
            BasicFeature f = FeatureFactory.createPointFeature(attributes, columns, rdx, rdy, fs, this.useMultiPoint);
            fc.add((Feature)f);
        }
        return fc;
    }

    public void writeFeatureDataset(Connection conn, FeatureDataset fc) throws SQLException, Exception {
        B3pOgcSqlWriter bow = new B3pOgcSqlWriter(conn);
        bow.setBatchValue(0);
        String[] columnsToCheck = null;
        if (!this.doInsert) {
            int len = 0;
            if (this.getUidNames() != null) {
                len = this.getUidNames().length;
            }
            if (len == 0 && this.getSpaceName() != null) {
                columnsToCheck = new String[]{this.getSpaceName()};
            } else if (this.getSpaceName() != null) {
                columnsToCheck = new String[len + 1];
                for (int i = 0; i < len; ++i) {
                    columnsToCheck[i] = this.getUidNames()[i];
                }
                columnsToCheck[len] = this.getSpaceName();
            } else {
                columnsToCheck = this.getUidNames();
            }
        }
        bow.write((FeatureCollection)fc, this.getTableName(), this.getGeomColumnName(), this.getSrs(), 2, false, true, columnsToCheck, this.getIgnoreValue());
    }

    protected List translateColumns(List columns) {
        if (columns == null) {
            return null;
        }
        ArrayList<String> newColumns = new ArrayList<String>();
        if (this.getTranslatorMap() != null) {
            for (int i = 0; i < columns.size(); ++i) {
                String newColumnName = (String)this.getTranslatorMap().get(columns.get(i));
                if (newColumnName != null && newColumnName.length() > 0) {
                    newColumns.add(newColumnName);
                    continue;
                }
                newColumns.add((String)columns.get(i));
            }
        }
        return newColumns;
    }

    protected List processColumns(List columns) {
        if (columns == null) {
            return null;
        }
        List newColumns = this.translateColumns(columns);
        if (this.getTsColumnName() != null && this.getTsColumnName().length() > 0) {
            newColumns.add(this.getTsColumnName());
        }
        if (this.getSpaceName() != null && this.getSpaceName().length() > 0) {
            newColumns.add(this.getSpaceName());
        }
        return newColumns;
    }

    protected List processAttributes(List attributes, List columns) {
        if (attributes == null) {
            return null;
        }
        if (this.getTsColumnName() != null && this.getTsColumnName().length() > 0) {
            attributes.add(this.getTimestamp());
        }
        if (this.getSpaceName() != null && this.getSpaceName().length() > 0) {
            attributes.add(this.getSpaceValue());
        }
        return attributes;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getIgnoredColumnNames() {
        return this.ignoredColumnNames;
    }

    public void setIgnoredColumnNames(String[] ignoredColumnNames) {
        this.ignoredColumnNames = ignoredColumnNames;
    }

    public String getGeomColumnName() {
        return this.geomColumnName;
    }

    public void setGeomColumnName(String geomColumnName) {
        this.geomColumnName = geomColumnName;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    public String getTsColumnName() {
        return this.tsColumnName;
    }

    public void setTsColumnName(String tsColumnName) {
        this.tsColumnName = tsColumnName;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public String getSpaceValue() {
        return this.spaceValue;
    }

    public void setSpaceValue(String spaceValue) {
        this.spaceValue = spaceValue;
    }

    public String[] getUidNames() {
        return this.uidNames;
    }

    public void setUidNames(String[] uidNames) {
        this.uidNames = uidNames;
    }

    public String getRdxColumnName() {
        return this.rdxColumnName;
    }

    public void setRdxColumnName(String rdxColumnName) {
        this.rdxColumnName = rdxColumnName;
    }

    public String getRdyColumnName() {
        return this.rdyColumnName;
    }

    public void setRdyColumnName(String rdyColumnName) {
        this.rdyColumnName = rdyColumnName;
    }

    public HashMap getTranslatorMap() {
        return this.translatorMap;
    }

    public void setTranslatorMap(HashMap translatorMap) {
        this.translatorMap = translatorMap;
    }

    public Locale getCsvLocale() {
        return this.csvLocale;
    }

    public void setCsvLocale(Locale csvLocale) {
        this.csvLocale = csvLocale;
    }

    public DecimalFormatSymbols getDfs() {
        if (this.csvLocale == null) {
            this.csvLocale = Locale.getDefault();
        }
        this.dfs = new DecimalFormatSymbols(this.csvLocale);
        return this.dfs;
    }

    public char getCsvSeparator() {
        return this.csvSeparator;
    }

    public void setCsvSeparator(char csvSeparator) {
        this.csvSeparator = csvSeparator;
    }

    public String getIgnoreValue() {
        return this.ignoreValue;
    }

    public void setIgnoreValue(String ignoreValue) {
        this.ignoreValue = ignoreValue;
    }

    private double getDoubleFromString(String d) {
        if (d == null) {
            return 0.0;
        }
        DecimalFormat df = new DecimalFormat("#", this.getDfs());
        ParsePosition pos = new ParsePosition(0);
        Number n = df.parse(d.trim(), pos);
        if (n == null) {
            return 0.0;
        }
        return n.doubleValue();
    }

    public boolean isDoInsert() {
        return this.doInsert;
    }

    public void setDoInsert(boolean doInsert) {
        this.doInsert = doInsert;
    }
}

