/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.util.List;
import nl.b3p.ogc.utils.OGCConstants;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCResponse;
import nl.b3p.ogc.utils.SpLayerSummary;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFSDescribeFeatureTypeResponse
extends OGCResponse
implements OGCConstants {
    private Document doc = null;

    @Override
    public void rebuildResponse(Document doc, OGCRequest request, String prefix) throws Exception {
        this.setUsableResponse(true);
        this.findNameSpace(doc);
        this.rebuildNodeWithNameReplace(doc, prefix);
        this.doc = doc;
    }

    @Override
    public String getResponseBody(List<SpLayerSummary> layers, OGCRequest ogcrequest, String encoding) {
        if (!this.isUsableResponse()) {
            if (this.hasWfsV100ErrorResponse()) {
                return this.getWfsV100ErrorResponseBody(encoding);
            }
            if (this.hasOwsV100ErrorResponse()) {
                return this.getOwsV100ErrorResponseBody(encoding);
            }
            throw new UnsupportedOperationException("Failed to get suitable reponse! ");
        }
        if (this.hasWfsV100ErrorResponse()) {
            this.logErrorResponse(encoding);
        }
        try {
            return this.serializeNode(this.doc);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Failed to get body of XML! Exception: " + ex);
        }
    }

    private void rebuildNodeWithNameReplace(Node currentNode, String spAbbr) throws Exception {
        String prefix = this.getNameSpacePrefix("http://www.w3.org/2001/XMLSchema", true);
        String parentPath = "/";
        if (prefix != null && prefix.length() > 0) {
            parentPath = parentPath + prefix;
            parentPath = parentPath + ":";
        }
        parentPath = parentPath + "schema";
        Node parentNode = null;
        NodeList parentNodes = this.getNodeListFromXPath(currentNode, parentPath);
        if (parentNodes.getLength() == 1) {
            parentNode = parentNodes.item(0);
            NodeList nodes = parentNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node nameAttr;
                NamedNodeMap nnm;
                Node n = nodes.item(i);
                if (!"element".equals(n.getLocalName()) || !"http://www.w3.org/2001/XMLSchema".equals(n.getNamespaceURI()) || (nnm = n.getAttributes()) == null || (nameAttr = nnm.getNamedItem("name")) == null) continue;
                String textContent = nameAttr.getTextContent();
                String newName = this.determineFeatureTypeName(spAbbr, textContent);
                nameAttr.setTextContent(newName);
            }
        }
    }
}

