/*
 * B3P Commons GIS is a library with commonly used classes for OGC
 * reading and writing. Included are wms, wfs, gml, csv and other
 * general helper classes and extensions.
 *
 * Copyright 2005 - 2008 B3Partners BV
 * 
 * This file is part of B3P Commons GIS.
 * 
 * B3P Commons GIS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * B3P Commons GIS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with B3P Commons GIS.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * This class was automatically generated with 
 * <a href="http://www.castor.org">Castor 1.0.2</a>, using an XML
 * Schema.
 * $Id$
 */

package nl.b3p.ogc.wfs.v110;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Collections;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

/**
 * The DescribeFeatureType operation allows a client application
 *  to request that a Web Feature Service describe one or more
 *  feature types. A Web Feature Service must be able to generate
 *  feature descriptions as valid GML3 application schemas.
 * 
 *  The schemas generated by the DescribeFeatureType operation can
 *  be used by a client application to validate the output.
 * 
 *  Feature instances within the WFS interface must be specified
 *  using GML3. The schema of feature instances specified within
 *  the WFS interface must validate against the feature schemas 
 *  generated by the DescribeFeatureType request.
 *  
 * 
 * @version $Revision$ $Date$
 */
public class DescribeFeatureTypeType extends nl.b3p.ogc.wfs.v110.BaseRequestType 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The outputFormat attribute is used to specify what schema
     *  description language should be used to describe features.
     *  The default value of 'text/xml; subtype=3.1.1' means that
     *  the WFS must generate a GML3 application schema that can
     *  be used to validate the GML3 output of a GetFeature
     *  request or feature instances specified in Transaction
     *  operations.
     *  For the purposes of experimentation, vendor extension,
     *  or even extensions that serve a specific community of
     *  interest, other acceptable output format values may be
     *  advertised by a WFS service in the capabilities document.
     *  The meaning of such values in not defined in the WFS 
     *  specification. The only proviso is such cases is that
     *  clients may safely ignore outputFormat values that do
     *  not recognize.
     *  
     */
    private java.lang.String _outputFormat = "text/xml; subtype=gml/3.1.1";

    /**
     * The TypeName element is used to enumerate the
     *  feature types to be described. If no TypeName
     *  elements are specified then all features should
     *  be described. The name must be a valid type
     *  that belongs to the feature content as defined
     *  by the GML Application Schema.
     *  
     */
    private java.util.ArrayList _typeNameList;


      //----------------/
     //- Constructors -/
    //----------------/

    public DescribeFeatureTypeType() 
     {
        super();
        setOutputFormat("text/xml; subtype=gml/3.1.1");
        _typeNameList = new java.util.ArrayList();
    } //-- nl.b3p.ogc.wfs.v110.DescribeFeatureTypeType()


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addTypeName
     * 
     * 
     * 
     * @param vTypeName
     */
    public void addTypeName(java.lang.String vTypeName)
        throws java.lang.IndexOutOfBoundsException
    {
        _typeNameList.add(vTypeName);
    } //-- void addTypeName(java.lang.String) 

    /**
     * Method addTypeName
     * 
     * 
     * 
     * @param index
     * @param vTypeName
     */
    public void addTypeName(int index, java.lang.String vTypeName)
        throws java.lang.IndexOutOfBoundsException
    {
        _typeNameList.add(index, vTypeName);
    } //-- void addTypeName(int, java.lang.String) 

    /**
     * Method clearTypeName
     * 
     */
    public void clearTypeName()
    {
        _typeNameList.clear();
    } //-- void clearTypeName() 

    /**
     * Method enumerateTypeName
     * 
     * 
     * 
     * @return Enumeration
     */
    public java.util.Enumeration enumerateTypeName()
    {
        return Collections.enumeration(_typeNameList);
    } //-- java.util.Enumeration enumerateTypeName() 

    /**
     * Returns the value of field 'outputFormat'. The field
     * 'outputFormat' has the following description: The
     * outputFormat attribute is used to specify what schema
     *  description language should be used to describe features.
     *  The default value of 'text/xml; subtype=3.1.1' means that
     *  the WFS must generate a GML3 application schema that can
     *  be used to validate the GML3 output of a GetFeature
     *  request or feature instances specified in Transaction
     *  operations.
     *  For the purposes of experimentation, vendor extension,
     *  or even extensions that serve a specific community of
     *  interest, other acceptable output format values may be
     *  advertised by a WFS service in the capabilities document.
     *  The meaning of such values in not defined in the WFS 
     *  specification. The only proviso is such cases is that
     *  clients may safely ignore outputFormat values that do
     *  not recognize.
     *  
     * 
     * @return String
     * @return the value of field 'outputFormat'.
     */
    public java.lang.String getOutputFormat()
    {
        return this._outputFormat;
    } //-- java.lang.String getOutputFormat() 

    /**
     * Method getTypeName
     * 
     * 
     * 
     * @param index
     * @return String
     */
    public java.lang.String getTypeName(int index)
        throws java.lang.IndexOutOfBoundsException
    {
        //-- check bounds for index
        if ((index < 0) || (index >= _typeNameList.size())) {
            throw new IndexOutOfBoundsException();
        }
        
        return (String)_typeNameList.get(index);
    } //-- java.lang.String getTypeName(int) 

    /**
     * Method getTypeName
     * 
     * 
     * 
     * @return String
     */
    public java.lang.String[] getTypeName()
    {
        int size = _typeNameList.size();
        java.lang.String[] mArray = new java.lang.String[size];
        for (int index = 0; index < size; index++) {
            mArray[index] = (String)_typeNameList.get(index);
        }
        return mArray;
    } //-- java.lang.String[] getTypeName() 

    /**
     * Method getTypeNameCount
     * 
     * 
     * 
     * @return int
     */
    public int getTypeNameCount()
    {
        return _typeNameList.size();
    } //-- int getTypeNameCount() 

    /**
     * Method isValid
     * 
     * 
     * 
     * @return boolean
     */
    public boolean isValid()
    {
        try {
            validate();
        }
        catch (org.exolab.castor.xml.ValidationException vex) {
            return false;
        }
        return true;
    } //-- boolean isValid() 

    /**
     * Method marshal
     * 
     * 
     * 
     * @param out
     */
    public void marshal(java.io.Writer out)
        throws org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        
        Marshaller.marshal(this, out);
    } //-- void marshal(java.io.Writer) 

    /**
     * Method marshal
     * 
     * 
     * 
     * @param handler
     */
    public void marshal(org.xml.sax.ContentHandler handler)
        throws java.io.IOException, org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        
        Marshaller.marshal(this, handler);
    } //-- void marshal(org.xml.sax.ContentHandler) 

    /**
     * Method removeTypeName
     * 
     * 
     * 
     * @param vTypeName
     * @return boolean
     */
    public boolean removeTypeName(java.lang.String vTypeName)
    {
        boolean removed = _typeNameList.remove(vTypeName);
        return removed;
    } //-- boolean removeTypeName(java.lang.String) 

    /**
     * Sets the value of field 'outputFormat'. The field
     * 'outputFormat' has the following description: The
     * outputFormat attribute is used to specify what schema
     *  description language should be used to describe features.
     *  The default value of 'text/xml; subtype=3.1.1' means that
     *  the WFS must generate a GML3 application schema that can
     *  be used to validate the GML3 output of a GetFeature
     *  request or feature instances specified in Transaction
     *  operations.
     *  For the purposes of experimentation, vendor extension,
     *  or even extensions that serve a specific community of
     *  interest, other acceptable output format values may be
     *  advertised by a WFS service in the capabilities document.
     *  The meaning of such values in not defined in the WFS 
     *  specification. The only proviso is such cases is that
     *  clients may safely ignore outputFormat values that do
     *  not recognize.
     *  
     * 
     * @param outputFormat the value of field 'outputFormat'.
     */
    public void setOutputFormat(java.lang.String outputFormat)
    {
        this._outputFormat = outputFormat;
    } //-- void setOutputFormat(java.lang.String) 

    /**
     * Method setTypeName
     * 
     * 
     * 
     * @param index
     * @param vTypeName
     */
    public void setTypeName(int index, java.lang.String vTypeName)
        throws java.lang.IndexOutOfBoundsException
    {
        //-- check bounds for index
        if ((index < 0) || (index >= _typeNameList.size())) {
            throw new IndexOutOfBoundsException();
        }
        _typeNameList.set(index, vTypeName);
    } //-- void setTypeName(int, java.lang.String) 

    /**
     * Method setTypeName
     * 
     * 
     * 
     * @param typeNameArray
     */
    public void setTypeName(java.lang.String[] typeNameArray)
    {
        //-- copy array
        _typeNameList.clear();
        for (int i = 0; i < typeNameArray.length; i++) {
            _typeNameList.add(typeNameArray[i]);
        }
    } //-- void setTypeName(java.lang.String) 

    /**
     * Method unmarshal
     * 
     * 
     * 
     * @param reader
     * @return BaseRequestType
     */
    public static nl.b3p.ogc.wfs.v110.BaseRequestType unmarshal(java.io.Reader reader)
        throws org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        return (nl.b3p.ogc.wfs.v110.BaseRequestType) Unmarshaller.unmarshal(nl.b3p.ogc.wfs.v110.DescribeFeatureTypeType.class, reader);
    } //-- nl.b3p.ogc.wfs.v110.BaseRequestType unmarshal(java.io.Reader) 

    /**
     * Method validate
     * 
     */
    public void validate()
        throws org.exolab.castor.xml.ValidationException
    {
        org.exolab.castor.xml.Validator validator = new org.exolab.castor.xml.Validator();
        validator.validate(this);
    } //-- void validate() 

}
