/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerSummary {
    private Integer layerId = null;
    private String layerName = null;
    private String spAbbr = null;
    private String prefix = null;
    private String nsUrl = null;
    private String error = null;
    private String queryable = null;
    private Set<Style> styles;

    public LayerSummary(Integer layerId, String layerName, String spAbbr, String queryable, Set styles) {
        this.layerId = layerId;
        this.layerName = layerName;
        this.spAbbr = spAbbr;
        this.queryable = queryable;
        this.styles = styles;
    }

    public LayerSummary(Layer l, String queryable) {
        this(l.getId(), l.getName(), l.getServiceProvider().getAbbr(), queryable, l.getStyles());
    }

    public LayerSummary(WfsLayer l, String queryable) {
        this(l.getId(), l.getName(), l.getWfsServiceProvider().getAbbr(), queryable, null);
    }

    public LayerSummary() {
    }

    public Integer getLayerId() {
        return this.layerId;
    }

    public void setLayerId(Integer layerId) {
        this.layerId = layerId;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getSpAbbr() {
        return this.spAbbr;
    }

    public String getQueryable() {
        return this.queryable;
    }

    public void setQueryable(String queryable) {
        this.queryable = queryable;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNsUrl() {
        return this.nsUrl;
    }

    public void setNsUrl(String nsUrl) {
        this.nsUrl = nsUrl;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Set<Style> getStyles() {
        return this.styles;
    }

    public void setStyles(Set<Style> styles) {
        this.styles = styles;
    }

    public Style getStyle(String styleName) {
        if (styleName == null || this.getStyles() == null) {
            return null;
        }
        for (Style s : this.getStyles()) {
            if (!styleName.equals(s.getName())) continue;
            return s;
        }
        return null;
    }

    public void addStyles(Set<Style> styles) {
        if (this.getStyles() == null) {
            this.setStyles(new HashSet<Style>());
        }
        this.getStyles().addAll(styles);
    }

    public void setSpAbbr(String spAbbr) {
        this.spAbbr = spAbbr;
    }

    public static List<LayerSummary> createLayerSummaryList(List<String> layers, String spInUrl, boolean splitName) throws Exception {
        ArrayList<LayerSummary> tempList = new ArrayList<LayerSummary>();
        Iterator<String> it = layers.iterator();
        while (it.hasNext()) {
            String layer = it.next().toString();
            LayerSummary m = OGCCommunication.splitLayerWithoutNsFix(layer, splitName, spInUrl, null);
            String spAbbr = m.getSpAbbr();
            if (spInUrl == null) {
                tempList.add(m);
                continue;
            }
            if (!spAbbr.equals(spInUrl) && !spAbbr.equals(KBConfiguration.SERVICEPROVIDER_BASE_ABBR)) continue;
            tempList.add(m);
        }
        return tempList;
    }

    public String getLayersAsString(List<LayerSummary> lsl) {
        if (lsl == null) {
            return null;
        }
        StringBuffer ll = new StringBuffer();
        for (LayerSummary l : lsl) {
            if (ll.length() != 0) {
                ll.append(",");
            }
            ll.append(OGCCommunication.buildLayerNameWithoutSp(l));
        }
        return ll.toString();
    }

    public static String[] getLayersAsArray(List<LayerSummary> lsl) {
        if (lsl == null) {
            return null;
        }
        String[] la = new String[lsl.size()];
        for (int i = 0; i < lsl.size(); ++i) {
            LayerSummary l = lsl.get(i);
            la[i] = OGCCommunication.buildLayerNameWithoutSp(l);
        }
        return la;
    }
}

