/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCConstants;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.xml.ogc.v100.exception.ServiceExceptionReport;
import nl.b3p.xml.ows.v100.ExceptionReport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OGCResponse
extends OGCCommunication
implements OGCConstants {
    protected static final Log log = LogFactory.getLog(OGCResponse.class);
    protected String httpHost;
    protected String version;
    protected ServiceExceptionReport newWfsV100ExceptionReport;
    protected ExceptionReport newOwsV100ExceptionReport;
    protected boolean usableResponse = false;
    protected boolean alreadyDirectWritten = false;

    protected OGCResponse() {
    }

    public static boolean isWfsV100ErrorResponse(Element rootElement) {
        String tagName = OGCRequest.removeNamespace(rootElement.getTagName());
        return tagName.equalsIgnoreCase("ServiceExceptionReport");
    }

    public static boolean isOwsV100ErrorResponse(Element rootElement) {
        String tagName = OGCRequest.removeNamespace(rootElement.getTagName());
        return tagName.equalsIgnoreCase("ExceptionReport");
    }

    public abstract void rebuildResponse(Document var1, OGCRequest var2, String var3) throws Exception;

    public abstract String getResponseBody(List<SpLayerSummary> var1, OGCRequest var2, String var3);

    public void setUsableResponse(boolean usable) {
        this.usableResponse = usable;
    }

    public boolean isUsableResponse() {
        return this.usableResponse;
    }

    public boolean hasWfsV100ErrorResponse() {
        return this.newWfsV100ExceptionReport != null;
    }

    public boolean hasOwsV100ErrorResponse() {
        return this.newOwsV100ExceptionReport != null;
    }

    public void logErrorResponse(String encoding) {
        if (this.hasWfsV100ErrorResponse()) {
            log.error((Object)("Response was given while an underlying error (WFS 1.0.0) was detected but ignored: " + this.getWfsV100ErrorResponseBody(encoding)));
        }
        if (this.hasOwsV100ErrorResponse()) {
            log.error((Object)("Response was given while an underlying error (OWS 1.0.0) was detected but ignored: " + this.getOwsV100ErrorResponseBody(encoding)));
        }
    }

    public void rebuildWfsV100ErrorResponse(Document doc, OGCRequest request, String prefix) throws Exception {
        ServiceExceptionReport exceptionReport;
        Element element = doc.getDocumentElement();
        this.httpHost = request.getUrlWithNonOGCparams();
        this.version = request.getFinalVersion();
        Unmarshaller um = new Unmarshaller(ServiceExceptionReport.class);
        Object o = um.unmarshal((Node)element);
        this.newWfsV100ExceptionReport = exceptionReport = (ServiceExceptionReport)o;
    }

    public void rebuildOwsV100ErrorResponse(Document doc, OGCRequest request, String prefix) throws Exception {
        ExceptionReport exceptionReport;
        Element element = doc.getDocumentElement();
        this.httpHost = request.getUrlWithNonOGCparams();
        this.version = request.getFinalVersion();
        Unmarshaller um = new Unmarshaller(ExceptionReport.class);
        Object o = um.unmarshal((Node)element);
        this.newOwsV100ExceptionReport = exceptionReport = (ExceptionReport)o;
    }

    public String getWfsV100ErrorResponseBody(String encoding) {
        ServiceExceptionReport castorObject = this.newWfsV100ExceptionReport;
        return this.marshalObject(castorObject, encoding);
    }

    public String getOwsV100ErrorResponseBody(String encoding) {
        ExceptionReport castorObject = this.newOwsV100ExceptionReport;
        return this.marshalObject(castorObject, encoding);
    }

    protected String marshalObject(Object castorObject) {
        return this.marshalObject(castorObject, null);
    }

    protected String marshalObject(Object castorObject, String encoding) {
        String body = null;
        try {
            String location;
            String prefix;
            int i;
            Iterator it;
            Set keys;
            StringWriter sw = new StringWriter();
            Marshaller m = new Marshaller((Writer)sw);
            m.setEncoding(encoding);
            if (this.getNameSpaces() != null) {
                keys = this.getNameSpaces().keySet();
                it = keys.iterator();
                i = 0;
                while (it.hasNext()) {
                    prefix = (String)it.next();
                    location = this.getNameSpace(prefix);
                    m.setNamespaceMapping(prefix, location);
                    ++i;
                }
            }
            if (this.getSchemaLocations() != null) {
                keys = this.getSchemaLocations().keySet();
                it = keys.iterator();
                i = 0;
                while (it.hasNext()) {
                    prefix = (String)it.next();
                    location = (String)this.getSchemaLocations().get(prefix);
                    m.setSchemaLocation(location);
                    ++i;
                }
            }
            if (castorObject != null) {
                m.marshal(castorObject);
                body = sw.toString();
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to get body of XML! Exception: " + e);
        }
        return body;
    }

    protected NodeList getNodeListFromXPath(Node currentNode, String xPathFrag) throws Exception {
        if (xPathFrag == null || xPathFrag.length() == 0) {
            return null;
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(this.getNamespaceContext());
        XPathExpression expr = xpath.compile(xPathFrag);
        Object result = expr.evaluate(currentNode, XPathConstants.NODESET);
        return (NodeList)result;
    }

    public String getRequestName(String responseName, List<SpLayerSummary> spLayerMapList, String spInUrl) throws Exception {
        for (SpLayerSummary sls : spLayerMapList) {
            LayerSummary responseLayerMap = this.splitLayerInParts(responseName, spInUrl == null, spInUrl, null);
            String responseLayerName = responseLayerMap.getLayerName();
            if (responseLayerName == null) {
                return null;
            }
            List<LayerSummary> lsl = sls.getLayers();
            for (LayerSummary requestLayerMap : lsl) {
                String requestLayerName = requestLayerMap.getLayerName();
                if (requestLayerName == null || !requestLayerName.equals(responseLayerName)) continue;
                if (spInUrl == null) {
                    return OGCResponse.buildFullLayerName(requestLayerMap);
                }
                return OGCResponse.buildLayerNameWithoutSp(requestLayerMap);
            }
        }
        return null;
    }

    protected String serializeNode(Node doc) throws TransformerConfigurationException, TransformerException {
        StringWriter outText = new StringWriter();
        StreamResult sr = new StreamResult(outText);
        Properties oprops = new Properties();
        oprops.put("method", "xml");
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperties(oprops);
        t.transform(new DOMSource(doc), sr);
        return outText.toString();
    }

    public boolean isAlreadyDirectWritten() {
        return this.alreadyDirectWritten;
    }

    public void setAlreadyDirectWritten(boolean alreadyDirectWritten) {
        this.alreadyDirectWritten = alreadyDirectWritten;
    }
}

