/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.xml.wfs.WFS_Capabilities;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Element;

public class OGCScriptingRequest
extends OGCRequest {
    public static final String COMMAND = "command";
    public static final String LOCATION = "location";
    public static final String UPDATE_SERVICES = "update_services";
    public static final String SERVICE_TYPE = "service_type";
    public static final String ABBR = "abbr";
    public static final String URL = "url";
    public static final String SLD = "sld";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String ADD_SERVICE = "add_service";
    public static final String GROUPS = "groups";
    public static final String NAME = "name";
    public static final String UPDATE = "update";
    public static final String ADD_ALLOWED_SERVICES = "add_allowed_services";
    public static final String DELETE_ALLOWED_SERVICES = "delete_allowed_services";
    public static final String DELETE_ALL_ALLOWED_SERVICES = "delete_all_allowed_services";
    public static final String GET_GROUP_XML = "get_group_xml";
    protected HashSet<String> acceptable;

    public OGCScriptingRequest() {
    }

    public OGCScriptingRequest(String url) {
        super(url);
    }

    private void populateAcceptable() {
        this.acceptable = new HashSet();
        this.acceptable.add(UPDATE_SERVICES);
    }

    public static String removeNamespace(String tagName) {
        return "Not supported";
    }

    public LayerSummary splitLayerInParts(String fullLayerName) {
        return this.splitLayerInParts(fullLayerName, true, null, null);
    }

    public LayerSummary splitLayerInParts(String fullLayerName, boolean splitName, String defaultSp, String defaultNs) {
        LayerSummary returnMap = new LayerSummary();
        returnMap.setError("Not supported");
        return returnMap;
    }

    public OGCScriptingRequest(Element rootElement, String url) throws ValidationException, Exception {
        this.parameters = new HashMap();
        this.setUrl(url);
        this.setFinalVersion(rootElement.getAttribute("VERSION".toLowerCase()));
        String version = this.finalVersion;
    }

    public String getXMLBody() throws Exception {
        throw new Exception("Not supported");
    }

    public String getUrlWithNonOGCparams() {
        OGCScriptingRequest ogcu = (OGCScriptingRequest)this.clone();
        return ogcu.getUrl();
    }

    public HashMap getNonOGCParameters() {
        OGCScriptingRequest o = (OGCScriptingRequest)this.clone();
        return o.getParameters();
    }

    public String addOrReplaceParameter(String param, String v) {
        String value;
        try {
            value = v != null ? URLDecoder.decode(v, "UTF-8") : v;
        }
        catch (UnsupportedEncodingException ex) {
            value = v;
            log.error((Object)"Error deconding value. Try with the original value", (Throwable)ex);
        }
        if (param == null) {
            return null;
        }
        param = param.toUpperCase();
        Object o = this.parameters.get(param);
        if (value != null) {
            value = value.trim();
        }
        if ("TYPENAME".equals(param)) {
            int index1 = param.indexOf("{");
            int index2 = param.indexOf("}");
            if (index1 >= 0 && index2 >= 0) {
                String nameSpaceUri = param.substring(index1 + 1, index2);
                param = ":" + param.substring(index2 + 1);
            }
        }
        this.parameters.put(param, value);
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    public void removeAllWMSParameters() {
    }

    public void removeAllWFSParameters() {
    }

    public String[] getNameSpacesArray() {
        return null;
    }

    public void addOrReplaceNameSpace(String prefix, String nsUrl) {
    }

    public String[] getSchemaLocationsArray() {
        return null;
    }

    public void addOrReplaceSchemaLocation(String prefix, String location) {
    }

    public Object clone() {
        OGCScriptingRequest returnv = new OGCScriptingRequest();
        returnv.fixHttpHost(new String(this.getHttpHost()));
        if (this.getPassword() != null) {
            returnv.setPassword(new String(this.getPassword()));
        }
        if (this.getUsername() != null) {
            returnv.setUsername(new String(this.getUsername()));
        }
        if (this.getFinalVersion() != null) {
            returnv.setFinalVersion(new String(this.getFinalVersion()));
        }
        if (this.getParameters() != null) {
            returnv.setParameters((HashMap)this.getParameters().clone());
        }
        if (this.getTransactionMap() != null) {
            returnv.setTransactionMap((HashMap)this.getTransactionMap().clone());
        }
        if (this.getAbbr() != null) {
            returnv.setAbbr(new String(this.getAbbr()));
        }
        if (this.getHttpMethod() != null) {
            returnv.setHttpMethod(new String(this.getHttpMethod()));
        }
        if (this.getGetFeatureFilterMap() != null) {
            returnv.setGetFeatureFilterMap((HashMap)this.getGetFeatureFilterMap().clone());
        }
        return returnv;
    }

    public HashMap getNameSpaces() {
        return null;
    }

    public HashMap getSchemaLocations() {
        return null;
    }

    public void checkRequestURL() throws Exception {
        if (this.parameters == null) {
            throw new UnsupportedOperationException("No parameters found in url!");
        }
        String serviceType = null;
        if (this.containsParameter(SERVICE_TYPE) && ((serviceType = this.getParameter(SERVICE_TYPE)) == null || serviceType.equals(""))) {
            throw new UnsupportedOperationException("Empty serviceType parameter found in url!");
        }
        if (this.containsParameter(COMMAND)) {
            String command = this.getParameter(COMMAND);
            if (command == null || command.equals("")) {
                throw new UnsupportedOperationException("Empty command parameter found in url!");
            }
        } else {
            throw new UnsupportedOperationException("No command parameter found!");
        }
    }

    public WFS_Capabilities getCapabilities() {
        return null;
    }

    public void setCapabilities(WFS_Capabilities capabilities) {
    }

    public String getNameSpace(String param) {
        return null;
    }

    public String getNameSpacePrefix(String namespaceUrl) {
        return null;
    }

    public void setLayers(ArrayList layers) {
    }
}

