/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.arcgis;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nl.b3p.gis.arcgis.ArcGISInitializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArcGISConnector
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ArcGISConnector.class);
    private ArcGISInitializer arcGISInitializer;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            log.info((Object)"ArcObjects Jar bootstrap started.");
            this.bootstrapArcobjectsJar();
            log.info((Object)"ArcObjects Jar bootstrap successful.");
            this.arcGISInitializer = new ArcGISInitializer();
            this.arcGISInitializer.contextInitialized(sce);
        }
        catch (Exception e) {
            log.error((Object)"Error connecting to ArcObjects.", (Throwable)e);
        }
    }

    private void bootstrapArcobjectsJar() throws Exception {
        String arcObjectsHome = System.getenv("AGSENGINEJAVA");
        if (arcObjectsHome == null) {
            arcObjectsHome = System.getenv("AGSDESKTOPJAVA");
        }
        if (arcObjectsHome == null) {
            if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
                throw new Exception("You must have ArcGIS Engine Runtime or ArcGIS Desktop installed in order to execute this sample.\nInstall one of the products above, then re-run this sample.");
            }
            throw new Exception("You must have ArcGIS Engine Runtime installed in order to execute this sample.\nInstall one of the products above, then re-run this sample.");
        }
        String jarPath = arcObjectsHome + "java" + File.separator + "lib" + File.separator + "arcobjects.jar";
        File jarFile = new File(jarPath);
        if (!jarFile.exists()) {
            throw new Exception("The arcobjects.jar was not found in the following location: " + jarFile.getParent() + "\n" + "Verify that arcobjects.jar can be located in the specified folder." + "If not present, try uninstalling your ArcGIS software and reinstalling it.");
        }
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, jarFile.toURI().toURL());
        }
        catch (Throwable throwable) {
            throw new Exception("Could not add arcobjects.jar to system classloader", throwable);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            if (this.arcGISInitializer != null) {
                this.arcGISInitializer.contextDestroyed(sce);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error shutting down ArcObjects connection", (Throwable)e);
        }
    }
}

