/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import nl.b3p.gis.mapping.Attribute;
import nl.b3p.gis.mapping.FeatureType;
import nl.b3p.ogc.utils.SqlMetaDataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeatureSchemaFactory {
    private static final Log log = LogFactory.getLog(FeatureSchemaFactory.class);

    public static FeatureSchema createFeatureSchemaFromDbTable(String url, String user, String password, Driver driver, String table, String[] dontAddColumns) throws SQLException, Exception {
        DriverManager.registerDriver(driver);
        return FeatureSchemaFactory.createFeatureSchemaFromDbTable(DriverManager.getConnection(url, user, password), table, dontAddColumns);
    }

    public static FeatureSchema createFeatureSchemaFromDbTable(Connection conn, String table, String[] dontAddColumns) throws SQLException, Exception {
        FeatureSchema fs = new FeatureSchema();
        List tableNames = SqlMetaDataUtils.getTableAndViewNames(conn);
        DatabaseMetaData dbmd = conn.getMetaData();
        if (tableNames.contains(table)) {
            ResultSet rs = dbmd.getColumns(null, null, table, null);
            int i = 0;
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                boolean add = true;
                if (dontAddColumns != null) {
                    for (int d = 0; d < dontAddColumns.length && add; ++d) {
                        if (!dontAddColumns[d].equalsIgnoreCase(columnName)) continue;
                        add = false;
                    }
                }
                if (add) {
                    int dataType = rs.getInt("DATA_TYPE");
                    AttributeType at = SqlMetaDataUtils.getAttributeTypeFromSqlType(dataType);
                    if (at.equals(AttributeType.OBJECT)) {
                        if (dbmd.getDatabaseProductName().equalsIgnoreCase("PostgreSQL")) {
                            PreparedStatement statement = null;
                            statement = conn.prepareStatement("SELECT * FROM geometry_columns g WHERE g.f_table_name = '" + table + "';");
                            ResultSet rsgeom = statement.executeQuery();
                            if (rsgeom.next()) {
                                int epsgCode = rsgeom.getInt("srid");
                                CoordinateSystem cs = new CoordinateSystem("EPSG:" + epsgCode, epsgCode, null);
                                fs.setCoordinateSystem(cs);
                                String type = rsgeom.getString("type");
                                fs.addAttribute(columnName, AttributeType.GEOMETRY);
                            }
                            statement.close();
                        } else {
                            log.info((Object)("create geometry feature not supported for " + dbmd.getDatabaseProductName()));
                        }
                    } else {
                        fs.addAttribute(columnName, at);
                    }
                }
                ++i;
            }
        } else {
            log.error((Object)("Table " + table + " not found"));
            throw new Exception("Table " + table + " not found");
        }
        return fs;
    }

    public static FeatureSchema createFeatureSchemaFromMapping(FeatureType ft, int epsgCode) {
        if (ft == null || ft.getAttributeCount() == 0) {
            return null;
        }
        FeatureSchema fs = new FeatureSchema();
        CoordinateSystem cs = new CoordinateSystem("EPSG:" + epsgCode, epsgCode, null);
        fs.setCoordinateSystem(cs);
        for (int a = 0; a < ft.getAttributeCount(); ++a) {
            Attribute att = ft.getAttribute(a);
            AttributeType at = null;
            if (att.getType() == null) continue;
            at = AttributeType.toAttributeType((String)att.getType().toString());
            String columnName = att.getName();
            fs.addAttribute(columnName, at);
        }
        return fs;
    }
}

