/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCConstants;
import nl.b3p.ogc.utils.OgcWfsClient;
import nl.b3p.xml.wfs.WFS_Capabilities;
import nl.b3p.xml.wfs.v100.DescribeFeatureType;
import nl.b3p.xml.wfs.v100.GetFeature;
import nl.b3p.xml.wfs.v100.capabilities.Transaction;
import nl.b3p.xml.wfs.v100.transaction.Native;
import nl.b3p.xml.wfs.v100.transaction.TransactionTypeChoice;
import nl.b3p.xml.wfs.v100.transaction.TransactionTypeChoiceItem;
import nl.b3p.xml.wfs.v110.Delete;
import nl.b3p.xml.wfs.v110.GetCapabilities;
import nl.b3p.xml.wfs.v110.Insert;
import nl.b3p.xml.wfs.v110.Query;
import nl.b3p.xml.wfs.v110.Update;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OGCRequest
extends OGCCommunication
implements OGCConstants {
    protected static final Log log = LogFactory.getLog(OGCRequest.class);
    protected String httpMethod;
    protected String httpHost;
    protected WFS_Capabilities capabilities;
    protected HashMap parameters;
    protected HashMap transactionList = new HashMap();
    protected HashMap getFeatureFilterMap = new HashMap();
    protected HashMap getFeaturePropertyNameListMap = new HashMap();
    protected String abbr;
    protected ArrayList layers = new ArrayList();
    protected String username;
    protected String password;
    protected String finalVersion;
    protected String serviceProviderName;
    private String personalCode;
    public static final List NAMESPACES_NOT_IN_URL = Arrays.asList("http://www.opengis.net/wfs", "http://www.w3.org/2001/xmlschema-instance", "http://www.opengis.net/gml", "http://www.opengis.net/ogc", "http://www.opengis.net/ows");
    public static final HashMap scaleCalibrations = new HashMap();

    public OGCRequest() {
        this.addOpengisNamespaces();
        this.parameters = new HashMap();
    }

    public OGCRequest(String url) {
        this.addOpengisNamespaces();
        this.parameters = new HashMap();
        this.setUrl(url);
    }

    public static String removeNamespace(String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return "";
        }
        String[] tokens = tagName.split(":");
        if (tokens.length > 1) {
            return tokens[1];
        }
        return tokens[0];
    }

    public OGCRequest(Element rootElement, String url) throws ValidationException, Exception {
        this.addOpengisNamespaces();
        this.parameters = new HashMap();
        this.setUrl(url);
        this.findNameSpace(rootElement);
        this.setFinalVersion(rootElement.getAttribute("VERSION".toLowerCase()));
        String version = this.finalVersion;
        if (OGCRequest.removeNamespace(rootElement.getTagName()).equalsIgnoreCase("GetCapabilities")) {
            if (version.equalsIgnoreCase("1.0.0")) {
                Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v100.GetCapabilities.class);
                Object o = um.unmarshal((Node)rootElement);
                nl.b3p.xml.wfs.v100.GetCapabilities getCapabilities = (nl.b3p.xml.wfs.v100.GetCapabilities)o;
                this.setGetCapabilitiesV100(getCapabilities);
            } else {
                Unmarshaller um = new Unmarshaller(GetCapabilities.class);
                Object o = um.unmarshal((Node)rootElement);
                GetCapabilities getCapabilities = (GetCapabilities)o;
                this.setGetCapabilitiesV110(getCapabilities);
            }
        } else if (OGCRequest.removeNamespace(rootElement.getTagName()).equalsIgnoreCase("DescribeFeatureType")) {
            if (version.equalsIgnoreCase("1.0.0")) {
                Unmarshaller um = new Unmarshaller(DescribeFeatureType.class);
                Object o = um.unmarshal((Node)rootElement);
                DescribeFeatureType describeFeatureType = (DescribeFeatureType)o;
                this.setDescribeFeatureTypeV100(describeFeatureType);
            } else {
                Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v110.DescribeFeatureType.class);
                Object o = um.unmarshal((Node)rootElement);
                nl.b3p.xml.wfs.v110.DescribeFeatureType describeFeatureType = (nl.b3p.xml.wfs.v110.DescribeFeatureType)o;
                this.setDescribeFeatureTypeV110(describeFeatureType);
            }
        } else if (OGCRequest.removeNamespace(rootElement.getTagName()).equalsIgnoreCase("GetFeature")) {
            if (version.equalsIgnoreCase("1.0.0")) {
                Unmarshaller um = new Unmarshaller(GetFeature.class);
                Object o = um.unmarshal((Node)rootElement);
                GetFeature getFeature = (GetFeature)o;
                this.setGetFeatureV100(getFeature);
            } else {
                Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v110.GetFeature.class);
                Object o = um.unmarshal((Node)rootElement);
                nl.b3p.xml.wfs.v110.GetFeature getFeature = (nl.b3p.xml.wfs.v110.GetFeature)o;
                this.setGetFeatureV110(getFeature);
            }
        } else if (OGCRequest.removeNamespace(rootElement.getTagName()).equalsIgnoreCase("Transaction")) {
            if (version.equalsIgnoreCase("1.0.0")) {
                Unmarshaller um = new Unmarshaller(Transaction.class);
                Object o = um.unmarshal((Node)rootElement);
                nl.b3p.xml.wfs.v100.transaction.Transaction transaction = (nl.b3p.xml.wfs.v100.transaction.Transaction)o;
                this.setTransactionV100(transaction);
            } else {
                Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v110.Transaction.class);
                Object o = um.unmarshal((Node)rootElement);
                nl.b3p.xml.wfs.v110.Transaction transaction = (nl.b3p.xml.wfs.v110.Transaction)o;
                this.setTransactionV110(transaction);
            }
        } else {
            if (OGCRequest.removeNamespace(rootElement.getTagName()).equalsIgnoreCase("LockFeature")) {
                throw new UnsupportedOperationException("kaartenbalie doesn't suport LockFeature yet!");
            }
            if (OGCRequest.removeNamespace(rootElement.getTagName()).equalsIgnoreCase("GetFeatureWithLock")) {
                throw new UnsupportedOperationException("kaartenbalie doesn't suport GetFeatureWithLock yet!");
            }
            throw new UnsupportedOperationException("No supported WFS service found in request!");
        }
    }

    public final void setGetCapabilitiesV100(nl.b3p.xml.wfs.v100.GetCapabilities getCapabilities) {
        this.addOrReplaceParameter("VERSION", getCapabilities.getVersion());
        this.addOrReplaceParameter("SERVICE", getCapabilities.getService());
        this.addOrReplaceParameter("REQUEST", "GetCapabilities");
    }

    public final void setGetCapabilitiesV110(GetCapabilities getCapabilities) {
        this.addOrReplaceParameter("VERSION", this.finalVersion);
        this.addOrReplaceParameter("SERVICE", getCapabilities.getService());
        this.addOrReplaceParameter("REQUEST", "GetCapabilities");
    }

    public final void setDescribeFeatureTypeV100(DescribeFeatureType describeFeatureType) {
        this.addOrReplaceParameter("VERSION", describeFeatureType.getVersion());
        this.addOrReplaceParameter("SERVICE", describeFeatureType.getService());
        this.addOrReplaceParameter("REQUEST", "DescribeFeatureType");
        this.addOrReplaceParameter("OUTPUTFORMAT", describeFeatureType.getOutputFormat());
        String[] list = describeFeatureType.getTypeName();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                str.append(",");
            }
            str.append(list[i]);
        }
        this.addOrReplaceParameter("TYPENAME", str.toString());
    }

    public final void setDescribeFeatureTypeV110(nl.b3p.xml.wfs.v110.DescribeFeatureType describeFeatureType) {
        this.addOrReplaceParameter("VERSION", describeFeatureType.getVersion());
        this.addOrReplaceParameter("SERVICE", describeFeatureType.getService());
        this.addOrReplaceParameter("REQUEST", "DescribeFeatureType");
        this.addOrReplaceParameter("OUTPUTFORMAT", describeFeatureType.getOutputFormat());
        String[] list = describeFeatureType.getTypeName();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                str.append(",");
            }
            str.append(list[i]);
        }
        this.addOrReplaceParameter("TYPENAME", str.toString());
    }

    public final void setGetFeatureV100(GetFeature getFeature) throws Exception {
        nl.b3p.xml.wfs.v100.Query[] qlist;
        this.addOrReplaceParameter("VERSION", getFeature.getVersion());
        this.addOrReplaceParameter("SERVICE", getFeature.getService());
        this.addOrReplaceParameter("REQUEST", "GetFeature");
        this.addOrReplaceParameter("HANDLE", getFeature.getHandle());
        this.addOrReplaceParameter("OUTPUTFORMAT", getFeature.getOutputFormat());
        if (getFeature.getMaxFeatures() > 0) {
            this.addOrReplaceParameter("MAXFEATURES", "" + getFeature.getMaxFeatures());
        }
        if ((qlist = getFeature.getQuery()).length > 0) {
            for (int i = 0; i < qlist.length; ++i) {
                String typename = qlist[i].getTypeName();
                String filter = null;
                if (qlist[i].getFilter() != null) {
                    StringWriter sw = new StringWriter();
                    Marshaller m = new Marshaller((Writer)sw);
                    m.marshal((Object)qlist[i].getFilter());
                    filter = sw.toString();
                }
                this.addGetFeatureFilterMap(typename, filter);
                StringBuffer propertyNameList = new StringBuffer();
                for (int j = 0; j < qlist[i].getPropertyNameCount(); ++j) {
                    propertyNameList.append(qlist[i].getPropertyName(j).getContent());
                    if (j + 1 >= qlist[i].getPropertyNameCount()) continue;
                    propertyNameList.append(',');
                }
                this.addGetFeaturePropertyNameListMap(typename, propertyNameList.length() > 0 ? propertyNameList.toString() : null);
            }
        }
    }

    public final void setGetFeatureV110(nl.b3p.xml.wfs.v110.GetFeature getFeature) throws Exception {
        this.addOrReplaceParameter("VERSION", getFeature.getVersion());
        this.addOrReplaceParameter("SERVICE", getFeature.getService());
        this.addOrReplaceParameter("RESULTTYPE", getFeature.getResultType().toString());
        this.addOrReplaceParameter("REQUEST", "GetFeature");
        this.addOrReplaceParameter("HANDLE", getFeature.getHandle());
        this.addOrReplaceParameter("OUTPUTFORMAT", getFeature.getOutputFormat());
        if (getFeature.getMaxFeatures() > 0) {
            this.addOrReplaceParameter("MAXFEATURES", "" + getFeature.getMaxFeatures());
        }
        this.addOrReplaceParameter("TRAVERSEXLINKDEPTH", getFeature.getTraverseXlinkDepth());
        this.addOrReplaceParameter("TRAVERSEXLINKEXPIRY", "" + getFeature.getTraverseXlinkExpiry());
        Query[] qlist = getFeature.getQuery();
        if (qlist.length > 0) {
            for (int i = 0; i < qlist.length; ++i) {
                String typename = qlist[i].getTypeName();
                String filter = null;
                if (qlist[i].getFilter() != null) {
                    StringWriter sw = new StringWriter();
                    Marshaller m = new Marshaller((Writer)sw);
                    m.marshal((Object)qlist[i].getFilter());
                    filter = sw.toString();
                }
                this.addGetFeatureFilterMap(typename, filter);
                StringBuffer propertyNameList = new StringBuffer();
                for (int j = 0; j < qlist[i].getQueryTypeChoiceCount(); ++j) {
                    for (int k = 0; k < qlist[i].getQueryTypeChoice(j).getQueryTypeChoiceItemCount(); ++k) {
                        String propertyName = qlist[i].getQueryTypeChoice(j).getQueryTypeChoiceItem(k).getPropertyName();
                        if (propertyNameList.length() > 0) {
                            propertyNameList.append(',');
                        }
                        if (propertyName == null) continue;
                        propertyNameList.append(propertyName);
                    }
                }
                this.addGetFeaturePropertyNameListMap(typename, propertyNameList.length() > 0 ? propertyNameList.toString() : null);
            }
        }
    }

    public final void setTransactionV100(nl.b3p.xml.wfs.v100.transaction.Transaction transaction) throws Exception {
        this.addOrReplaceParameter("VERSION", transaction.getVersion());
        this.addOrReplaceParameter("SERVICE", transaction.getService());
        this.addOrReplaceParameter("REQUEST", "Transaction");
        this.addOrReplaceParameter("HANDLE", transaction.getHandle());
        this.addOrReplaceParameter("LOCKID", transaction.getLockId());
        if (transaction.getReleaseAction() != null) {
            StringWriter sw = new StringWriter();
            Marshaller m = new Marshaller((Writer)sw);
            m.marshal((Object)transaction.getReleaseAction());
            this.addOrReplaceParameter("RELEASEACTION", sw.toString());
        }
        for (TransactionTypeChoice transactionTypeChoice : transaction.getTransactionTypeChoice()) {
            int count = transactionTypeChoice.getTransactionTypeChoiceItemCount();
            for (int x = 0; x < count; ++x) {
                LayerSummary map;
                String layer;
                TransactionTypeChoiceItem transactionTypeChoiceItem = transactionTypeChoice.getTransactionTypeChoiceItem(x);
                if (transactionTypeChoiceItem.getDelete() != null) {
                    nl.b3p.xml.wfs.v100.transaction.Delete delete = transactionTypeChoiceItem.getDelete();
                    layer = delete.getTypeName();
                    this.getLayers().add(layer);
                    map = this.splitLayerInParts(layer);
                    this.addElementToTransactionList(delete, map.getSpAbbr());
                    continue;
                }
                if (transactionTypeChoiceItem.getInsert() != null) {
                    nl.b3p.xml.wfs.v100.transaction.Insert insert = transactionTypeChoiceItem.getInsert();
                    StringWriter sw = new StringWriter();
                    Marshaller m = new Marshaller((Writer)sw);
                    m.marshal((Object)insert);
                    String insertString = sw.toString();
                    String[] layer2 = insertString.split("<");
                    this.getLayers().add(layer2[0]);
                    LayerSummary map2 = this.splitLayerInParts(layer2[0]);
                    this.addElementToTransactionList(insert, map2.getSpAbbr());
                    continue;
                }
                if (transactionTypeChoiceItem.getUpdate() != null) {
                    nl.b3p.xml.wfs.v100.transaction.Update update = transactionTypeChoiceItem.getUpdate();
                    layer = update.getTypeName();
                    this.getLayers().add(layer);
                    map = this.splitLayerInParts(layer);
                    this.addElementToTransactionList(update, map.getSpAbbr());
                    continue;
                }
                if (transactionTypeChoiceItem.getNative() == null) continue;
                Native native_ = transactionTypeChoiceItem.getNative();
            }
        }
    }

    public final void setTransactionV110(nl.b3p.xml.wfs.v110.Transaction transaction) throws Exception {
        this.addOrReplaceParameter("VERSION", transaction.getVersion());
        this.addOrReplaceParameter("SERVICE", transaction.getService());
        this.addOrReplaceParameter("REQUEST", "Transaction");
        this.addOrReplaceParameter("HANDLE", transaction.getHandle());
        this.addOrReplaceParameter("LOCKID", transaction.getLockId());
        if (transaction.getReleaseAction() != null) {
            StringWriter sw = new StringWriter();
            Marshaller m = new Marshaller((Writer)sw);
            m.marshal((Object)transaction.getReleaseAction());
            this.addOrReplaceParameter("RELEASEACTION", sw.toString());
        }
        for (nl.b3p.xml.wfs.v110.TransactionTypeChoice transactionTypeChoice : transaction.getTransactionTypeChoice()) {
            int count = transactionTypeChoice.getTransactionTypeChoiceItemCount();
            for (int x = 0; x < count; ++x) {
                LayerSummary map;
                String layer;
                nl.b3p.xml.wfs.v110.TransactionTypeChoiceItem transactionTypeChoiceItem = transactionTypeChoice.getTransactionTypeChoiceItem(x);
                if (transactionTypeChoiceItem.getDelete() != null) {
                    Delete delete = transactionTypeChoiceItem.getDelete();
                    layer = delete.getTypeName();
                    this.getLayers().add(layer);
                    map = this.splitLayerInParts(layer);
                    this.addElementToTransactionList(delete, map.getSpAbbr());
                    continue;
                }
                if (transactionTypeChoiceItem.getInsert() != null) {
                    Insert insert = transactionTypeChoiceItem.getInsert();
                    StringWriter sw = new StringWriter();
                    Marshaller m = new Marshaller((Writer)sw);
                    m.marshal((Object)insert);
                    String insertString = sw.toString();
                    String[] layer2 = insertString.split("<");
                    this.getLayers().add(layer2[0]);
                    LayerSummary map2 = this.splitLayerInParts(layer2[0]);
                    this.addElementToTransactionList(insert, map2.getSpAbbr());
                    continue;
                }
                if (transactionTypeChoiceItem.getUpdate() != null) {
                    Update update = transactionTypeChoiceItem.getUpdate();
                    layer = update.getTypeName();
                    this.getLayers().add(layer);
                    map = this.splitLayerInParts(layer);
                    this.addElementToTransactionList(update, map.getSpAbbr());
                    continue;
                }
                if (transactionTypeChoiceItem.getNative() == null) continue;
                nl.b3p.xml.wfs.v110.Native native_ = transactionTypeChoiceItem.getNative();
            }
        }
    }

    public void addElementToTransactionList(Object element, String spAbbr) {
        if (!this.transactionList.containsKey(spAbbr)) {
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.add(element);
            this.transactionList.put(spAbbr, temp);
        } else {
            List temp = (List)this.transactionList.get(spAbbr);
            temp.add(element);
        }
    }

    public HashMap getTransactionMap() {
        return this.transactionList;
    }

    public void setTransactionMap(HashMap transactionList) {
        this.transactionList = transactionList;
    }

    public List getTransactionElementList(String spAbbr) {
        return (List)this.transactionList.get(spAbbr);
    }

    public void setTransactionElementList(List elements, String spAbbr) {
        this.transactionList.put(spAbbr, elements);
    }

    public String[] getTransactionSpList() {
        Set spSet = this.transactionList.keySet();
        int size = spSet.size();
        String[] spArray = new String[size];
        Iterator it = spSet.iterator();
        for (int i = 0; i < size; ++i) {
            spArray[i] = it.next().toString();
        }
        return spArray;
    }

    public void setAbbr(String abbr) {
        this.abbr = abbr;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public ArrayList getLayers() {
        return this.layers;
    }

    public HashMap getGetFeatureFilterMap() {
        return this.getFeatureFilterMap;
    }

    public void setGetFeatureFilterMap(HashMap getFeatureFilterMap) {
        this.getFeatureFilterMap = getFeatureFilterMap;
    }

    public void addGetFeatureFilterMap(String key, Object value) {
        this.getFeatureFilterMap.put(this.stripNs(key), value);
    }

    public String getGetFeatureFilter(String key) {
        Object o = this.getFeatureFilterMap.get(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public HashMap getGetFeaturePropertyNameListMap() {
        return this.getFeaturePropertyNameListMap;
    }

    public void setGetFeaturePropertyNameListMap(HashMap getFeaturePropertyNameListMap) {
        this.getFeaturePropertyNameListMap = getFeaturePropertyNameListMap;
    }

    public void addGetFeaturePropertyNameListMap(String key, Object value) {
        this.getFeaturePropertyNameListMap.put(this.stripNs(key), value);
    }

    public String getGetFeaturePropertyNameList(String key) {
        Object o = this.getFeaturePropertyNameListMap.get(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public final void setUrl(String url) {
        if (url == null) {
            return;
        }
        String[] tokens = url.split("\\?|&");
        if (tokens.length > 0) {
            String[] pi = OGCRequest.findServiceProviderNameAndPersonalCode(tokens[0]);
            this.serviceProviderName = pi[0];
            this.personalCode = pi[1];
            this.setHttpHost(this.fixHttpHost(tokens[0]));
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].contains("=")) continue;
            String[] keyValuePair = tokens[i].split("=");
            if (keyValuePair[0].equalsIgnoreCase("NAMESPACE")) {
                if (!tokens[i].contains("(") || !tokens[i].contains(")")) continue;
                String namespacestring = tokens[i].substring(tokens[i].indexOf("(") + 1, tokens[i].indexOf(")"));
                String[] namespaces = namespacestring.split(",");
                for (int b = 0; b < namespaces.length; ++b) {
                    if (!namespaces[b].contains("=")) continue;
                    String[] prefixUriPair = namespaces[b].split("=");
                    if (prefixUriPair.length == 2) {
                        this.addOrReplaceNameSpace(prefixUriPair[0], prefixUriPair[1]);
                        continue;
                    }
                    if (!namespaces[b].startsWith("=")) continue;
                    this.addOrReplaceNameSpace("", prefixUriPair[1]);
                }
                continue;
            }
            if (keyValuePair.length > 2) {
                String value = "";
                for (int b = 1; b < keyValuePair.length; ++b) {
                    if (b != 1) {
                        value = value + "=";
                    }
                    value = value + keyValuePair[b];
                }
                this.addOrReplaceParameter(keyValuePair[0], value);
                continue;
            }
            if (keyValuePair.length == 2) {
                this.addOrReplaceParameter(keyValuePair[0], keyValuePair[1]);
                continue;
            }
            this.addOrReplaceParameter(keyValuePair[0], null);
        }
        this.setFinalVersion(this.getParameter("VERSION"));
    }

    public String getUrl() {
        return this.getUrl(this.httpHost);
    }

    public String getUrl(String host) {
        StringBuffer sb = new StringBuffer();
        sb.append(host);
        Set keys = this.parameters.keySet();
        for (Object o : keys) {
            if (o == null || this.parameters.get(o) == null) continue;
            sb.append(o);
            sb.append("=");
            try {
                String s = (String)this.parameters.get(o);
                s = URLEncoder.encode(s, "utf-8");
                sb.append(s);
            }
            catch (UnsupportedEncodingException nee) {
                log.error((Object)"Fout bij encoding voor het opbouwen van url.", (Throwable)nee);
            }
            sb.append("&");
        }
        if (this.getNameSpaces() != null && this.getNameSpaces().size() > 0) {
            StringBuffer nsp = new StringBuffer("namespace=");
            Set mapEntries = this.getNameSpaces().entrySet();
            Iterator<Object> it = mapEntries.iterator();
            while (it.hasNext()) {
                Map.Entry me;
                if (nsp.length() > 11) {
                    nsp.append(",");
                }
                if (NAMESPACES_NOT_IN_URL.contains((me = (Map.Entry)it.next()).getValue().toString().toLowerCase())) continue;
                nsp.append("xmlns(");
                nsp.append(me.getKey());
                nsp.append("=");
                nsp.append(me.getValue());
                nsp.append(")");
            }
            if (nsp.length() > 20) {
                sb.append(nsp.toString());
                sb.append("&");
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public String getXMLBody() throws Exception {
        return OgcWfsClient.getRequestBody(this);
    }

    public String getUrlWithNonOGCparams() {
        OGCRequest ogcu = (OGCRequest)this.clone();
        ogcu.removeAllWMSParameters();
        ogcu.removeAllWFSParameters();
        ogcu.setNameSpaces(null);
        return ogcu.getUrl();
    }

    public String removeParameter(String param) {
        if (param == null) {
            return null;
        }
        Object o = this.parameters.remove(param = param.toUpperCase());
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    public final String getParameter(String param) {
        if (param == null) {
            return null;
        }
        Object o = this.parameters.get(param = param.toUpperCase());
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    public final boolean containsParameter(String param) {
        if (param == null) {
            return false;
        }
        param = param.toUpperCase();
        return this.parameters.containsKey(param);
    }

    public HashMap getNonOGCParameters() {
        OGCRequest o = (OGCRequest)this.clone();
        o.removeAllWFSParameters();
        o.removeAllWMSParameters();
        return o.getParameters();
    }

    public String addOrReplaceParameter(String param, String v) {
        String value;
        try {
            value = v != null ? URLDecoder.decode(v, "UTF-8") : v;
        }
        catch (UnsupportedEncodingException ex) {
            value = v;
            log.error((Object)"Error decoding value. Try with the original value", (Throwable)ex);
        }
        if (param == null) {
            return null;
        }
        param = param.toUpperCase();
        Object o = this.parameters.get(param);
        if (value != null) {
            value = value.trim();
        }
        if ("TYPENAME".equals(param)) {
            value = this.fixNsPrefix(value);
        }
        this.parameters.put(param, value);
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    public int addOrReplaceParameters(String params) {
        if (params == null) {
            return 0;
        }
        String[] tokens = params.split("&");
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].contains("=")) continue;
            String[] keyValuePair = tokens[i].split("=");
            if (keyValuePair.length > 2) {
                String value = "";
                for (int b = 1; b < keyValuePair.length; ++b) {
                    if (b != 1) {
                        value = value + "=";
                    }
                    value = value + keyValuePair[b];
                }
                this.addOrReplaceParameter(keyValuePair[0], value);
                continue;
            }
            if (keyValuePair.length == 2) {
                this.addOrReplaceParameter(keyValuePair[0], keyValuePair[1]);
                continue;
            }
            this.addOrReplaceParameter(keyValuePair[0], null);
        }
        return tokens.length;
    }

    public void removeAllWMSParameters() {
        this.removeParameter("BBOX");
        this.removeParameter("TRANSPARENT");
        this.removeParameter("FORMAT");
        this.removeParameter("INFO_FORMAT");
        this.removeParameter("LAYERS");
        this.removeParameter("QUERY_LAYERS");
        this.removeParameter("WIDTH");
        this.removeParameter("HEIGHT");
        this.removeParameter("FEATURECOUNT");
        this.removeParameter("X");
        this.removeParameter("Y");
        this.removeParameter("VERSION");
        this.removeParameter("REQUEST");
        this.removeParameter("STYLES");
        this.removeParameter("SRS");
        this.removeParameter("BGCOLOR");
        this.removeParameter("EXCEPTIONS");
        this.removeParameter("TIME");
        this.removeParameter("ELEVATION");
        this.removeParameter("SLD");
        this.removeParameter("WFS");
        this.removeParameter("SERVICE");
        this.removeParameter("LAYER");
    }

    public void removeAllWFSParameters() {
        this.removeAllWMSParameters();
        this.removeParameter("OUTPUTFORMAT");
        this.removeParameter("TYPENAME");
        this.removeParameter("RESULTTYPE");
        this.removeParameter("PROPERTYNAME");
        this.removeParameter("FEATUREVERSION");
        this.removeParameter("MAXFEATURES");
        this.removeParameter("EXPIRY");
        this.removeParameter("SRSNAME");
        this.removeParameter("FEATUREID");
        this.removeParameter("FILTER");
        this.removeParameter("SORTBY");
        this.removeParameter("TRAVERSEXLINKDEPTH");
        this.removeParameter("TRAVERSEXLINKEXPIRY");
        this.removeParameter("PROPTRAVXLINKEXPIRY");
        this.removeParameter("PROPTRAVXLINKDEPTH");
        this.removeParameter("GMLOBJECTID");
        this.removeParameter("RESULTTYPE");
        this.removeParameter("BBOX");
        this.removeParameter("INPUTFORMAT");
        this.removeParameter("HANDLE");
        this.removeParameter("LOCKID");
        this.removeParameter("RELEASEACTION");
    }

    public String toString() {
        return this.getUrl();
    }

    public String[] getParametersArray() {
        if (this.parameters == null) {
            return null;
        }
        String[] returnvalue = new String[this.parameters.size()];
        Set keys = this.parameters.keySet();
        Iterator it = keys.iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)this.parameters.get(key);
            if (value == null) {
                value = "";
            }
            returnvalue[i] = key + "=" + value;
            ++i;
        }
        return returnvalue;
    }

    public Object clone() {
        OGCRequest returnv = new OGCRequest();
        if (this.getHttpHost() != null) {
            returnv.setHttpHost(new String(this.getHttpHost()));
        }
        if (this.getServiceProviderName() != null) {
            returnv.setServiceProviderName(new String(this.getServiceProviderName()));
        }
        if (this.getPersonalCode() != null) {
            returnv.setPersonalCode(new String(this.getPersonalCode()));
        }
        if (this.getPassword() != null) {
            returnv.setPassword(new String(this.getPassword()));
        }
        if (this.getUsername() != null) {
            returnv.setUsername(new String(this.getUsername()));
        }
        if (this.getFinalVersion() != null) {
            returnv.setFinalVersion(new String(this.getFinalVersion()));
        }
        if (this.getParameters() != null) {
            returnv.setParameters((HashMap)this.getParameters().clone());
        }
        if (this.getNameSpaces() != null) {
            returnv.setNameSpaces((HashMap)this.getNameSpaces().clone());
        }
        if (this.getSchemaLocations() != null) {
            returnv.setSchemaLocations((HashMap)this.getSchemaLocations().clone());
        }
        if (this.getTransactionMap() != null) {
            returnv.setTransactionMap((HashMap)this.getTransactionMap().clone());
        }
        if (this.getAbbr() != null) {
            returnv.setAbbr(new String(this.getAbbr()));
        }
        if (this.getHttpMethod() != null) {
            returnv.setHttpMethod(new String(this.getHttpMethod()));
        }
        if (this.getCapabilities() != null) {
            returnv.setCapabilities(this.getCapabilities());
        }
        if (this.getGetFeatureFilterMap() != null) {
            returnv.setGetFeatureFilterMap((HashMap)this.getGetFeatureFilterMap().clone());
        }
        if (this.getGetFeaturePropertyNameListMap() != null) {
            returnv.setGetFeaturePropertyNameListMap((HashMap)this.getGetFeaturePropertyNameListMap().clone());
        }
        if (this.getLayers() != null) {
            returnv.setLayers((ArrayList)this.getLayers().clone());
        }
        if (this.getNameSpaces() != null) {
            returnv.setNameSpaces((HashMap)this.getNameSpaces().clone());
        }
        if (this.getSchemaLocations() != null) {
            returnv.setSchemaLocations((HashMap)this.getSchemaLocations().clone());
        }
        return returnv;
    }

    public String getHttpHost() {
        return this.httpHost;
    }

    public void setHttpHost(String host) {
        this.httpHost = host;
    }

    public String fixHttpHost(String httpHost) {
        if (httpHost.indexOf(63) < 0) {
            return httpHost + "?";
        }
        if (httpHost.indexOf(63) == httpHost.length() - 1) {
            return httpHost;
        }
        if (httpHost.lastIndexOf(38) == httpHost.length() - 1) {
            return httpHost;
        }
        return httpHost + "&";
    }

    public static String[] findServiceProviderNameAndPersonalCode(String httpHost) {
        String[] parts;
        String[] spPc = new String[]{null, null};
        if (httpHost == null) {
            return spPc;
        }
        String realHost = httpHost;
        String[] tmp = httpHost.split("\\?|&");
        if (tmp.length > 0) {
            realHost = tmp[0];
        }
        if ((parts = realHost.split("/services/")).length > 1) {
            if ((parts = parts[1].split("/")).length > 1) {
                spPc[0] = parts[0];
                spPc[1] = parts[1];
            } else if (parts.length == 1) {
                spPc[1] = parts[0];
            }
        }
        return spPc;
    }

    public static String findServiceProviderName(String httpHost) {
        return OGCRequest.findServiceProviderNameAndPersonalCode(httpHost)[0];
    }

    public static String findPersonalCode(String httpHost) {
        return OGCRequest.findServiceProviderNameAndPersonalCode(httpHost)[1];
    }

    public void setServiceProviderName(String sp) {
        this.serviceProviderName = sp;
    }

    public String getServiceProviderName() {
        return this.serviceProviderName;
    }

    public String getPersonalCode() {
        return this.personalCode;
    }

    public void setPersonalCode(String personalCode) {
        this.personalCode = personalCode;
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    protected HashMap getParameters() {
        return this.parameters;
    }

    protected void setParameters(HashMap parameters) {
        this.parameters = parameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkRequestURL() throws Exception {
        if (this.parameters == null) {
            throw new UnsupportedOperationException("No parameters found in url!");
        }
        String service = null;
        if (this.containsParameter("SERVICE")) {
            service = this.getParameter("SERVICE");
            if (service == null || service.equals("")) {
                throw new UnsupportedOperationException("Empty service parameter found in url!");
            }
            if (service.equalsIgnoreCase("METADATA")) {
                this.checkRequestURL(REQUIRED_PARAMS_METADATA, service);
                return;
            }
            if (service.equalsIgnoreCase("PROXY")) {
                this.checkRequestURL(REQUIRED_PARAMS_PROXY, service);
                return;
            }
        }
        if (!this.containsParameter("REQUEST")) throw new UnsupportedOperationException("No request parameter found!");
        String request = this.getParameter("REQUEST");
        if (request == null || request.equals("")) {
            throw new UnsupportedOperationException("Empty request parameter found in url!");
        }
        List requiredParams = null;
        if (request.equals("GetCapabilities") && ("WMS".equalsIgnoreCase(service) || service == null)) {
            requiredParams = REQUIRED_PARAMS_GetCapabilities;
        } else if (request.equals("GetMap")) {
            requiredParams = PARAMS_GetMap;
        } else if (request.equals("GetFeatureInfo")) {
            requiredParams = PARAMS_GetFeatureInfo;
        } else if (request.equals("GetLegendGraphic")) {
            requiredParams = PARAMS_GetLegendGraphic;
        } else if (request.equals("DescribeLayer")) {
            requiredParams = PARAMS_DescribeLayer;
        } else if (service.equalsIgnoreCase("WFS") && request.equals("GetCapabilities")) {
            requiredParams = WFS_REQUIRED_PARAMS_GetCapabilities;
        } else if (request.equals("GetFeature")) {
            requiredParams = WFS_REQUIRED_PARAMS_GetFeature;
        } else if (request.equals("DescribeFeatureType")) {
            requiredParams = WFS_REQUIRED_PARAMS_DescribeFeatureType;
        } else {
            if (!request.equals("Transaction")) throw new UnsupportedOperationException("Request '" + request + "' not supported! Use GetCapabilities request to " + "get the list of supported functions.");
            requiredParams = WFS_REQUIRED_PARAMS_Transaction;
        }
        this.checkRequestURL(requiredParams, request);
    }

    protected void checkRequestURL(List requiredParams, String request) throws Exception {
        StringBuffer reason = new StringBuffer();
        if (this.parameters == null || requiredParams == null || this.parameters.isEmpty() && !requiredParams.isEmpty()) {
            reason.append("Not all parameters for request '");
            reason.append(request);
            reason.append("' are available.");
            throw new UnsupportedOperationException(reason.toString());
        }
        for (String parameter : requiredParams) {
            if (this.parameters.containsKey(parameter)) continue;
            reason.append("Not all parameters for request '");
            reason.append(request);
            reason.append("' are available, missing parameter: ");
            reason.append(parameter);
            reason.append(".");
            throw new UnsupportedOperationException(reason.toString());
        }
        for (String parameter : requiredParams) {
            if (parameter.equalsIgnoreCase("STYLES") || this.getParameter(parameter) != null) continue;
            reason.append("Value for parameter ");
            reason.append(parameter);
            reason.append(" is missing.");
            throw new UnsupportedOperationException(reason.toString());
        }
    }

    public WFS_Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(WFS_Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public final void setFinalVersion(String clientVersion) {
        if (clientVersion == null || clientVersion.equals("") || clientVersion.equals("unspecified")) {
            this.finalVersion = "unspecified";
        } else if (OGCConstants.SUPPORTED_WFS_VERSIONS.contains(clientVersion)) {
            this.finalVersion = clientVersion;
        } else {
            String[] versionArray = clientVersion.split("\\.");
            String newVersion = "";
            for (int i = 0; i < versionArray.length; ++i) {
                newVersion = newVersion + versionArray[i];
            }
            if (newVersion == null || newVersion.equals("")) {
                throw new UnsupportedOperationException("The version number was incorrect!");
            }
            int version = Integer.parseInt(newVersion);
            List suportedVersions = OGCConstants.SUPPORTED_WFS_VERSIONS;
            int versionSize = suportedVersions.size();
            int[] suportedVersionsInt = new int[versionSize];
            for (int x = 0; x < versionSize; ++x) {
                String[] suportedArray = suportedVersions.get(x).toString().split("\\.");
                String tempversion = "";
                for (int y = 0; y < suportedArray.length; ++y) {
                    tempversion = tempversion + suportedArray[y];
                }
                suportedVersionsInt[x] = Integer.parseInt(tempversion);
            }
            int lowestVersion = suportedVersionsInt[0];
            for (int z = 0; z < suportedVersionsInt.length; ++z) {
                if (lowestVersion <= suportedVersionsInt[z]) continue;
                lowestVersion = suportedVersionsInt[z];
            }
            if (version > lowestVersion) {
                for (int b = 0; b < suportedVersionsInt.length; ++b) {
                    if (version <= suportedVersionsInt[b] || lowestVersion >= suportedVersionsInt[b]) continue;
                    lowestVersion = suportedVersionsInt[b];
                }
                if (lowestVersion == 110) {
                    this.finalVersion = "1.1.0";
                } else if (lowestVersion == 100) {
                    this.finalVersion = "1.0.0";
                }
            } else if (version < lowestVersion) {
                if (lowestVersion == 110) {
                    this.finalVersion = "1.1.0";
                } else if (lowestVersion == 100) {
                    this.finalVersion = "1.0.0";
                }
            }
        }
    }

    public double calcScale() {
        String projection = (String)this.parameters.get("SRS");
        if (projection == null) {
            return 0.0;
        }
        Double scaleCalibration = (Double)scaleCalibrations.get(projection);
        if (scaleCalibration != null) {
            return this.calcScale(scaleCalibration);
        }
        return 0.0;
    }

    public double calcScale(double scaleCalibration) {
        double dvm = 0.0;
        try {
            String width = (String)this.parameters.get("WIDTH");
            String height = (String)this.parameters.get("HEIGHT");
            double w = Double.parseDouble(width);
            double h = Double.parseDouble(height);
            double d = Math.sqrt(w * w + h * h);
            dvm = d / scaleCalibration;
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)"Fout omrekenen schaal: ", (Throwable)nfe);
            return 0.0;
        }
        if (dvm == 0.0) {
            return 0.0;
        }
        String bbox = (String)this.parameters.get("BBOX");
        if (bbox == null) {
            return 0.0;
        }
        String[] bboxa = bbox.split(",");
        if (bboxa.length != 4) {
            return 0.0;
        }
        double dkm = 0.0;
        try {
            String minx = bboxa[0];
            String maxx = bboxa[2];
            String miny = bboxa[1];
            String maxy = bboxa[3];
            double ix = Double.parseDouble(minx);
            double ax = Double.parseDouble(maxx);
            double iy = Double.parseDouble(miny);
            double ay = Double.parseDouble(maxy);
            dkm = Math.sqrt((ax - ix) * (ax - ix) + (ay - iy) * (ay - iy));
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)"Fout omrekenen schaal: ", (Throwable)nfe);
            return 0.0;
        }
        return dkm / dvm;
    }

    public String getFinalVersion() {
        return this.finalVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLayers(ArrayList layers) {
        this.layers = layers;
    }

    static {
        scaleCalibrations.put("EPSG:28992", new Double(3272.0));
        scaleCalibrations.put("EPSG:4326", new Double(2.8447986E8));
    }
}

