/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.sld;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.commons.xml.DocumentHelper;
import nl.b3p.ogc.sld.SldLayerFeatureConstraints;
import nl.b3p.ogc.sld.SldNamedLayer;
import nl.b3p.ogc.sld.SldNamedStyle;
import nl.b3p.ogc.sld.SldNode;
import nl.b3p.ogc.sld.SldUserStyle;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.Style;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SldWriter {
    private static final Log log = LogFactory.getLog(SldWriter.class);
    private String version = "1.1.0";
    private String encoding = "UTF-8";
    private List<SldNamedLayer> namedlayers = null;

    public SldWriter() {
    }

    public SldWriter(List<SldNamedLayer> namedlayers) {
        this.namedlayers = namedlayers;
    }

    public SldWriter(String version) {
        this.version = version;
    }

    public SldWriter(List<SldNamedLayer> namedlayers, String version) {
        this(version);
        this.namedlayers = namedlayers;
    }

    public void parseDocument(Document doc) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.setNameSpaceContext(xpath);
        String expr1 = "/sld:StyledLayerDescriptor/@version";
        this.version = (String)xpath.evaluate(expr1, doc, XPathConstants.STRING);
        String expr = "/sld:StyledLayerDescriptor/sld:NamedLayer";
        NodeList nodeSet = (NodeList)xpath.evaluate(expr, doc, XPathConstants.NODESET);
        ArrayList<SldNamedLayer> namedLayers = new ArrayList<SldNamedLayer>();
        for (int i = 0; i < nodeSet.getLength(); ++i) {
            Node node = nodeSet.item(i);
            SldNamedLayer sldNamedLayer = new SldNamedLayer(node);
            namedLayers.add(sldNamedLayer);
        }
        this.namedlayers = namedLayers;
    }

    public void parseByUrl(String url, B3PCredentials credentials) throws Exception {
        Document doc = this.getDocument(url, credentials);
        this.parseDocument(doc);
    }

    public void parseByUrl(String url) throws Exception {
        this.parseByUrl(url, null);
    }

    public void parseString(String sld, String charSet) throws Exception {
        if (charSet == null) {
            charSet = this.encoding;
        }
        Document doc = SldWriter.getDocument(sld, charSet);
        this.parseDocument(doc);
    }

    public List<SldUserStyle> getUserStyles(String layerName) throws Exception {
        if (this.namedlayers == null) {
            return null;
        }
        ArrayList<SldUserStyle> userStyles = new ArrayList<SldUserStyle>();
        for (SldNamedLayer nl : this.namedlayers) {
            String name = nl.getName();
            if (!name.equalsIgnoreCase(layerName)) continue;
            userStyles.addAll(nl.getUserStyles());
        }
        return userStyles;
    }

    public List<SldNamedLayer> getNamedLayers(String layerName) throws Exception {
        if (this.namedlayers == null) {
            return null;
        }
        ArrayList<SldNamedLayer> namedLayers = new ArrayList<SldNamedLayer>();
        for (SldNamedLayer nl : this.namedlayers) {
            String name = nl.getName();
            if (!name.equalsIgnoreCase(layerName)) continue;
            namedLayers.add(nl);
        }
        return namedLayers;
    }

    public void addSldStylesSet(Layer layer) throws Exception {
        List<SldNamedLayer> namedLayers = this.getNamedLayers(layer.getName());
        if (namedLayers == null) {
            return;
        }
        HashSet<Style> styles = new HashSet<Style>();
        for (SldNamedLayer namedLayer : namedLayers) {
            List<SldNode> stylesAndConstraints = namedLayer.getStyles();
            for (SldNode sldStyle : stylesAndConstraints) {
                SldLayerFeatureConstraints constraints;
                Style style = new Style();
                style.setLayer(layer);
                if (layer.getStyles() == null) {
                    layer.setStyles(new HashSet<Style>());
                }
                String newStyleName = this.getUniqueStyleName(layer.getStyles(), sldStyle.getName());
                style.setName(newStyleName);
                if (style.getName() == null || style.getName().length() == 0) {
                    style.setName(layer.getName() + "_SLD");
                }
                style.setTitle(sldStyle.getName());
                style.setSldPart(sldStyle.getSldPart());
                if (sldStyle instanceof SldNamedStyle && (constraints = ((SldNamedStyle)sldStyle).getFeatureConstraints()) != null) {
                    style.setSldConstraints(constraints.getSldPart());
                }
                styles.add(style);
            }
        }
        if (layer.getStyles() != null && !styles.isEmpty()) {
            layer.getStyles().addAll(styles);
        }
    }

    private String getUniqueStyleName(Set<Style> styles, String name) throws Exception {
        return this.getUniqueStyleName(styles, name, null);
    }

    private String getUniqueStyleName(Set<Style> styles, String name, Integer tries) throws Exception {
        if (styles == null || name == null) {
            return null;
        }
        if (tries != null && tries == 10) {
            throw new Exception("Can't create unique name for style");
        }
        String newName = name;
        if (tries != null) {
            newName = newName + tries;
        }
        Iterator<Style> it = styles.iterator();
        boolean unique = true;
        while (it.hasNext() && unique) {
            Style s = it.next();
            if (!s.getName().equals(newName)) continue;
            unique = false;
        }
        if (!unique) {
            if (tries == null) {
                tries = new Integer("0");
            }
            Integer n = tries;
            Integer n2 = tries = Integer.valueOf(tries + 1);
            return this.getUniqueStyleName(styles, name, tries);
        }
        return newName;
    }

    private List<SldUserStyle> getUserStyles(Node node) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.setNameSpaceContext(xpath);
        String expr = "sld:UserStyle";
        NodeList nodeSet = (NodeList)xpath.evaluate(expr, node, XPathConstants.NODESET);
        ArrayList<SldUserStyle> userStyles = new ArrayList<SldUserStyle>();
        for (int i = 0; i < nodeSet.getLength(); ++i) {
            Node n = nodeSet.item(i);
            SldUserStyle sldUserStyle = new SldUserStyle(node);
            userStyles.add(sldUserStyle);
        }
        return userStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(String urlString, B3PCredentials credentials) throws Exception {
        HttpClientConfigured hcc = new HttpClientConfigured(credentials);
        HttpGet request = new HttpGet(urlString);
        HttpResponse response = null;
        try {
            response = hcc.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new Exception("Error connecting to server. Status code: " + statusCode);
            }
            Document document = SldWriter.getDocument(entity.getContent());
            return document;
        }
        finally {
            hcc.close(response);
            hcc.close();
        }
    }

    public static Document getDocument(InputStream is) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(is);
        log.debug((Object)("content after parsing: " + DocumentHelper.document2String((Document)doc)));
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(String sld, String charSet) throws Exception {
        InputStream is = null;
        try {
            is = new ByteArrayInputStream(sld.getBytes(charSet));
            Document document = SldWriter.getDocument(is);
            return document;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void setNameSpaceContext(XPath xpath) {
        xpath.setNamespaceContext(new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new NullPointerException("Null prefix");
                }
                if ("sld".equals(prefix)) {
                    return "http://www.opengis.net/sld";
                }
                if ("se".equals(prefix)) {
                    return "http://www.opengis.net/se";
                }
                if ("ogc".equals(prefix)) {
                    return "http://www.opengis.net/ogc";
                }
                if ("xml".equals(prefix)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                return "";
            }

            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException("");
            }

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException("");
            }
        });
    }

    public void addNamedLayers(List<SldNamedLayer> namedlayers) {
        if (this.namedlayers == null) {
            this.namedlayers = namedlayers;
        } else {
            this.namedlayers.addAll(namedlayers);
        }
    }

    public void addNamedLayer(SldNamedLayer namedlayer) {
        if (this.namedlayers == null) {
            this.namedlayers = new ArrayList<SldNamedLayer>();
        }
        this.namedlayers.add(namedlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAndFilterOnNames(String spAbbr, List<String> realLayernames) throws Exception {
        if (this.namedlayers == null || spAbbr == null || spAbbr.isEmpty()) {
            return;
        }
        List<SldNamedLayer> list = this.namedlayers;
        synchronized (list) {
            ArrayList<SldNamedLayer> replacedAndFilteredlayers = new ArrayList<SldNamedLayer>();
            for (SldNamedLayer nl : this.namedlayers) {
                String[] codeAndName = OGCCommunication.toCodeAndName(nl.getName());
                if (codeAndName[0] != null && codeAndName[0].equals(spAbbr)) {
                    nl.setName(codeAndName[1]);
                    replacedAndFilteredlayers.add(nl);
                    continue;
                }
                if (codeAndName[0] != null || codeAndName[1] == null || realLayernames == null) continue;
                for (String ln : realLayernames) {
                    if (!ln.equals(codeAndName[1])) continue;
                    replacedAndFilteredlayers.add(nl);
                }
            }
            this.namedlayers = replacedAndFilteredlayers;
        }
    }

    public List<SldNamedLayer> createNamedLayersWithKBStyles(List<Style> kbStyles) throws UnsupportedEncodingException, IOException, XPathExpressionException, Exception {
        ArrayList<SldNamedLayer> namedLayers = new ArrayList<SldNamedLayer>();
        for (Style kbStyle : kbStyles) {
            Document doc;
            String nodeName;
            ArrayList<SldNode> sldStyles = new ArrayList<SldNode>();
            if (kbStyle.getSldConstraints() != null) {
                Document docConstraint = SldWriter.getDocument(kbStyle.getSldConstraints(), this.encoding);
                sldStyles.add(new SldLayerFeatureConstraints(docConstraint.getDocumentElement()));
            }
            if ((nodeName = (doc = SldWriter.getDocument(kbStyle.getSldPart(), this.encoding)).getDocumentElement().getNodeName()).toLowerCase().indexOf("namedstyle") != -1) {
                sldStyles.add(new SldNamedStyle(doc.getDocumentElement()));
            } else {
                sldStyles.add(new SldUserStyle(doc.getDocumentElement()));
            }
            SldNamedLayer snl = new SldNamedLayer(sldStyles, kbStyle.getLayer().getName());
            namedLayers.add(snl);
        }
        return namedLayers;
    }

    public String createSLD() throws Exception {
        Document sldDoc = SldWriter.getDocument(SldNode.getSldNodeString(this.version), this.encoding);
        for (SldNamedLayer snl : this.namedlayers) {
            Node snlNode = snl.getNode();
            Node importedNode = sldDoc.importNode(snlNode, true);
            sldDoc.getFirstChild().appendChild(importedNode);
            sldDoc.normalizeDocument();
        }
        String sldString = DocumentHelper.document2String((Document)sldDoc);
        String newSldString = sldString.replaceFirst("xmlns:se=\"http://www.opengis.net/se\"", "HACKHACK").replaceAll(" xmlns:se=\"http://www.opengis.net/se\"", "").replaceFirst("HACKHACK", "xmlns:se=\"http://www.opengis.net/se\"");
        return newSldString;
    }

    public List<SldNamedLayer> getNamedlayers() {
        return this.namedlayers;
    }

    public void setNamedlayers(List<SldNamedLayer> namedlayers) {
        this.namedlayers = namedlayers;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

