/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.wms.capabilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nl.b3p.ogc.utils.KBCrypter;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.XMLElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class LayerDomainResource
implements XMLElement {
    public static final String METADATA_DOMAIN = "MetadataURL";
    private static final Log log = LogFactory.getLog(LayerDomainResource.class);
    private Integer id;
    private Set formats;
    private String url;
    private String domain;
    private Layer layer;

    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }

    public Set getFormats() {
        return this.formats;
    }

    public void setFormats(Set formats) {
        this.formats = formats;
    }

    public void addFormat(String f) {
        if (null == this.formats) {
            this.formats = new HashSet();
        }
        this.formats.add(f);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Object clone() {
        LayerDomainResource cloneLDR = new LayerDomainResource();
        if (null != this.id) {
            cloneLDR.id = new Integer(this.id);
        }
        if (null != this.formats) {
            cloneLDR.formats = new HashSet(this.formats);
        }
        if (null != this.url) {
            cloneLDR.url = new String(this.url);
        }
        if (null != this.domain) {
            cloneLDR.domain = new String(this.domain);
        }
        return cloneLDR;
    }

    protected void convertValues2KB(HashMap conversionValues) {
        String newUrl = (String)conversionValues.get("url");
        String spAbbr = (String)conversionValues.get("spAbbr");
        String layerName = (String)conversionValues.get("layerName");
        String layerUniqueName = null;
        String spAbbrUrl = (String)conversionValues.get("spAbbrUrl");
        layerUniqueName = spAbbrUrl != null && spAbbrUrl.equalsIgnoreCase(spAbbr) ? layerName : OGCCommunication.attachSp(spAbbr, layerName);
        int pos = newUrl.indexOf("?");
        newUrl = pos == -1 ? newUrl + "?" : newUrl + "&";
        OGCRequest ogcrequest = new OGCRequest(this.getUrl());
        String ls = ogcrequest.getParameter("SERVICE");
        String lmd = ogcrequest.getParameter("LAYER");
        if (METADATA_DOMAIN.equalsIgnoreCase(this.domain)) {
            if (ls != null && ls.equalsIgnoreCase("METADATA") && lmd != null && lmd.equalsIgnoreCase(layerUniqueName)) {
                newUrl = newUrl + "SERVICE";
                newUrl = newUrl + "=";
                newUrl = newUrl + "METADATA";
                newUrl = newUrl + "&";
                newUrl = newUrl + "LAYER";
                newUrl = newUrl + "=";
                newUrl = newUrl + layerUniqueName;
                this.setUrl(newUrl);
            }
        } else {
            newUrl = newUrl + "SERVICE";
            newUrl = newUrl + "=";
            newUrl = newUrl + "PROXY";
            newUrl = newUrl + "&";
            newUrl = newUrl + "LAYER";
            newUrl = newUrl + "=";
            newUrl = newUrl + layerUniqueName;
            newUrl = newUrl + "&";
            newUrl = newUrl + "PURL";
            newUrl = newUrl + "=";
            try {
                String originalURL = this.getUrl();
                newUrl = newUrl + KBCrypter.encryptText(originalURL);
                this.setUrl(newUrl);
            }
            catch (Exception ex) {
                log.error((Object)"error:", (Throwable)ex);
            }
        }
    }

    public Element toElement(Document doc, Element rootElement) {
        Element domainElement = doc.createElement(this.getDomain());
        if (null != this.getFormats() && this.getFormats().size() != 0) {
            Iterator it = this.formats.iterator();
            while (it.hasNext()) {
                Element formatElement = doc.createElement("Format");
                Text text = doc.createTextNode((String)it.next());
                formatElement.appendChild(text);
                domainElement.appendChild(formatElement);
            }
        }
        if (this.getUrl() != null) {
            Element onlineElement = doc.createElement("OnlineResource");
            onlineElement.setAttribute("xlink:href", this.getUrl());
            onlineElement.setAttribute("xlink:type", "simple");
            onlineElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            domainElement.appendChild(onlineElement);
        }
        rootElement.appendChild(domainElement);
        return rootElement;
    }
}

