/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.writers;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.ShapefileWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class B3pShapeWriter {
    private static final Log log = LogFactory.getLog(B3pShapeWriter.class);
    private String folder;

    public B3pShapeWriter() {
    }

    public B3pShapeWriter(String folder) {
        this.setFolder(folder);
    }

    public List writeToShape(FeatureCollection fcAll, String filename) throws IllegalParametersException, Exception {
        FeatureDataset allPoint = new FeatureDataset(fcAll.getFeatureSchema());
        FeatureDataset allPoly = new FeatureDataset(fcAll.getFeatureSchema());
        FeatureDataset allLine = new FeatureDataset(fcAll.getFeatureSchema());
        for (Feature f : fcAll) {
            if (f.getGeometry() instanceof Point) {
                allPoint.add(f);
                continue;
            }
            if (f.getGeometry() instanceof Polygon) {
                allPoly.add(f);
                continue;
            }
            if (f.getGeometry() instanceof LineString) {
                allLine.add(f);
                continue;
            }
            if (f.getGeometry() instanceof MultiPoint) {
                allPoint.add(f);
                continue;
            }
            if (f.getGeometry() instanceof MultiPolygon) {
                allPoly.add(f);
                continue;
            }
            if (f.getGeometry() instanceof MultiLineString) {
                allLine.add(f);
                continue;
            }
            log.error((Object)("Geometry type not found: " + f.getGeometry().getClass().toString()));
        }
        ArrayList files = new ArrayList();
        if (allPoint.size() > 0) {
            files.addAll(this.writeShape((FeatureCollection)allPoint, filename + "_p.shp"));
        }
        if (allPoly.size() > 0) {
            files.addAll(this.writeShape((FeatureCollection)allPoly, filename + "_v.shp"));
        }
        if (allLine.size() > 0) {
            files.addAll(this.writeShape((FeatureCollection)allLine, filename + "_l.shp"));
        }
        return files;
    }

    public List writeToShape(org.geotools.feature.FeatureCollection fcAll, String filename, Boolean spatialIndex) throws IllegalParametersException, Exception {
        DefaultFeatureCollection allPoint = new DefaultFeatureCollection(null, this.changeGeometryBinding((SimpleFeatureType)fcAll.getSchema(), MultiPoint.class));
        DefaultFeatureCollection allPoly = new DefaultFeatureCollection(null, this.changeGeometryBinding((SimpleFeatureType)fcAll.getSchema(), MultiPolygon.class));
        DefaultFeatureCollection allLine = new DefaultFeatureCollection(null, this.changeGeometryBinding((SimpleFeatureType)fcAll.getSchema(), MultiLineString.class));
        FeatureIterator it = fcAll.features();
        while (it.hasNext()) {
            SimpleFeature f = (SimpleFeature)it.next();
            if (f.getDefaultGeometry() instanceof Point) {
                allPoint.add(f);
                continue;
            }
            if (f.getDefaultGeometry() instanceof Polygon) {
                allPoly.add(f);
                continue;
            }
            if (f.getDefaultGeometry() instanceof LineString) {
                allLine.add(f);
                continue;
            }
            if (f.getDefaultGeometry() instanceof MultiPoint) {
                allPoint.add(f);
                continue;
            }
            if (f.getDefaultGeometry() instanceof MultiPolygon) {
                allPoly.add(f);
                continue;
            }
            if (f.getDefaultGeometry() instanceof MultiLineString) {
                allLine.add(f);
                continue;
            }
            if (f.getDefaultGeometry() == null) {
                log.error((Object)"No default geometry set.");
                continue;
            }
            log.error((Object)("Geometry type not found: " + f.getDefaultGeometry().getClass().toString()));
        }
        ArrayList files = new ArrayList();
        if (allPoint.size() > 0) {
            files.addAll(this.writeShape(allPoint, filename + "_p.shp", spatialIndex));
        }
        if (allPoly.size() > 0) {
            files.addAll(this.writeShape(allPoly, filename + "_v.shp", spatialIndex));
        }
        if (allLine.size() > 0) {
            files.addAll(this.writeShape(allLine, filename + "_l.shp", spatialIndex));
        }
        return files;
    }

    public SimpleFeatureType changeGeometryBinding(SimpleFeatureType ft, Class geomBinding) {
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(ft.getAttributeDescriptors());
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(ft);
        if (ft.getGeometryDescriptor() != null) {
            AttributeDescriptor gd = this.changeGeometryBinding(ft.getGeometryDescriptor(), geomBinding);
            attributeDescriptors.set(ft.indexOf(ft.getGeometryDescriptor().getName()), gd);
            builder.setDefaultGeometry(ft.getGeometryDescriptor().getName().getLocalPart());
            builder.setAttributes(attributeDescriptors);
        }
        SimpleFeatureType newFt = builder.buildFeatureType();
        return newFt;
    }

    public AttributeDescriptor changeGeometryBinding(GeometryDescriptor gd, Class geomBinding) {
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.init((AttributeDescriptor)gd);
        builder.setBinding(geomBinding);
        builder.setCRS(gd.getCoordinateReferenceSystem());
        return builder.buildDescriptor(gd.getLocalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List writeShape(DefaultFeatureCollection fc, String shpName, Boolean spatialIndex) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        if (!shpName.endsWith(".shp")) {
            shpName = shpName + ".shp";
        }
        File newShape = new File(this.getFolder() + shpName);
        boolean created = newShape.createNewFile();
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(ShapefileDataStoreFactory.URLP.key, newShape.toURI().toURL());
        map.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, spatialIndex);
        ShapefileDataStore ds = (ShapefileDataStore)factory.createNewDataStore(map);
        SimpleFeatureType ft = fc.getSchema();
        ds.createSchema(ft);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = ds.getTypeNames()[0];
        FeatureStore fs = (FeatureStore)ds.getFeatureSource(typeName);
        try {
            fs.addFeatures((org.geotools.feature.FeatureCollection)fc);
            transaction.commit();
        }
        catch (Exception ex) {
            log.error((Object)"Error writing shape file. ", (Throwable)ex);
        }
        finally {
            transaction.close();
            ds.dispose();
        }
        String name = shpName.replace(".shp", "");
        File shpFile = new File(this.getFolder() + shpName);
        File dbfFile = new File(this.getFolder() + name + ".dbf");
        File shxFile = new File(this.getFolder() + name + ".shx");
        if (shpFile.exists()) {
            files.add(shpFile);
        }
        if (dbfFile.exists()) {
            files.add(dbfFile);
        }
        if (shxFile.exists()) {
            files.add(dbfFile);
        }
        return files;
    }

    public List writeShape(FeatureCollection fc, String shpName) throws IllegalParametersException, Exception {
        ArrayList<File> files = new ArrayList<File>();
        if (!shpName.endsWith(".shp")) {
            shpName = shpName + ".shp";
        }
        String name = shpName.replace(".shp", "");
        String dbfName = name + ".dbf";
        String shxName = name + ".shx";
        DriverProperties dpo = new DriverProperties(this.getFolder() + shpName);
        ShapefileWriter sw = new ShapefileWriter();
        sw.write(fc, dpo);
        File shpFile = new File(this.getFolder() + shpName);
        File dbfFile = new File(this.getFolder() + dbfName);
        File shxFile = new File(this.getFolder() + shxName);
        if (shpFile.exists()) {
            files.add(shpFile);
        }
        if (dbfFile.exists()) {
            files.add(dbfFile);
        }
        if (shxFile.exists()) {
            files.add(shxFile);
        }
        return files;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }
}

