/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import nl.b3p.ogc.utils.KBConfiguration;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KBCrypter {
    private static final Log log = LogFactory.getLog(KBCrypter.class);
    protected static final String CHARSET = "US-ASCII";
    protected static final String encryptionAlgorithm = "DES";
    protected static final String encryptionMode = "ECB";
    protected static final String encryptionPadding = "PKCS5Padding";
    protected static SecretKey secretKey;
    protected static String cipherParameters;

    public static String encryptText(String clearText) throws Exception {
        if (clearText == null) {
            log.error((Object)"text to encrypt may not be null!");
            throw new Exception("text to encrypt may not be null!");
        }
        Base64 encoder = new Base64();
        Cipher c1 = Cipher.getInstance(cipherParameters);
        c1.init(1, secretKey);
        byte[] clearTextBytes = clearText.getBytes();
        byte[] encryptedText = c1.doFinal(clearTextBytes);
        String encryptedEncodedText = new String(encoder.encode(encryptedText), CHARSET);
        encryptedEncodedText = encryptedEncodedText.replaceAll("[\r\n]", "");
        return URLEncoder.encode(encryptedEncodedText, "utf-8");
    }

    public static String decryptText(String encryptedText) throws Exception {
        if (encryptedText == null) {
            return null;
        }
        String et = URLDecoder.decode(encryptedText, "utf-8");
        Base64 decoder = new Base64();
        byte[] decodedEncryptedText = decoder.decode(et.getBytes(CHARSET));
        Cipher c1 = Cipher.getInstance(cipherParameters);
        c1.init(2, secretKey);
        byte[] decryptedText = c1.doFinal(decodedEncryptedText);
        String decryptedTextString = new String(decryptedText);
        return decryptedTextString;
    }

    static {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptionAlgorithm);
            DESKeySpec desKeySpec = new DESKeySpec(KBConfiguration.KB_ENCRYPT_KEY.getBytes(CHARSET));
            secretKey = keyFactory.generateSecret(desKeySpec);
        }
        catch (Exception e) {
            log.error((Object)"error: ", (Throwable)e);
        }
        cipherParameters = "DES/ECB/PKCS5Padding";
    }
}

