/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.FeatureCollection;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.commons.xml.IgnoreEntityResolver;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.xml.ogc.v100.PropertyName;
import nl.b3p.xml.ogc.v100.exception.ServiceException;
import nl.b3p.xml.ogc.v100.exception.ServiceExceptionReport;
import nl.b3p.xml.ogc.v110.Filter;
import nl.b3p.xml.ogc.v110.Literal;
import nl.b3p.xml.ogc.v110.PropertyIsEqualTo;
import nl.b3p.xml.ows.v100.AcceptVersions;
import nl.b3p.xml.ows.v100.DCP;
import nl.b3p.xml.ows.v100.HTTPItem;
import nl.b3p.xml.ows.v100.OperationsMetadata;
import nl.b3p.xml.wfs.DescribeFeatureType;
import nl.b3p.xml.wfs.FeatureType;
import nl.b3p.xml.wfs.FeatureTypeList;
import nl.b3p.xml.wfs.WFS_Capabilities;
import nl.b3p.xml.wfs.v100.GetCapabilities;
import nl.b3p.xml.wfs.v100.GetFeature;
import nl.b3p.xml.wfs.v100.capabilities.DCPTypeType;
import nl.b3p.xml.wfs.v100.capabilities.HTTP;
import nl.b3p.xml.wfs.v100.capabilities.RequestTypeItem;
import nl.b3p.xml.wfs.v110.Delete;
import nl.b3p.xml.wfs.v110.Insert;
import nl.b3p.xml.wfs.v110.Query;
import nl.b3p.xml.wfs.v110.QueryTypeChoice;
import nl.b3p.xml.wfs.v110.QueryTypeChoiceItem;
import nl.b3p.xml.wfs.v110.Transaction;
import nl.b3p.xml.wfs.v110.TransactionTypeChoice;
import nl.b3p.xml.wfs.v110.TransactionTypeChoiceItem;
import nl.b3p.xml.wfs.v110.Update;
import nl.b3p.xml.wfs.v110.types.AllSomeType;
import nl.b3p.xml.wfs.v110.types.ResultTypeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.util.SAX2ANY;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.Parser;
import org.opengis.feature.Feature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class OgcWfsClient {
    private static final Log log = LogFactory.getLog(OgcWfsClient.class);
    private static String GETMETHOD = "GET";
    private static String POSTMETHOD = "POST";

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WFS_Capabilities getCapabilities(OGCRequest original) throws Exception {
        void var1_8;
        OGCRequest or = (OGCRequest)original.clone();
        or.removeAllWFSParameters();
        or.addOrReplaceParameter("SERVICE", "WFS");
        or.addOrReplaceParameter("REQUEST", "GetCapabilities");
        if (original.getParameter("VERSION") != null) {
            or.addOrReplaceParameter("VERSION", original.getParameter("VERSION"));
        }
        String host = or.getUrlWithNonOGCparams();
        String url = or.getUrl();
        Element el = OgcWfsClient.doRequest(url, host, or.getNameSpaces(), or.getUsername(), or.getPassword());
        if (el.getTagName().contains("WFS_Capabilities")) {
            String version = el.getAttribute("VERSION".toLowerCase());
            if (version.equalsIgnoreCase("1.0.0")) {
                if (original.getParameter("VERSION") == null) {
                    original.addOrReplaceParameter("VERSION", version);
                }
                nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities wFS_Capabilities = OgcWfsClient.getCapabilitiesVersion100(el);
            } else {
                if (!version.equalsIgnoreCase("1.1.0")) throw new UnsupportedOperationException("WFS GetCapabilities version: " + version + " not supported");
                if (original.getParameter("VERSION") == null) {
                    original.addOrReplaceParameter("VERSION", version);
                }
                nl.b3p.xml.wfs.v110.WFS_Capabilities wFS_Capabilities = OgcWfsClient.getCapabilitiesVersion110(el);
            }
        } else {
            log.error((Object)("Unexpected element returned: " + el.getTagName()));
            throw new Exception("Unexpected element returned: " + el.getTagName());
        }
        original.setCapabilities((WFS_Capabilities)var1_8);
        return var1_8;
    }

    public static Element doRequest(Object o, String host, String username, String password) throws Exception {
        return OgcWfsClient.doRequest(o, host, null, username, password);
    }

    public static Element doRequest(Object o, String host, HashMap namespaces, String username, String password) throws Exception {
        Element el = OgcWfsClient.readXml2Element(new InputStreamReader(OgcWfsClient.getInputStreamReader(o, host, namespaces, username, password)));
        if (OGCRequest.removeNamespace(el.getTagName()).equalsIgnoreCase("ServiceExceptionReport")) {
            ServiceExceptionReport ser = OgcWfsClient.getServiceExceptionReport(el);
            StringBuffer sb = new StringBuffer();
            ServiceException se = null;
            for (int i = 0; i < ser.getServiceExceptionCount(); ++i) {
                if (i != 0) {
                    sb.append(" and ");
                }
                se = ser.getServiceException(i);
                sb.append(se.getContent());
            }
            throw new Exception(sb.toString());
        }
        return el;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getInputStreamReader(Object o, String host, HashMap namespaces, String username, String password) throws Exception {
        InputStream inputStream;
        B3PCredentials credentials = new B3PCredentials();
        credentials.setUserName(username);
        credentials.setPassword(password);
        HttpClientConfigured hcc = new HttpClientConfigured(credentials);
        HttpResponse response = null;
        try {
            if (o instanceof String) {
                String url = (String)o;
                url = url.replaceAll(" ", "%20");
                HttpGet httpget = new HttpGet(url);
                response = hcc.execute((HttpUriRequest)httpget);
            } else {
                String body = null;
                StringWriter sw = new StringWriter();
                Marshaller m = new Marshaller((Writer)sw);
                m.setMarshalAsDocument(false);
                m.setNamespaceMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                m.setSchemaLocation("http://www.opengis.net/wfs ../wfs/1.1.0/WFS.xsd");
                m.setNamespaceMapping("wfs", "http://www.opengis.net/wfs");
                m.setNamespaceMapping("gml", "http://www.opengis.net/gml");
                m.setNamespaceMapping("ogc", "http://www.opengis.net/ogc");
                if (namespaces != null) {
                    for (String key : namespaces.keySet()) {
                        String value = (String)namespaces.get(key);
                        if (key == null || value == null) continue;
                        m.setNamespaceMapping(key, value);
                    }
                }
                m.marshal(o);
                body = sw.toString();
                HttpPost httppost = new HttpPost(body);
                httppost.setEntity((HttpEntity)new StringEntity(body));
                response = hcc.execute((HttpUriRequest)httppost);
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new Exception("Error connecting to server. Status code: " + statusCode);
            }
            inputStream = response.getEntity().getContent();
        }
        catch (Throwable throwable) {
            hcc.close(response);
            hcc.close();
            throw throwable;
        }
        hcc.close(response);
        hcc.close();
        return inputStream;
    }

    public static Element getDescribeFeatureType(OGCRequest original) throws Exception {
        WFS_Capabilities cap = null;
        cap = original.getCapabilities() == null ? OgcWfsClient.getCapabilities(original) : original.getCapabilities();
        List methodsAllowed = OgcWfsClient.extractHttpMethodsAllowed(cap, "DescribeFeatureType");
        Element returnvalue = null;
        OGCRequest or = (OGCRequest)original.clone();
        or.addOrReplaceParameter("SERVICE", "WFS");
        or.addOrReplaceParameter("REQUEST", "DescribeFeatureType");
        String host = or.getUrlWithNonOGCparams();
        if (methodsAllowed.contains(POSTMETHOD)) {
            returnvalue = OgcWfsClient.doRequest(OgcWfsClient.getDescribeFeatureTypeRequest(or), host, or.getNameSpaces(), or.getUsername(), or.getPassword());
        } else if (methodsAllowed.contains(GETMETHOD)) {
            returnvalue = OgcWfsClient.doRequest(or.getUrl(), host, or.getUsername(), or.getPassword());
        }
        return returnvalue;
    }

    public static ArrayList getDescribeFeatureElements(Element el) throws Exception {
        String namespaceUri = el.getNamespaceURI();
        NodeList childs = el.getChildNodes();
        String prefix = "";
        for (int i = 0; i < childs.getLength() && prefix.length() == 0; ++i) {
            Element e;
            Node n = childs.item(i);
            if (!(n instanceof DeferredElementNSImpl) || !(e = (Element)n).getLocalName().equalsIgnoreCase("element") || e.getAttribute("type") == null || !e.getAttribute("type").contains(":")) continue;
            prefix = e.getAttribute("type").split(":")[0];
        }
        String featureNameSpace = null;
        if (prefix.length() > 0) {
            featureNameSpace = el.getAttribute("xmlns:" + prefix);
        }
        String s = OgcWfsClient.elementToString(el);
        if (el == null) {
            return null;
        }
        NodeList nlist = el.getElementsByTagNameNS(namespaceUri, "complexType");
        if (nlist.getLength() <= 0) {
            log.error((Object)"no complexType element found");
            return null;
        }
        ArrayList<Element> returnValue = new ArrayList<Element>();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Element e = (Element)nlist.item(i);
            NodeList nl = e.getElementsByTagNameNS(namespaceUri, "element");
            for (int b = 0; b < nl.getLength(); ++b) {
                Element element = (Element)nl.item(b);
                if (featureNameSpace != null && featureNameSpace.length() > 0) {
                    element.setAttribute("name", "{" + featureNameSpace + "}" + element.getAttribute("name"));
                }
                returnValue.add(element);
            }
        }
        return returnValue;
    }

    public static FeatureType getCapabilitieFeatureType(WFS_Capabilities cap, String name) {
        FeatureTypeList ftl = cap.getFeatureTypeList();
        for (int i = 0; i < ftl.getFeatureTypeCount(); ++i) {
            FeatureType ft = ftl.getFeatureType(i);
            if (!ft.getName().equalsIgnoreCase(name)) continue;
            return ft;
        }
        return null;
    }

    public static DescribeFeatureType getDescribeFeatureTypeRequest(OGCRequest original) throws Exception {
        OGCRequest or = (OGCRequest)original.clone();
        or.addOrReplaceParameter("REQUEST", "DescribeFeatureType");
        Serializable dft = null;
        if (or.getParameter("VERSION") == null) {
            OgcWfsClient.getCapabilities(or);
            original.addOrReplaceParameter("VERSION", or.getParameter("VERSION"));
        }
        if (or.getFinalVersion() != null && !or.getFinalVersion().equalsIgnoreCase("unspecified") && !or.getParameter("VERSION").equalsIgnoreCase(or.getFinalVersion())) {
            or.addOrReplaceParameter("VERSION", or.getFinalVersion());
        }
        if ("1.0.0".equalsIgnoreCase(or.getParameter("VERSION"))) {
            dft = new nl.b3p.xml.wfs.v100.DescribeFeatureType();
        } else if ("1.1.0".equalsIgnoreCase(or.getParameter("VERSION"))) {
            dft = new nl.b3p.xml.wfs.v110.DescribeFeatureType();
        } else {
            throw new UnsupportedOperationException("WFS DescribeFeatureTypeRequest version: " + or.getParameter("VERSION") + " not supported");
        }
        if (or.getParameter("VERSION") != null) {
            dft.setVersion(or.getParameter("VERSION"));
        }
        if (or.getParameter("SERVICE") != null) {
            dft.setService(or.getParameter("SERVICE"));
        }
        if (or.getParameter("OUTPUTFORMAT") != null) {
            dft.setOutputFormat(or.getParameter("OUTPUTFORMAT"));
        } else {
            dft.setOutputFormat(null);
        }
        if (or.getParameter("TYPENAME") != null) {
            String[] types = or.getParameter("TYPENAME").split(",");
            for (int i = 0; i < types.length; ++i) {
                dft.addTypeName(types[i]);
            }
        }
        return dft;
    }

    public static nl.b3p.xml.wfs.GetCapabilities getGetCapabilitiesRequest(OGCRequest or) {
        if (or.getParameter("VERSION") != null && or.getFinalVersion() != null && !or.getParameter("VERSION").equalsIgnoreCase(or.getFinalVersion()) && !or.getFinalVersion().equalsIgnoreCase("unspecified")) {
            or.addOrReplaceParameter("VERSION", or.getFinalVersion());
        }
        if ("1.0.0".equalsIgnoreCase(or.getParameter("VERSION"))) {
            GetCapabilities gc = new GetCapabilities();
            gc.setService("WFS");
            gc.setVersion(or.getParameter("VERSION"));
            return gc;
        }
        nl.b3p.xml.wfs.v110.GetCapabilities gc = new nl.b3p.xml.wfs.v110.GetCapabilities();
        gc.setService("WFS");
        AcceptVersions av = new AcceptVersions();
        av.addVersion("1.1.0");
        gc.setAcceptVersions(av);
        return gc;
    }

    public static nl.b3p.xml.wfs.GetFeature getGetFeatureRequest(OGCRequest original) throws MarshalException, ValidationException, Exception {
        OGCRequest or = (OGCRequest)original.clone();
        or.addOrReplaceParameter("REQUEST", "GetFeature");
        Serializable gf = null;
        if (or.getParameter("VERSION") == null) {
            OgcWfsClient.getCapabilities(or);
            original.addOrReplaceParameter("VERSION", or.getParameter("VERSION"));
        }
        if (or.getFinalVersion() != null && !or.getParameter("VERSION").equalsIgnoreCase(or.getFinalVersion())) {
            or.addOrReplaceParameter("VERSION", or.getFinalVersion());
        }
        if ("1.0.0".equalsIgnoreCase(or.getParameter("VERSION"))) {
            gf = new GetFeature();
        } else if ("1.1.0".equalsIgnoreCase(or.getParameter("VERSION"))) {
            gf = new nl.b3p.xml.wfs.v110.GetFeature();
        } else {
            throw new UnsupportedOperationException("WFS GetFeatureRequest version: " + or.getParameter("VERSION") + " not supported");
        }
        if (or.getParameter("VERSION") != null) {
            gf.setVersion(or.getParameter("VERSION"));
        }
        if (or.getParameter("SERVICE") != null) {
            gf.setService(or.getParameter("SERVICE"));
        }
        if (or.getParameter("MAXFEATURES") != null) {
            int mf;
            try {
                mf = Integer.parseInt(or.getParameter("MAXFEATURES"));
            }
            catch (NumberFormatException nfe) {
                mf = 10;
                log.debug((Object)("error parsing MAXFEATURES, using:" + mf), (Throwable)nfe);
            }
            gf.setMaxFeatures(mf);
        }
        if (or.getParameter("OUTPUTFORMAT") != null) {
            gf.setOutputFormat(or.getParameter("OUTPUTFORMAT"));
        } else {
            gf.setOutputFormat(null);
        }
        if (gf instanceof GetFeature) {
            int i;
            GetFeature gfv100 = (GetFeature)gf;
            nl.b3p.xml.ogc.v100.Filter filter = null;
            if (or.getParameter("FILTER") != null) {
                try {
                    filter = (nl.b3p.xml.ogc.v100.Filter)Unmarshaller.unmarshal(nl.b3p.xml.ogc.v100.Filter.class, (Reader)new StringReader(or.getParameter("FILTER")));
                }
                catch (Exception e) {
                    log.error((Object)"Filter v100 (WFS version 1.0.0) not correct", (Throwable)e);
                }
            }
            PropertyName[] properties = null;
            if (or.getParameter("PROPERTYNAME") != null) {
                try {
                    String[] propertyNames = or.getParameter("PROPERTYNAME").split(",");
                    properties = new PropertyName[propertyNames.length];
                    for (i = 0; i < propertyNames.length; ++i) {
                        properties[i] = new PropertyName();
                        properties[i].setContent(propertyNames[i]);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"PropertyName v100 (WFS version 1.0.0) not correct", (Throwable)e);
                }
            }
            if (or.getParameter("TYPENAME") != null) {
                String[] typenames = or.getParameter("TYPENAME").split(",");
                for (i = 0; i < typenames.length; ++i) {
                    nl.b3p.xml.wfs.v100.Query q = new nl.b3p.xml.wfs.v100.Query();
                    q.setTypeName(typenames[i]);
                    if (filter != null) {
                        q.setFilter(filter);
                    }
                    if (properties != null) {
                        q.setPropertyName(properties);
                    }
                    gfv100.addQuery(q);
                }
            } else {
                nl.b3p.xml.wfs.v100.Query q = new nl.b3p.xml.wfs.v100.Query();
                if (filter != null) {
                    q.setFilter(filter);
                }
                if (properties != null) {
                    q.setPropertyName(properties);
                }
                gfv100.addQuery(q);
            }
        } else if (gf instanceof nl.b3p.xml.wfs.v110.GetFeature) {
            int i;
            nl.b3p.xml.wfs.v110.GetFeature gfv110 = (nl.b3p.xml.wfs.v110.GetFeature)gf;
            Filter filter = null;
            if (or.getParameter("FILTER") != null) {
                try {
                    filter = (Filter)Unmarshaller.unmarshal(Filter.class, (Reader)new StringReader(or.getParameter("FILTER")));
                }
                catch (Exception e) {
                    log.error((Object)"Filter v110 (WFS version 1.1.0) not correct", (Throwable)e);
                    throw new UnsupportedOperationException("Filter is not correct!");
                }
            }
            QueryTypeChoice[] queryTypeChoice = null;
            if (or.getParameter("PROPERTYNAME") != null) {
                try {
                    String[] propertyNames = or.getParameter("PROPERTYNAME").split(",");
                    queryTypeChoice = new QueryTypeChoice[]{new QueryTypeChoice()};
                    for (i = 0; i < propertyNames.length; ++i) {
                        QueryTypeChoiceItem queryTypeChoiceItem = new QueryTypeChoiceItem();
                        queryTypeChoiceItem.setPropertyName(propertyNames[i]);
                        queryTypeChoice[0].addQueryTypeChoiceItem(queryTypeChoiceItem);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"PropertyName v100 (WFS version 1.0.0) not correct", (Throwable)e);
                }
            }
            if (or.getParameter("TYPENAME") != null) {
                String[] typeNames = or.getParameter("TYPENAME").split(",");
                for (i = 0; i < typeNames.length; ++i) {
                    Query q = new Query();
                    q.setTypeName(typeNames[i]);
                    if (or.getParameter("SRSNAME") != null) {
                        q.setSrsName(or.getParameter("SRSNAME"));
                    }
                    if (or.getParameter("RESULTTYPE") != null) {
                        gfv110.getResultType();
                        ResultTypeType resultType = ResultTypeType.valueOf(or.getParameter("RESULTTYPE"));
                        gfv110.setResultType(resultType);
                    }
                    if (filter != null) {
                        q.setFilter(filter);
                    }
                    if (queryTypeChoice != null) {
                        q.setQueryTypeChoice(queryTypeChoice);
                    }
                    gfv110.addQuery(q);
                }
            } else {
                Query q = new Query();
                if (or.getParameter("SRSNAME") != null) {
                    q.setSrsName(or.getParameter("SRSNAME"));
                }
                if (or.getParameter("RESULTTYPE") != null) {
                    gfv110.getResultType();
                    ResultTypeType resultType = ResultTypeType.valueOf(or.getParameter("RESULTTYPE"));
                    gfv110.setResultType(resultType);
                }
                if (filter != null) {
                    q.setFilter(filter);
                }
                if (queryTypeChoice != null) {
                    q.setQueryTypeChoice(queryTypeChoice);
                }
                gfv110.addQuery(q);
            }
        }
        return gf;
    }

    public static nl.b3p.xml.wfs.Transaction getTransactionRequest(OGCRequest original) throws MarshalException, ValidationException, Exception {
        OGCRequest or = (OGCRequest)original.clone();
        or.addOrReplaceParameter("REQUEST", "Transaction");
        nl.b3p.xml.wfs.Transaction tr = null;
        if (or.getParameter("VERSION") == null) {
            OgcWfsClient.getCapabilities(or);
            original.addOrReplaceParameter("VERSION", or.getParameter("VERSION"));
        }
        if (or.getFinalVersion() != null && !or.getFinalVersion().equalsIgnoreCase("unspecified") && !or.getParameter("VERSION").equalsIgnoreCase(or.getFinalVersion())) {
            or.addOrReplaceParameter("VERSION", or.getFinalVersion());
        }
        if ("1.0.0".equalsIgnoreCase(or.getParameter("VERSION"))) {
            tr = new nl.b3p.xml.wfs.v100.transaction.Transaction();
        } else if ("1.1.0".equalsIgnoreCase(or.getParameter("VERSION"))) {
            tr = new Transaction();
        } else {
            throw new UnsupportedOperationException("WFS TransactionRequest version: " + or.getParameter("VERSION") + " not supported!");
        }
        if (or.getParameter("VERSION") != null) {
            tr.setVersion(or.getParameter("VERSION"));
        }
        if (or.getParameter("SERVICE") != null) {
            tr.setService(or.getParameter("SERVICE"));
        }
        if (or.getParameter("HANDLE") != null) {
            tr.setHandle(or.getParameter("HANDLE"));
        }
        if (or.getParameter("LOCKID") != null) {
            tr.setLockId(or.getParameter("LOCKID"));
        }
        if (tr instanceof Transaction) {
            Transaction trV110 = (Transaction)tr;
            if (or.getParameter("RELEASEACTION") != null) {
                String release = or.getParameter("RELEASEACTION");
                AllSomeType releaseAction = (AllSomeType)Unmarshaller.unmarshal(AllSomeType.class, (Reader)new StringReader(release));
                trV110.setReleaseAction(releaseAction);
            }
            List TransactionList = or.getTransactionElementList(or.getAbbr());
            TransactionTypeChoice ttc = new TransactionTypeChoice();
            Iterator it = TransactionList.iterator();
            while (it.hasNext()) {
                TransactionTypeChoiceItem ttci = new TransactionTypeChoiceItem();
                Object o = it.next();
                if (o instanceof Delete) {
                    Delete delete = (Delete)o;
                    ttci.setDelete(delete);
                } else if (o instanceof Insert) {
                    Insert insert = (Insert)o;
                    ttci.setInsert(insert);
                } else if (o instanceof Update) {
                    Update update = (Update)o;
                    ttci.setUpdate(update);
                }
                ttc.addTransactionTypeChoiceItem(ttci);
            }
            trV110.addTransactionTypeChoice(ttc);
        }
        return tr;
    }

    public static String getRequestBody(OGCRequest or) throws Exception {
        String body = null;
        Object castorObject = null;
        if (or.getParameter("REQUEST") == null || or.getParameter("REQUEST").length() <= 0) {
            return body;
        }
        if (or.getParameter("REQUEST").equalsIgnoreCase("DescribeFeatureType")) {
            castorObject = OgcWfsClient.getDescribeFeatureTypeRequest(or);
        } else if (or.getParameter("REQUEST").equalsIgnoreCase("GetFeature")) {
            castorObject = OgcWfsClient.getGetFeatureRequest(or);
        } else if (or.getParameter("REQUEST").equalsIgnoreCase("GetCapabilities")) {
            castorObject = OgcWfsClient.getGetCapabilitiesRequest(or);
        } else if (or.getParameter("REQUEST").equalsIgnoreCase("Transaction")) {
            castorObject = OgcWfsClient.getTransactionRequest(or);
        } else {
            throw new UnsupportedOperationException("Request: " + or.getParameter("REQUEST") + " wordt (nog) niet ondersteund");
        }
        StringWriter sw = new StringWriter();
        Marshaller m = new Marshaller((Writer)sw);
        if (or.getNameSpaces() != null) {
            Set mapEntries = or.getNameSpaces().entrySet();
            for (Map.Entry me : mapEntries) {
                m.setNamespaceMapping((String)me.getKey(), (String)me.getValue());
            }
        }
        m.setNamespaceMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        m.setSchemaLocation("http://www.opengis.net/wfs ../wfs/1.1.0/WFS.xsd");
        if (castorObject != null) {
            m.marshal(castorObject);
            body = sw.toString();
        }
        return body;
    }

    public static ServiceExceptionReport getServiceExceptionReport(Element element) throws MarshalException, ValidationException {
        Unmarshaller um = new Unmarshaller(ServiceExceptionReport.class);
        Object o = um.unmarshal((Node)element);
        return (ServiceExceptionReport)o;
    }

    public static nl.b3p.xml.wfs.v110.WFS_Capabilities getCapabilitiesVersion110(Element element) throws ValidationException, Exception {
        Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v110.WFS_Capabilities.class);
        Object o = um.unmarshal((Node)element);
        return (nl.b3p.xml.wfs.v110.WFS_Capabilities)o;
    }

    public static nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities getCapabilitiesVersion100(Element element) throws ValidationException, Exception {
        Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities.class);
        Object o = um.unmarshal((Node)element);
        return (nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities)o;
    }

    public static void addBboxFilter(nl.b3p.xml.wfs.GetFeature gf, String attributeName, double[] bbox, String srsName, FeatureType ft) throws Exception {
        nl.b3p.xml.wfs.Filter filter = OgcWfsClient.createBboxFilter(attributeName, bbox, srsName, ft);
        if (gf instanceof GetFeature) {
            ((GetFeature)gf).getQuery(0).setFilter((nl.b3p.xml.ogc.v100.Filter)filter);
        } else if (gf instanceof nl.b3p.xml.wfs.v110.GetFeature) {
            ((nl.b3p.xml.wfs.v110.GetFeature)gf).getQuery(0).setFilter((Filter)filter);
        }
    }

    public static void addPolygonFilter(nl.b3p.xml.wfs.GetFeature gf, String attributeName, String polygon, String srsName, FeatureType ft) throws Exception {
        nl.b3p.xml.wfs.Filter filter = OgcWfsClient.createPolygonFilter(attributeName, polygon, srsName, ft);
        if (gf instanceof GetFeature) {
            ((GetFeature)gf).getQuery(0).setFilter((nl.b3p.xml.ogc.v100.Filter)filter);
        } else if (gf instanceof nl.b3p.xml.wfs.v110.GetFeature) {
            ((nl.b3p.xml.wfs.v110.GetFeature)gf).getQuery(0).setFilter((Filter)filter);
        }
    }

    public static void addQueryFilter(nl.b3p.xml.wfs.GetFeature gf, String adminQuery, String srsName, FeatureType ft) throws Exception {
        nl.b3p.xml.wfs.Filter filter = OgcWfsClient.createQueryFilter(gf, adminQuery, srsName, ft);
        if (ft instanceof nl.b3p.xml.wfs.v100.capabilities.FeatureType) {
            ((GetFeature)gf).getQuery(0).setFilter((nl.b3p.xml.ogc.v100.Filter)filter);
        } else if (ft instanceof nl.b3p.xml.wfs.v110.FeatureType) {
            ((nl.b3p.xml.wfs.v110.GetFeature)gf).getQuery(0).setFilter((Filter)filter);
        }
    }

    public static nl.b3p.xml.wfs.Filter createBboxFilter(String attributeName, double[] bbox, String srsName, FeatureType feature) throws Exception {
        if (attributeName.indexOf("{") >= 0 && attributeName.indexOf("}") >= 0) {
            attributeName = attributeName.substring(attributeName.indexOf("}") + 1);
        }
        if (feature instanceof nl.b3p.xml.wfs.v100.capabilities.FeatureType) {
            StringBuffer sb = new StringBuffer();
            sb.append("<Filter><BBOX><PropertyName>");
            sb.append(attributeName);
            sb.append("</PropertyName>");
            sb.append("<gml:Box");
            if (srsName != null) {
                sb.append(" srsName=\"");
                sb.append(srsName);
            }
            sb.append("\"><gml:coordinates>");
            sb.append(bbox[0]).append(",").append(bbox[1]);
            sb.append(" ");
            sb.append(bbox[2]).append(",").append(bbox[3]);
            sb.append("</gml:coordinates></gml:Box>");
            sb.append("</BBOX></Filter>");
            return (nl.b3p.xml.ogc.v100.Filter)Unmarshaller.unmarshal(nl.b3p.xml.ogc.v100.Filter.class, (Reader)new StringReader(sb.toString()));
        }
        if (feature instanceof nl.b3p.xml.wfs.v110.FeatureType) {
            StringBuffer sb = new StringBuffer();
            sb.append("<Filter><Intersects><PropertyName>");
            sb.append(attributeName);
            sb.append("</PropertyName>");
            sb.append("<gml:Envelope");
            if (srsName != null) {
                sb.append(" srsName=\"");
                sb.append(srsName);
            }
            sb.append("\"><gml:lowerCorner>");
            sb.append(bbox[0]).append(" ").append(bbox[1]);
            sb.append("</gml:lowerCorner><gml:upperCorner>");
            sb.append(bbox[2]).append(" ").append(bbox[3]);
            sb.append("</gml:upperCorner></gml:Envelope>");
            sb.append("</Intersects></Filter>");
            return (Filter)Unmarshaller.unmarshal(Filter.class, (Reader)new StringReader(sb.toString()));
        }
        throw new UnsupportedOperationException("Given Feature not supported, class: " + (feature == null ? "" : feature.getClass()) + ", attribute: " + attributeName);
    }

    public static nl.b3p.xml.wfs.Filter createPolygonFilter(String attributeName, String polygon, String srsName, FeatureType feature) throws Exception {
        if (attributeName.indexOf("{") >= 0 && attributeName.indexOf("}") >= 0) {
            attributeName = attributeName.substring(attributeName.indexOf("}") + 1);
        }
        if (feature instanceof nl.b3p.xml.wfs.v100.capabilities.FeatureType) {
            String newPolygon = "";
            String[] splitKomma = polygon.split(",");
            for (int i = 0; i < splitKomma.length; ++i) {
                String[] splitSpatie = splitKomma[i].split(" ");
                newPolygon = i + 1 < splitKomma.length ? newPolygon + splitSpatie[0] + "," + splitSpatie[1] + " " : newPolygon + splitSpatie[0] + "," + splitSpatie[1];
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<Filter><Intersects><PropertyName>");
            sb.append(attributeName);
            sb.append("</PropertyName>");
            sb.append("<gml:Polygon");
            if (srsName != null) {
                sb.append(" srsName=\"");
                sb.append(srsName);
            }
            sb.append("\"><gml:outerBoundaryIs>");
            sb.append("<gml:LinearRing>");
            sb.append("<gml:coordinates cs=\",\" decimal=\".\" ts=\" \">");
            sb.append(newPolygon);
            sb.append("</gml:coordinates>");
            sb.append("</gml:LinearRing>");
            sb.append("</gml:outerBoundaryIs>");
            sb.append("</gml:Polygon>");
            sb.append("</Intersects></Filter>");
            return (nl.b3p.xml.ogc.v100.Filter)Unmarshaller.unmarshal(nl.b3p.xml.ogc.v100.Filter.class, (Reader)new StringReader(sb.toString()));
        }
        if (feature instanceof nl.b3p.xml.wfs.v110.FeatureType) {
            StringBuffer sb = new StringBuffer();
            sb.append("<Filter><Intersects><PropertyName>");
            sb.append(attributeName);
            sb.append("</PropertyName>");
            sb.append("<gml:Polygon");
            if (srsName != null) {
                sb.append(" srsName=\"");
                sb.append(srsName);
            }
            sb.append("\"><gml:outerBoundaryIs>");
            sb.append("<gml:LinearRing>");
            sb.append("<gml:posList>");
            sb.append(polygon);
            sb.append("</gml:posList>");
            sb.append("</gml:LinearRing>");
            sb.append("</gml:outerBoundaryIs>");
            sb.append("</gml:Polygon>");
            sb.append("</Intersects></Filter>");
            return (Filter)Unmarshaller.unmarshal(Filter.class, (Reader)new StringReader(sb.toString()));
        }
        throw new UnsupportedOperationException("Given Feature not supported");
    }

    public static nl.b3p.xml.wfs.Filter createQueryFilter(nl.b3p.xml.wfs.GetFeature gf, String query, String srsName, FeatureType feature) throws Exception {
        org.opengis.filter.Filter filter = CQL.toFilter((String)query);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Encoder encoder = new Encoder((Configuration)new OGCConfiguration());
        QName name = new QName("http://www.opengis.net/ogc", "Filter");
        encoder.encode((Object)filter, name, (OutputStream)baos);
        String s = baos.toString();
        if (feature instanceof nl.b3p.xml.wfs.v100.capabilities.FeatureType) {
            return (nl.b3p.xml.ogc.v100.Filter)Unmarshaller.unmarshal(nl.b3p.xml.ogc.v100.Filter.class, (Reader)new StringReader(s));
        }
        if (feature instanceof nl.b3p.xml.wfs.v110.FeatureType) {
            return (Filter)Unmarshaller.unmarshal(Filter.class, (Reader)new StringReader(s));
        }
        throw new UnsupportedOperationException("Given Feature not supported");
    }

    public static void addPropertyIsEqualToFilter(nl.b3p.xml.wfs.GetFeature gf, String propertyName, String compareValue) {
        if (gf instanceof GetFeature) {
            nl.b3p.xml.wfs.Filter filter = OgcWfsClient.createPropertyIsEqualToFilter(propertyName, compareValue, "1.0.0");
            ((GetFeature)gf).getQuery(0).setFilter((nl.b3p.xml.ogc.v100.Filter)filter);
        } else if (gf instanceof nl.b3p.xml.wfs.v110.GetFeature) {
            nl.b3p.xml.wfs.Filter filter = OgcWfsClient.createPropertyIsEqualToFilter(propertyName, compareValue, "1.1.0");
            ((nl.b3p.xml.wfs.v110.GetFeature)gf).getQuery(0).setFilter((Filter)filter);
        }
    }

    private static nl.b3p.xml.wfs.Filter createPropertyIsEqualToFilter(String propertyName, String compareValue, String version) {
        if (version.equalsIgnoreCase("1.0.0")) {
            nl.b3p.xml.ogc.v100.Filter filter = new nl.b3p.xml.ogc.v100.Filter();
            nl.b3p.xml.ogc.v100.PropertyIsEqualTo piet = new nl.b3p.xml.ogc.v100.PropertyIsEqualTo();
            PropertyName pn = new PropertyName();
            nl.b3p.xml.ogc.v100.Literal l = new nl.b3p.xml.ogc.v100.Literal();
            if (propertyName.contains(":")) {
                propertyName = propertyName.replaceAll("ms:", "");
            }
            pn.setContent(propertyName);
            l.setContent(compareValue);
            piet.setPropertyName(pn);
            piet.setLiteral(l);
            filter.setPropertyIsEqualTo(piet);
            return filter;
        }
        if (version.equalsIgnoreCase("1.1.0")) {
            Filter filter = new Filter();
            PropertyIsEqualTo piet = new PropertyIsEqualTo();
            nl.b3p.xml.ogc.v110.PropertyName pn = new nl.b3p.xml.ogc.v110.PropertyName();
            Literal l = new Literal();
            pn.setContent(propertyName);
            l.setContent(compareValue);
            piet.setPropertyName(pn);
            piet.setLiteral(l);
            filter.setPropertyIsEqualTo(piet);
            return filter;
        }
        throw new UnsupportedOperationException("Given Version not supported: " + version);
    }

    public static ArrayList getFeatureElements(nl.b3p.xml.wfs.GetFeature gf, OGCRequest or) throws Exception {
        ArrayList<Object> returnList = new ArrayList<Object>();
        Element elem = OgcWfsClient.doRequest(gf, or.getUrlWithNonOGCparams(), or.getNameSpaces(), or.getUsername(), or.getPassword());
        String outputFormat = gf.getOutputFormat();
        String version = "";
        if (gf instanceof GetFeature) {
            version = "1.0.0";
        } else if (gf instanceof nl.b3p.xml.wfs.v110.GetFeature) {
            version = "1.1.0";
        }
        int gmlVersion = 2;
        if ("1.1.0".equals(version) && outputFormat != null && !"GML2".equalsIgnoreCase(outputFormat) && outputFormat.indexOf("gml/2") == -1) {
            gmlVersion = 3;
        }
        GMLConfiguration configGml2 = null;
        configGml2 = new GMLConfiguration();
        configGml2.getContext().registerComponentInstance((Object)new XSDSchemaLocationResolver(){

            public String resolveSchemaLocation(XSDSchema xsds, String string, String string1) {
                return "dummy";
            }
        });
        org.geotools.gml3.GMLConfiguration configGml3 = null;
        configGml3 = new org.geotools.gml3.GMLConfiguration();
        configGml3.getContext().registerComponentInstance((Object)new XSDSchemaLocationResolver(){

            public String resolveSchemaLocation(XSDSchema xsds, String string, String string1) {
                return "dummy";
            }
        });
        Parser parser = null;
        parser = gmlVersion == 2 ? new Parser((Configuration)configGml2) : new Parser((Configuration)configGml3);
        Object o = null;
        try {
            o = parser.parse((Reader)new StringReader(OgcWfsClient.elementToString(elem)));
        }
        catch (Exception ex) {
            log.warn((Object)("GML version " + gmlVersion + " not correct. Trying other version:"), (Throwable)ex);
            parser = gmlVersion == 2 ? new Parser((Configuration)configGml3) : new Parser((Configuration)configGml2);
            try {
                o = parser.parse((Reader)new StringReader(OgcWfsClient.elementToString(elem)));
            }
            catch (Exception ex2) {
                log.error((Object)"No GML version correct. Giving up...", (Throwable)ex2);
                throw new Exception("No suitable GML parser found", ex2);
            }
        }
        FeatureCollection fc = null;
        if (o instanceof FeatureCollection) {
            fc = (FeatureCollection)o;
            returnList.addAll(fc.getFeatures());
        } else if (o instanceof HashMap) {
            Object l = ((HashMap)o).get("featureMember");
            if (l instanceof List) {
                returnList.addAll((List)l);
            } else if (l instanceof Feature) {
                returnList.add(l);
            }
        } else if (o instanceof DefaultFeatureCollection) {
            DefaultFeatureCollection dfc = (DefaultFeatureCollection)o;
            Object[] featureArray = dfc.toArray();
            for (int i = 0; i < featureArray.length; ++i) {
                returnList.add(featureArray[i]);
            }
        } else if (o instanceof Envelope) {
            log.debug((Object)"no features found");
        } else {
            throw new UnsupportedOperationException("Can not make returnList from " + o.getClass());
        }
        return returnList;
    }

    protected static Element readXml2Element(Reader src) throws Exception {
        Document doc = null;
        InputSource ips = new InputSource(src);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(ips);
        return doc.getDocumentElement();
    }

    public static String elementToString(Element e) throws Exception {
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        DOMSource ds = new DOMSource(e);
        trans.transform(ds, sr);
        return sw.toString();
    }

    public static AnyNode xmlStringToAnyNode(String xml) throws Exception {
        AnyNode anyNode = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            SAX2ANY handler = new SAX2ANY();
            IgnoreEntityResolver r = new IgnoreEntityResolver();
            reader.setEntityResolver((EntityResolver)r);
            reader.setContentHandler((ContentHandler)handler);
            reader.setErrorHandler((ErrorHandler)handler);
            InputSource source = new InputSource(new StringReader(xml));
            reader.parse(source);
            anyNode = handler.getStartingNode();
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
        }
        return anyNode;
    }

    private static List extractHttpMethodsAllowed(WFS_Capabilities cap, String requestName) {
        ArrayList<String> methodsAllowed;
        block29: {
            nl.b3p.xml.wfs.v110.WFS_Capabilities cap110;
            block28: {
                methodsAllowed = new ArrayList<String>();
                if (!(cap instanceof nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities)) break block28;
                nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities cap100 = (nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities)cap;
                for (int i = 0; i < cap100.getCapability().getRequest().getRequestTypeItemCount(); ++i) {
                    int i3;
                    HTTP http;
                    int i2;
                    DCPTypeType[] requestDcpTypes;
                    RequestTypeItem rti = cap100.getCapability().getRequest().getRequestTypeItem(i);
                    if ("DescribeFeatureType".equalsIgnoreCase(requestName)) {
                        if (rti.getDescribeFeatureType() == null) continue;
                        requestDcpTypes = rti.getDescribeFeatureType().getDCPType_DescribeFeatureTypeType();
                        for (i2 = 0; i2 < requestDcpTypes.length; ++i2) {
                            http = requestDcpTypes[i2].getHTTP();
                            for (i3 = 0; i3 < http.getHTTPTypeItemCount(); ++i3) {
                                if (http.getHTTPTypeItem(i3).getGet() != null) {
                                    methodsAllowed.add(GETMETHOD);
                                }
                                if (http.getHTTPTypeItem(i3).getPost() == null) continue;
                                methodsAllowed.add(POSTMETHOD);
                            }
                        }
                        continue;
                    }
                    if ("GetCapabilities".equalsIgnoreCase(requestName)) {
                        if (rti.getGetCapabilities() == null) continue;
                        requestDcpTypes = rti.getGetCapabilities().getDCPType_GetCapabilitiesType();
                        for (i2 = 0; i2 < requestDcpTypes.length; ++i2) {
                            http = requestDcpTypes[i2].getHTTP();
                            for (i3 = 0; i3 < http.getHTTPTypeItemCount(); ++i3) {
                                if (http.getHTTPTypeItem(i3).getGet() != null) {
                                    methodsAllowed.add(GETMETHOD);
                                }
                                if (http.getHTTPTypeItem(i3).getPost() == null) continue;
                                methodsAllowed.add(POSTMETHOD);
                            }
                        }
                        continue;
                    }
                    if ("GetFeature".equalsIgnoreCase(requestName)) {
                        if (rti.getGetFeature() == null) continue;
                        requestDcpTypes = rti.getGetFeature().getDCPType_FeatureTypeType();
                        for (i2 = 0; i2 < requestDcpTypes.length; ++i2) {
                            http = requestDcpTypes[i2].getHTTP();
                            for (i3 = 0; i3 < http.getHTTPTypeItemCount(); ++i3) {
                                if (http.getHTTPTypeItem(i3).getGet() != null) {
                                    methodsAllowed.add(GETMETHOD);
                                }
                                if (http.getHTTPTypeItem(i3).getPost() == null) continue;
                                methodsAllowed.add(POSTMETHOD);
                            }
                        }
                        continue;
                    }
                    if ("Transaction".equalsIgnoreCase(requestName)) {
                        if (rti.getTransaction() == null) continue;
                        requestDcpTypes = rti.getTransaction().getDCPType_TransactionType();
                        for (i2 = 0; i2 < requestDcpTypes.length; ++i2) {
                            http = requestDcpTypes[i2].getHTTP();
                            for (i3 = 0; i3 < http.getHTTPTypeItemCount(); ++i3) {
                                if (http.getHTTPTypeItem(i3).getGet() != null) {
                                    methodsAllowed.add(GETMETHOD);
                                }
                                if (http.getHTTPTypeItem(i3).getPost() == null) continue;
                                methodsAllowed.add(POSTMETHOD);
                            }
                        }
                        continue;
                    }
                    if ("GetFeatureWithLock".equalsIgnoreCase(requestName)) {
                        if (rti.getGetFeatureWithLock() == null) continue;
                        requestDcpTypes = rti.getGetFeatureWithLock().getDCPType_FeatureTypeType();
                        for (i2 = 0; i2 < requestDcpTypes.length; ++i2) {
                            http = requestDcpTypes[i2].getHTTP();
                            for (i3 = 0; i3 < http.getHTTPTypeItemCount(); ++i3) {
                                if (http.getHTTPTypeItem(i3).getGet() != null) {
                                    methodsAllowed.add(GETMETHOD);
                                }
                                if (http.getHTTPTypeItem(i3).getPost() == null) continue;
                                methodsAllowed.add(POSTMETHOD);
                            }
                        }
                        continue;
                    }
                    if (!"LockFeature".equalsIgnoreCase(requestName) || rti.getLockFeature() == null) continue;
                    requestDcpTypes = rti.getLockFeature().getDCPType();
                    for (i2 = 0; i2 < requestDcpTypes.length; ++i2) {
                        http = requestDcpTypes[i2].getHTTP();
                        for (i3 = 0; i3 < http.getHTTPTypeItemCount(); ++i3) {
                            if (http.getHTTPTypeItem(i3).getGet() != null) {
                                methodsAllowed.add(GETMETHOD);
                            }
                            if (http.getHTTPTypeItem(i3).getPost() == null) continue;
                            methodsAllowed.add(POSTMETHOD);
                        }
                    }
                }
                break block29;
            }
            if (!(cap instanceof nl.b3p.xml.wfs.v110.WFS_Capabilities) || (cap110 = (nl.b3p.xml.wfs.v110.WFS_Capabilities)cap).getOperationsMetadata() == null) break block29;
            OperationsMetadata metadata = cap110.getOperationsMetadata();
            for (int i = 0; i < metadata.getOperationCount(); ++i) {
                if (!requestName.equalsIgnoreCase(metadata.getOperation(i).getName())) continue;
                for (int i2 = 0; i2 < metadata.getOperation(i).getDCPCount(); ++i2) {
                    DCP dcp = metadata.getOperation(i).getDCP(i2);
                    if (dcp.getHTTP() == null) continue;
                    for (int i3 = 0; i3 < dcp.getHTTP().getHTTPItemCount(); ++i3) {
                        HTTPItem httpitem = dcp.getHTTP().getHTTPItem(i3);
                        if (httpitem.getPost() != null) {
                            methodsAllowed.add(POSTMETHOD);
                        }
                        if (httpitem.getGet() == null) continue;
                        methodsAllowed.add(GETMETHOD);
                    }
                }
            }
        }
        return methodsAllowed;
    }

    public static void addCombinedAndFilter(nl.b3p.xml.wfs.GetFeature gf, FeatureType ft, nl.b3p.xml.wfs.Filter queryFilter, nl.b3p.xml.wfs.Filter geomFilter) throws Exception {
        Serializable combinedFilter = null;
        String geomFilterString = OgcWfsClient.removeFilterTags(geomFilter);
        String queryFilterString = OgcWfsClient.removeFilterTags(queryFilter);
        StringBuffer sb = new StringBuffer();
        sb.append("<Filter><And>");
        sb.append(geomFilterString);
        sb.append(queryFilterString);
        sb.append("</And></Filter>");
        String filter = sb.toString();
        if (ft instanceof nl.b3p.xml.wfs.v100.capabilities.FeatureType) {
            combinedFilter = (nl.b3p.xml.ogc.v100.Filter)Unmarshaller.unmarshal(nl.b3p.xml.ogc.v100.Filter.class, (Reader)new StringReader(filter));
            ((GetFeature)gf).getQuery(0).setFilter((nl.b3p.xml.ogc.v100.Filter)combinedFilter);
        } else if (ft instanceof nl.b3p.xml.wfs.v110.FeatureType) {
            combinedFilter = (Filter)Unmarshaller.unmarshal(Filter.class, (Reader)new StringReader(filter));
            ((nl.b3p.xml.wfs.v110.GetFeature)gf).getQuery(0).setFilter((Filter)combinedFilter);
        } else {
            throw new UnsupportedOperationException("Given Feature not supported");
        }
    }

    public static String removeFilterTags(nl.b3p.xml.wfs.Filter filter) throws MarshalException, ValidationException {
        String filterString = "";
        StringWriter sw = new StringWriter();
        Marshaller.marshal((Object)filter, (Writer)sw);
        String tempString = sw.toString();
        String[] tempArray = tempString.split("<");
        for (int i = 0; i < tempArray.length; ++i) {
            if (tempArray[i].equals("") || tempArray[i].startsWith("Filter") || tempArray[i].startsWith("/Filter") || tempArray[i].startsWith("?xml")) continue;
            filterString = filterString + "<" + tempArray[i];
        }
        return filterString;
    }
}

