/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.b3p.ogc.utils.OGCConstants;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCResponse;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.xml.wfs.v100.FeatureCollection;
import nl.b3p.xml.wfs.v110.FeatureCollectionType;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFSGetFeatureResponse
extends OGCResponse
implements OGCConstants {
    private final List featureCollectionV100 = new ArrayList();
    private final List featureCollectionV110 = new ArrayList();

    protected void replaceFeatureTypeName(Element elem, String spAbbr) throws Exception {
        String wfsPrefix = this.getNameSpacePrefix("http://www.opengis.net/wfs", true);
        String gmlPrefix = this.getNameSpacePrefix("http://www.opengis.net/gml", true);
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        if (wfsPrefix != null && wfsPrefix.length() > 0) {
            sb.append(wfsPrefix);
            sb.append(":");
        }
        sb.append("FeatureCollection/");
        if (gmlPrefix != null && gmlPrefix.length() > 0) {
            sb.append(gmlPrefix);
            sb.append(":");
        }
        sb.append("featureMember");
        NodeList nodes = this.getNodeListFromXPath(elem, sb.toString());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            for (Node cn = n.getFirstChild(); cn != null; cn = cn.getNextSibling()) {
                if (cn.getNodeType() != 1) continue;
                String cn_ns = cn.getNamespaceURI();
                String oldName = null;
                oldName = cn_ns != null && cn_ns.length() > 0 ? "{" + cn_ns + "}" + cn.getLocalName() : cn.getLocalName();
                String newName = this.determineFeatureTypeName(spAbbr, oldName);
                Element e = elem.getOwnerDocument().createElementNS(cn_ns, newName);
                n.appendChild(e);
                if (!(cn instanceof DeferredElementNSImpl) && !(cn instanceof Element)) continue;
                Element e2 = (Element)cn;
                NodeList childs = e2.getChildNodes();
                for (int j = 0; j < childs.getLength(); ++j) {
                    Node child = childs.item(j);
                    Node tempNode = child.cloneNode(true);
                    e.appendChild(tempNode);
                }
                n.replaceChild(e, cn);
            }
        }
    }

    @Override
    public void rebuildResponse(Document doc, OGCRequest request, String prefix) throws Exception {
        Element element = doc.getDocumentElement();
        this.httpHost = request.getUrlWithNonOGCparams();
        this.findNameSpace(doc);
        this.version = request.getFinalVersion();
        if (this.version != null && this.version.equalsIgnoreCase("1.0.0")) {
            this.replaceFeatureTypeName(element, prefix);
            Unmarshaller um = new Unmarshaller(FeatureCollection.class);
            Object o = um.unmarshal((Node)element);
            FeatureCollection featureCollection = (FeatureCollection)o;
            this.featureCollectionV100.add(this.replaceFeatureCollectionV100Url(featureCollection, prefix));
        } else {
            this.replaceFeatureTypeName(element, prefix);
            Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v110.FeatureCollection.class);
            Object o = um.unmarshal((Node)element);
            nl.b3p.xml.wfs.v110.FeatureCollection featureCollection = (nl.b3p.xml.wfs.v110.FeatureCollection)o;
            this.featureCollectionV110.add(this.replaceFeatureCollectionV110Url(featureCollection, prefix));
        }
    }

    public String changeLocation(String location, String serverPrefix) {
        String newSchemalocations = "";
        String[] tokens = location.split(" ");
        for (int x = 0; x < tokens.length; ++x) {
            String[] token = tokens[x].split("\\?", 2);
            if (token.length == 2) {
                String kvp = token[1];
                String newToken = "";
                String[] kvpSplit = kvp.split("\\&");
                for (int z = 0; z < kvpSplit.length; ++z) {
                    String[] newKvp = kvpSplit[z].split("=");
                    if (newKvp[0].equals("TYPENAME")) {
                        String changedlayer = WFSGetFeatureResponse.attachSp(serverPrefix, newKvp[1]);
                        newToken = newToken + "&" + newKvp[0] + "=" + changedlayer;
                        continue;
                    }
                    newToken = newToken + "&" + kvpSplit[z];
                }
                if (x != 0) {
                    newSchemalocations = newSchemalocations + " " + this.httpHost + newToken;
                    continue;
                }
                newSchemalocations = newSchemalocations + this.httpHost + newToken;
                continue;
            }
            newSchemalocations = x != 0 ? newSchemalocations + " " + token[0] : newSchemalocations + token[0];
        }
        return newSchemalocations;
    }

    public FeatureCollection replaceFeatureCollectionV100Url(FeatureCollection featureCollection, String serverPrefix) {
        String newSchemalocations = "";
        if (this.getSchemaLocations() != null) {
            Set keys = this.getSchemaLocations().keySet();
            Iterator it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                String prefix = (String)it.next();
                String location = (String)this.getSchemaLocations().get(prefix);
                newSchemalocations = this.changeLocation(location, serverPrefix);
                this.addOrReplaceSchemaLocation(prefix, newSchemalocations);
                ++i;
            }
        }
        return featureCollection;
    }

    public nl.b3p.xml.wfs.v110.FeatureCollection replaceFeatureCollectionV110Url(nl.b3p.xml.wfs.v110.FeatureCollection featureCollection, String serverPrefix) {
        String newSchemalocations = "";
        if (this.getSchemaLocations() != null) {
            Set keys = this.getSchemaLocations().keySet();
            Iterator it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                String prefix = (String)it.next();
                String location = (String)this.getSchemaLocations().get(prefix);
                newSchemalocations = this.changeLocation(location, serverPrefix);
                this.addOrReplaceSchemaLocation(prefix, newSchemalocations);
                ++i;
            }
        }
        return featureCollection;
    }

    @Override
    public String getResponseBody(List<SpLayerSummary> layers, OGCRequest ogcrequest, String encoding) {
        Serializable castorObject = null;
        Object o = this.mergeFeatureCollection();
        if (!this.isUsableResponse()) {
            if (this.hasWfsV100ErrorResponse()) {
                return this.getWfsV100ErrorResponseBody(encoding);
            }
            if (this.hasOwsV100ErrorResponse()) {
                return this.getOwsV100ErrorResponseBody(encoding);
            }
            throw new UnsupportedOperationException("Failed to get suitable reponse! ");
        }
        if (this.hasWfsV100ErrorResponse()) {
            this.logErrorResponse(encoding);
        }
        castorObject = this.version.equals("1.0.0") ? (FeatureCollection)o : (nl.b3p.xml.wfs.v110.FeatureCollection)o;
        return this.marshalObject(castorObject, encoding);
    }

    public Object mergeFeatureCollection() {
        if (this.version.equals("1.1.0")) {
            FeatureCollectionType featureCollection = null;
            Iterator it = this.featureCollectionV110.iterator();
            int i = 0;
            int featureCount = 0;
            while (it.hasNext()) {
                nl.b3p.xml.wfs.v110.FeatureCollection newFeatureCollection = (nl.b3p.xml.wfs.v110.FeatureCollection)it.next();
                if (i == 0) {
                    featureCollection = newFeatureCollection;
                    featureCount = newFeatureCollection.getFeatureMemberCount();
                    ++i;
                } else {
                    featureCount += newFeatureCollection.getFeatureMemberCount();
                    Object[] o = newFeatureCollection.getFeatureMember();
                    for (int x = 0; x < o.length; ++x) {
                        Object featureMember = o[x];
                        featureCollection.addFeatureMember(featureMember);
                    }
                    ++i;
                }
                this.setUsableResponse(true);
            }
            if (featureCollection != null) {
                featureCollection.setNumberOfFeatures(featureCount);
            }
            return featureCollection;
        }
        FeatureCollection featureCollection = null;
        Iterator it = this.featureCollectionV100.iterator();
        int i = 0;
        int featureCount = 0;
        while (it.hasNext()) {
            FeatureCollection newFeatureCollection = (FeatureCollection)it.next();
            if (i == 0) {
                featureCollection = newFeatureCollection;
                featureCount = newFeatureCollection.getFeatureMemberCount();
                ++i;
            } else {
                featureCount += newFeatureCollection.getFeatureMemberCount();
                Object[] o = newFeatureCollection.getFeatureMember();
                for (int x = 0; x < o.length; ++x) {
                    Object featureMember = o[x];
                    featureCollection.addFeatureMember(featureMember);
                }
                ++i;
            }
            this.setUsableResponse(true);
        }
        return featureCollection;
    }
}

