/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class KBConfiguration {
    public static boolean METADATA_ENABLED = true;
    public static String SERVICE_NAME = "OGC:WMS";
    public static String SERVICE_TITLE = "Kaartenbalie Map Portal";
    public static String SERVICE_ABSTRACT = "Controlled access to OGC WMS maps. See B3P GIS at http://www.b3partners.nl/";
    public static String SERVICE_FEES = "None";
    public static String SERVICE_CONSTRAINTS = "None";
    public static String CONTACT_PERSON = "Chris van Lith";
    public static String CONTACT_POSITION = "Partner";
    public static String CONTACT_ORGANIZATION = "B3Partners";
    public static String CONTACT_ADDRESS = "Zonnebaan 12C";
    public static String CONTACT_ADDRESS_TYPE = "Postal";
    public static String CONTACT_POSTCODE = "3542 EC";
    public static String CONTACT_CITY = "Utrecht";
    public static String CONTACT_STATE_OR_PROVINCE = "Utrecht";
    public static String CONTACT_COUNTRY = "The Netherlands";
    public static String CONTACT_VOICETELEPHONE = "+31 30 214 20 81";
    public static String CONTACT_FASCIMILEPHONE = "";
    public static String CONTACT_EMAIL = "info@b3partners.nl";
    public static String CONTACT_WEBSITE = "http://www.b3partners.nl/";
    public static String SERVICEPROVIDER_NAME = "OGC:WMS";
    public static String SERVICEPROVIDER_TITLE = "Kaartenbalie WMS Portal";
    public static String SERVICEPROVIDER_ABSTRACT = "Controlled access to OGC WMS maps. See B3P GIS at http://www.b3partners.nl/";
    public static String SERVICEPROVIDER_FEES = "none";
    public static String SERVICEPROVIDER_ACCESSCONSTRAINTS = "none";
    public static String TOPLAYERNAME = "B3P Kaartenbalie";
    public static String KB_USER = "user";
    public static String KB_PERSONAL_URL = "personalURL";
    public static String KB_DEFAULT_ROLE = "gebruiker";
    public static String KB_PROXY = "proxy";
    public static String KB_ENCRYPT_KEY = "proxy007";
    public static String KB_PROXY_EXECPTION = "Kaartenbalie Proxy fout: parameter purl niet gevonden.";
    public static String KB_SERVICES_CONTEXT_PATH = "";
    public static String KB_SERVICES_SERVER_URI = "";
    public static String KB_SERVICES_INTERNAL_CONTEXT_PATH = "";
    public static String KB_SERVICES_INTERNAL_SERVER_URI = "";
    public static String GETMAP_EXCEPTION = "Kaartenbalie GetMap fout: Ongeldige kaartlaag in de LAYERS parameter, update uw service providers in Kaartenbalie";
    public static String REQUEST_NORIGHTS_EXCEPTION = "Kaartenbalie request fout: Ongeldige kaartlaag in de LAYERS parameter, u heeft geen rechten op de kaart";
    public static String REQUEST_DUPLICATE_EXCEPTION = "Kaartenbalie request fout: De gevraagde kaartlaag komt meerdere keren voor";
    public static String REQUEST_QUERYABLE_EXCEPTION = "Kaartenbalie request fout: Gevraagde kaartlaag is niet queryable.";
    public static String REQUEST_LAYERNAME_EXCEPTION = "Kaartenbalie request fout: De naam van de kaartlaag is onjuist opgebouwd";
    public static String FEATUREINFO_EXCEPTION = "Kaartenbalie GetFeatureInfo fout: Ongeldige kaartlaag in de LAYERS parameter, update uw service providers in Kaartenbalie.";
    public static String FEATUREINFO_QUERYABLE_EXCEPTION = "Kaartenbalie GetFeatureInfo fout: Gevraagde kaartlaag is niet queryable.";
    public static String LEGENDGRAPHIC_EXCEPTION = "Kaartenbalie GetLegendGraphic fout: Ongeldige kaartlaag in de LAYERS parameter, update uw service providers in Kaartenbalie.";
    public static String IMAGE_SIZE_EXCEPTION = "Kaartenbalie GetMap fout: afbeelding WIDTH and HEIGHT moet tussen 1 en 2048 pixels zijn.";
    public static String BBOX_EXCEPTION = "Kaartenbalie GetMap fout: Ongeldige BBOX waarden.";
    public static String SRS_EXCEPTION = "Kaartenbalie GetMap fout: SRS moet geldig zijn voor alle kaartlagen.";
    public static String UNSUPPORTED_VERSION = "Opgegeven VERSION wordt niet ondersteund door Kaartenbalie";
    public static String UNSUPPORTED_SERVICE = "Opgegeven SERVICE wordt niet ondersteund door Kaartenbalie";
    public static String UNSUPPORTED_REQUEST = "Opgegeven REQUEST is niet geldig voor het ophalen van een GetCapability";
    public static String MESSAGE_TITLE_LAYER = "B3P Kaartenbalie";
    public static String MESSAGE_TITLE_BALANCE = "Tegoed: ";
    public static String MESSAGE_TITLE_CREDITS = "Kosten: ";
    public static String MESSAGE_TITLE_UNIT = "c";
    public static String MESSAGE_AUTHORIZATION_INTRO = "Een of meer van de door u opgevraagde kaarten vereisen autorisatie voor het afboeken van het credittegoed. ";
    public static String MESSAGE_AUTHORIZATION_START = "Vink hiertoe de goedkeuringskaart '";
    public static String MESSAGE_AUTHORIZATION_END = "' aan.\n";
    public static String MESSAGE_NO_DISPLAY_AGAIN = "Hierna zal de kaart worden getoond en dit bericht niet meer weergegeven worden.\n";
    public static String MESSAGE_REQUIRED_CREDITS = "Het aantal benodigde credits voor deze kaart bedraagt:\n ";
    public static final String[] ACCOUNTING_WMS_REQUESTS = new String[]{"GetMap", "GetFeatureInfo", "GetLegendGraphic"};
    public static final String[] ACCOUNTING_WFS_REQUESTS = new String[]{"GetFeature", "DescribeFeatureType"};
    public static String SERVICEPROVIDER_BASE_ABBR = "b3p";
    public static String SERVICEPROVIDER_BASE_HTTP = "http://layering.kaartenbalie.nl/";
    public static String[] SUPPORTED_PROJECTIONS = new String[]{"EPSG:28992", "EPSG:4326"};
    public static String DEFAULT_PROJECTION = "EPSG:28992";
    public static final String CHARSET = "UTF-8";
    public static final String MD_ALGORITHM = "MD5";
    public static Font OHD_messageBoxFont = new Font("monospaced", 0, 12);
    public static Color OHD_labelBoxColor = new Color(255, 240, 196, 150);
    public static Color OHD_labelFontBoxColor = new Color(25, 98, 153);
    public static Color OHD_fontBoxColor = new Color(255, 240, 196);
    public static Color OHD_borderBoxTopLeft = new Color(88, 169, 228);
    public static Color OHD_borderBoxBottomRight = new Color(20, 82, 126);
    public static Color OHD_borderBoxBackground = new Color(25, 98, 153, 150);
    public static int OHD_padding = 2;
    public static int OHD_lineSpacing = 6;
    private static final String SUFFIX = ".properties";
    private static final String KBCONFIG = "kbconfig";
    public static boolean SAVE_MESSAGES = false;
    public static String RESPONSE_SIZE_LIMIT = "0";
    public static String WFS_RESPONSE_TIME_LIMIT = "300000";
    public static String WMS_RESPONSE_TIME_LIMIT = "10000";

    public static void configure() {
        KBConfiguration.configure(KBCONFIG);
    }

    public static void configure(String kbcprop) {
        Properties prop = KBConfiguration.loadProperties(kbcprop);
        BBOX_EXCEPTION = prop.getProperty("BBOX_EXCEPTION", BBOX_EXCEPTION);
        CONTACT_ADDRESS = prop.getProperty("CONTACT_ADDRESS", CONTACT_ADDRESS);
        CONTACT_ADDRESS_TYPE = prop.getProperty("CONTACT_ADDRESS_TYPE", CONTACT_ADDRESS_TYPE);
        CONTACT_CITY = prop.getProperty("CONTACT_CITY", CONTACT_CITY);
        CONTACT_COUNTRY = prop.getProperty("CONTACT_COUNTRY", CONTACT_COUNTRY);
        CONTACT_EMAIL = prop.getProperty("CONTACT_EMAIL", CONTACT_EMAIL);
        CONTACT_FASCIMILEPHONE = prop.getProperty("CONTACT_FASCIMILEPHONE", CONTACT_FASCIMILEPHONE);
        CONTACT_ORGANIZATION = prop.getProperty("CONTACT_ORGANIZATION", CONTACT_ORGANIZATION);
        CONTACT_PERSON = prop.getProperty("CONTACT_PERSON", CONTACT_PERSON);
        CONTACT_POSITION = prop.getProperty("CONTACT_POSITION", CONTACT_POSITION);
        CONTACT_POSTCODE = prop.getProperty("CONTACT_POSTCODE", CONTACT_POSTCODE);
        CONTACT_STATE_OR_PROVINCE = prop.getProperty("CONTACT_STATE_OR_PROVINCE", CONTACT_STATE_OR_PROVINCE);
        CONTACT_VOICETELEPHONE = prop.getProperty("CONTACT_VOICETELEPHONE", CONTACT_VOICETELEPHONE);
        CONTACT_WEBSITE = prop.getProperty("CONTACT_WEBSITE", CONTACT_WEBSITE);
        DEFAULT_PROJECTION = prop.getProperty("DEFAULT_PROJECTION", DEFAULT_PROJECTION);
        FEATUREINFO_EXCEPTION = prop.getProperty("FEATUREINFO_EXCEPTION", FEATUREINFO_EXCEPTION);
        FEATUREINFO_QUERYABLE_EXCEPTION = prop.getProperty("FEATUREINFO_QUERYABLE_EXCEPTION", FEATUREINFO_QUERYABLE_EXCEPTION);
        GETMAP_EXCEPTION = prop.getProperty("GETMAP_EXCEPTION", GETMAP_EXCEPTION);
        REQUEST_QUERYABLE_EXCEPTION = prop.getProperty("REQUEST_QUERYABLE_EXCEPTION", REQUEST_QUERYABLE_EXCEPTION);
        IMAGE_SIZE_EXCEPTION = prop.getProperty("IMAGE_SIZE_EXCEPTION", IMAGE_SIZE_EXCEPTION);
        KB_DEFAULT_ROLE = prop.getProperty("KB_DEFAULT_ROLE", KB_DEFAULT_ROLE);
        KB_PROXY = prop.getProperty("KB_PROXY", KB_PROXY);
        KB_PROXY_EXECPTION = prop.getProperty("KB_PROXY_EXECPTION", KB_PROXY_EXECPTION);
        KB_ENCRYPT_KEY = prop.getProperty("KB_PROXY_KEY", KB_ENCRYPT_KEY);
        KB_SERVICES_CONTEXT_PATH = prop.getProperty("KB_SERVICES_CONTEXT_PATH", KB_SERVICES_CONTEXT_PATH);
        KB_SERVICES_SERVER_URI = prop.getProperty("KB_SERVICES_SERVER_URI", KB_SERVICES_SERVER_URI);
        KB_SERVICES_INTERNAL_CONTEXT_PATH = prop.getProperty("KB_SERVICES_INTERNAL_CONTEXT_PATH", KB_SERVICES_INTERNAL_CONTEXT_PATH);
        KB_SERVICES_INTERNAL_SERVER_URI = prop.getProperty("KB_SERVICES_INTERNAL_SERVER_URI", KB_SERVICES_INTERNAL_SERVER_URI);
        LEGENDGRAPHIC_EXCEPTION = prop.getProperty("LEGENDGRAPHIC_EXCEPTION", LEGENDGRAPHIC_EXCEPTION);
        MESSAGE_AUTHORIZATION_END = prop.getProperty("MESSAGE_AUTHORIZATION_END", MESSAGE_AUTHORIZATION_END);
        MESSAGE_AUTHORIZATION_INTRO = prop.getProperty("MESSAGE_AUTHORIZATION_INTRO", MESSAGE_AUTHORIZATION_INTRO);
        MESSAGE_AUTHORIZATION_START = prop.getProperty("MESSAGE_AUTHORIZATION_START", MESSAGE_AUTHORIZATION_START);
        MESSAGE_NO_DISPLAY_AGAIN = prop.getProperty("MESSAGE_NO_DISPLAY_AGAIN", MESSAGE_NO_DISPLAY_AGAIN);
        MESSAGE_REQUIRED_CREDITS = prop.getProperty("MESSAGE_REQUIRED_CREDITS", MESSAGE_REQUIRED_CREDITS);
        MESSAGE_TITLE_BALANCE = prop.getProperty("MESSAGE_TITLE_BALANCE", MESSAGE_TITLE_BALANCE);
        MESSAGE_TITLE_CREDITS = prop.getProperty("MESSAGE_TITLE_CREDITS", MESSAGE_TITLE_CREDITS);
        MESSAGE_TITLE_LAYER = prop.getProperty("MESSAGE_TITLE_LAYER", MESSAGE_TITLE_LAYER);
        MESSAGE_TITLE_UNIT = prop.getProperty("MESSAGE_TITLE_UNIT", MESSAGE_TITLE_UNIT);
        OHD_borderBoxBackground = KBConfiguration.getColorFromProperties(prop, "OHD_borderBoxBackground", OHD_borderBoxBackground);
        OHD_borderBoxBottomRight = KBConfiguration.getColorFromProperties(prop, "OHD_borderBoxBottomRight", OHD_borderBoxBottomRight);
        OHD_borderBoxTopLeft = KBConfiguration.getColorFromProperties(prop, "OHD_borderBoxTopLeft", OHD_borderBoxTopLeft);
        OHD_fontBoxColor = KBConfiguration.getColorFromProperties(prop, "OHD_fontBoxColor", OHD_fontBoxColor);
        OHD_labelBoxColor = KBConfiguration.getColorFromProperties(prop, "OHD_labelBoxColor", OHD_labelBoxColor);
        OHD_labelFontBoxColor = KBConfiguration.getColorFromProperties(prop, "OHD_labelFontBoxColor", OHD_labelFontBoxColor);
        String tOHD_lineSpacing = prop.getProperty("OHD_lineSpacing");
        try {
            int i;
            OHD_lineSpacing = i = Integer.parseInt(tOHD_lineSpacing);
        }
        catch (NumberFormatException i) {
            // empty catch block
        }
        String tOHD_padding = prop.getProperty("OHD_padding");
        try {
            int i;
            OHD_padding = i = Integer.parseInt(tOHD_padding);
        }
        catch (NumberFormatException i) {
            // empty catch block
        }
        SERVICEPROVIDER_ABSTRACT = prop.getProperty("SERVICEPROVIDER_ABSTRACT", SERVICEPROVIDER_ABSTRACT);
        SERVICEPROVIDER_ACCESSCONSTRAINTS = prop.getProperty("SERVICEPROVIDER_ACCESSCONSTRAINTS", SERVICEPROVIDER_ACCESSCONSTRAINTS);
        SERVICEPROVIDER_BASE_ABBR = prop.getProperty("SERVICEPROVIDER_BASE_ABBR", SERVICEPROVIDER_BASE_ABBR);
        SERVICEPROVIDER_BASE_HTTP = prop.getProperty("SERVICEPROVIDER_BASE_HTTP", SERVICEPROVIDER_BASE_HTTP);
        SERVICEPROVIDER_FEES = prop.getProperty("SERVICEPROVIDER_FEES", SERVICEPROVIDER_FEES);
        SERVICEPROVIDER_NAME = prop.getProperty("SERVICEPROVIDER_NAME", SERVICEPROVIDER_NAME);
        SERVICEPROVIDER_TITLE = prop.getProperty("SERVICEPROVIDER_TITLE", SERVICEPROVIDER_TITLE);
        SERVICE_ABSTRACT = prop.getProperty("SERVICE_ABSTRACT", SERVICE_ABSTRACT);
        SERVICE_CONSTRAINTS = prop.getProperty("SERVICE_CONSTRAINTS", SERVICE_CONSTRAINTS);
        SERVICE_FEES = prop.getProperty("SERVICE_FEES", SERVICE_FEES);
        SERVICE_NAME = prop.getProperty("SERVICE_NAME", SERVICE_NAME);
        SERVICE_TITLE = prop.getProperty("SERVICE_TITLE", SERVICE_TITLE);
        SRS_EXCEPTION = prop.getProperty("SRS_EXCEPTION", SRS_EXCEPTION);
        String tSUPPORTED_PROJECTIONS = prop.getProperty("SUPPORTED_PROJECTIONS");
        if (tSUPPORTED_PROJECTIONS != null && tSUPPORTED_PROJECTIONS.length() != 0) {
            SUPPORTED_PROJECTIONS = tSUPPORTED_PROJECTIONS.split(",");
        }
        TOPLAYERNAME = prop.getProperty("TOPLAYERNAME", TOPLAYERNAME);
        UNSUPPORTED_REQUEST = prop.getProperty("UNSUPPORTED_REQUEST", UNSUPPORTED_REQUEST);
        UNSUPPORTED_SERVICE = prop.getProperty("UNSUPPORTED_SERVICE", UNSUPPORTED_SERVICE);
        UNSUPPORTED_VERSION = prop.getProperty("UNSUPPORTED_VERSION", UNSUPPORTED_VERSION);
        SAVE_MESSAGES = "true".equalsIgnoreCase(prop.getProperty("SAVE_MESSAGES", String.valueOf(SAVE_MESSAGES)));
        RESPONSE_SIZE_LIMIT = prop.getProperty("RESPONSE_SIZE_LIMIT", RESPONSE_SIZE_LIMIT);
        WFS_RESPONSE_TIME_LIMIT = prop.getProperty("WFS_RESPONSE_TIME_LIMIT", WFS_RESPONSE_TIME_LIMIT);
        WMS_RESPONSE_TIME_LIMIT = prop.getProperty("WMS_RESPONSE_TIME_LIMIT", WMS_RESPONSE_TIME_LIMIT);
    }

    protected static Color getColorFromProperties(Properties prop, String name, Color defval) {
        String value = prop.getProperty(name);
        if (value == null) {
            return defval;
        }
        String[] aValue = value.split(",");
        if (aValue.length == 3 || aValue.length == 4) {
            try {
                int r = Integer.parseInt(aValue[0]);
                int g = Integer.parseInt(aValue[1]);
                int b = Integer.parseInt(aValue[2]);
                int a = -1;
                if (aValue.length == 4) {
                    a = Integer.parseInt(aValue[3]);
                }
                if (a == -1) {
                    return new Color(r, g, b);
                }
                return new Color(r, g, b, a);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defval;
    }

    public static Properties loadProperties(String name) {
        return KBConfiguration.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String name, ClassLoader loader) {
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith(SUFFIX)) {
            name = name.substring(0, name.length() - SUFFIX.length());
        }
        Properties result = null;
        InputStream in = null;
        try {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            name = name.replace('/', '.');
            ResourceBundle rb = ResourceBundle.getBundle(name, Locale.getDefault(), loader);
            result = new Properties();
            Enumeration<String> keys = rb.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = rb.getString(key);
                result.put(key, value);
            }
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("could not load [" + name + "] as a resource bundle");
        }
        return result;
    }
}

