/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.wms.capabilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.wms.capabilities.Attribution;
import nl.b3p.wms.capabilities.Dimensions;
import nl.b3p.wms.capabilities.Identifier;
import nl.b3p.wms.capabilities.LayerDomainResource;
import nl.b3p.wms.capabilities.LayerMetadata;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.SrsBoundingBox;
import nl.b3p.wms.capabilities.Style;
import nl.b3p.wms.capabilities.XMLElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Layer
implements XMLElement,
Comparable {
    private static final Log log = LogFactory.getLog(Layer.class);
    private Integer id;
    private String name;
    private String title;
    private String abstracts;
    private String queryable = "0";
    private String cascaded = "0";
    private String opaque = "0";
    private String nosubsets = "0";
    private String fixedWidth = "0";
    private String fixedHeight = "0";
    private String scaleHintMin = "0";
    private String scaleHintMax = "0";
    private Attribution attribution;
    private Layer parent;
    private ServiceProvider serviceProvider;
    private Set dimensions;
    private Set keywordList;
    private Set styles;
    private Set domainResource;
    private Set identifiers;
    private Set organizationLayers;
    private Set srsbb;
    private Set layers;
    private String oldMetadata;
    private String metadata;
    private Set layerMetadata;

    public Integer getId() {
        return this.id;
    }

    protected void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAbstracts() {
        return this.abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }

    public String getQueryable() {
        return this.queryable;
    }

    public void setQueryable(String queryable) {
        this.queryable = queryable;
    }

    public String getCascaded() {
        return this.cascaded;
    }

    public void setCascaded(String cascaded) {
        this.cascaded = cascaded;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public String getNosubsets() {
        return this.nosubsets;
    }

    public void setNosubsets(String nosubsets) {
        this.nosubsets = nosubsets;
    }

    public String getFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(String fixedWidth) {
        this.fixedWidth = fixedWidth;
    }

    public String getFixedHeight() {
        return this.fixedHeight;
    }

    public void setFixedHeight(String fixedHeight) {
        this.fixedHeight = fixedHeight;
    }

    public String getScaleHintMin() {
        return this.scaleHintMin;
    }

    public void setScaleHintMin(String scaleHintMin) {
        this.scaleHintMin = scaleHintMin;
    }

    public String getScaleHintMax() {
        return this.scaleHintMax;
    }

    public void setScaleHintMax(String scaleHintMax) {
        this.scaleHintMax = scaleHintMax;
    }

    public Layer getParent() {
        return this.parent;
    }

    public void setParent(Layer parent) {
        this.parent = parent;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public Set buildLayerSet(Set layerset, ServiceProvider serviceProvider) throws Exception {
        if (layerset == null) {
            layerset = new HashSet<Layer>();
        }
        this.serviceProvider = serviceProvider;
        if (layerset.contains(this) && this.getName() != null) {
            String msg = "Conflicting layer names: layer to add to set equals layer already in set, layer is not added! ";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        layerset.add(this);
        Set layers = this.getLayers();
        if (layers == null || layers.isEmpty()) {
            return layerset;
        }
        for (Layer subLayer : layers) {
            layerset = subLayer.buildLayerSet(layerset, serviceProvider);
        }
        return layerset;
    }

    public Set getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Set dimensions) {
        this.dimensions = dimensions;
    }

    public void addDimension(Dimensions dimension) {
        if (this.dimensions == null) {
            this.dimensions = new HashSet();
        }
        this.dimensions.add(dimension);
        dimension.setLayer(this);
    }

    public Set getKeywordList() {
        return this.keywordList;
    }

    public void setKeywordList(Set keywordList) {
        this.keywordList = keywordList;
    }

    public void addKeyword(String keyword) {
        if (this.keywordList == null) {
            this.keywordList = new HashSet();
        }
        this.keywordList.add(keyword);
    }

    public Set<Style> getStyles() {
        return this.styles;
    }

    public void setStyles(Set<Style> styles) {
        this.styles = styles;
    }

    public void addStyle(Style style) {
        if (null == this.styles) {
            this.styles = new HashSet();
        }
        this.styles.add(style);
        style.setLayer(this);
    }

    public Set getDomainResource() {
        return this.domainResource;
    }

    public void setDomainResource(Set domainResource) {
        this.domainResource = domainResource;
    }

    public void addDomainResource(LayerDomainResource dr) {
        if (null == this.domainResource) {
            this.domainResource = new HashSet();
        }
        this.domainResource.add(dr);
        dr.setLayer(this);
    }

    public Set getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Set identifiers) {
        this.identifiers = identifiers;
    }

    public void addIdentifier(Identifier identifier) {
        if (null == this.identifiers) {
            this.identifiers = new HashSet();
        }
        this.identifiers.add(identifier);
        identifier.setLayer(this);
    }

    public Set getOrganizationLayers() {
        return this.organizationLayers;
    }

    public void setOrganizationLayers(Set organizationLayers) {
        this.organizationLayers = organizationLayers;
    }

    public Set getSrsbb() {
        return this.srsbb;
    }

    public void setSrsbb(Set srsbb) {
        this.srsbb = srsbb;
    }

    public void addSrsbb(SrsBoundingBox s) {
        if (null == this.srsbb) {
            this.srsbb = new HashSet();
        }
        this.srsbb.add(s);
        s.setLayer(this);
    }

    public Set getLayers() {
        return this.layers;
    }

    public void setLayers(Set layers) {
        this.layers = layers;
    }

    public void addLayer(Layer layer) throws Exception {
        if (this.layers == null) {
            this.layers = new HashSet();
        }
        if (this.layers.contains(layer)) {
            String thisLayerDesc = "sp_abbr=" + (this.getServiceProvider() == null ? "(null)" : this.getServiceProvider().getAbbr()) + ", name=" + this.getName() + ", title=" + this.getTitle() + ", cascaded=" + this.getCascaded();
            String layerDesc = "sp_abbr=" + (layer.getServiceProvider() == null ? "(null)" : layer.getServiceProvider().getAbbr()) + ", name=" + layer.getName() + ", title=" + layer.getTitle() + ", cascaded=" + layer.getCascaded();
            String msg = "Duplicate sibling layer added to parent [" + thisLayerDesc + "]: duplicate [" + layerDesc + "]";
            throw new Exception(msg);
        }
        this.layers.add(layer);
        layer.setParent(this);
    }

    public Layer buildLayerTree(Set layerset) throws Exception {
        this.layers.clear();
        if (layerset == null) {
            return this;
        }
        Integer cId = this.getId();
        if (cId == null) {
            return this;
        }
        for (Layer layer : layerset) {
            Integer pId;
            Layer parent = layer.getParent();
            if (parent == null || (pId = parent.getId()) == null || cId.intValue() != pId.intValue()) continue;
            this.addLayer(layer);
            layer.buildLayerTree(layerset);
        }
        return this;
    }

    public Attribution getAttribution() {
        return this.attribution;
    }

    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
        if (null != attribution) {
            attribution.setLayer(this);
        }
    }

    public String getSpAbbr() {
        if (this.serviceProvider == null) {
            return null;
        }
        return this.serviceProvider.getAbbr();
    }

    public String getUniqueName() {
        if (this.getName() == null) {
            return null;
        }
        String spAbbrUrl = null;
        if (this.getServiceProvider() != null) {
            spAbbrUrl = this.getServiceProvider().getUrlServiceProvideCode();
        }
        String spAbbr = this.getSpAbbr();
        if (spAbbrUrl != null && spAbbrUrl.equalsIgnoreCase(spAbbr)) {
            return this.getName();
        }
        LayerSummary ls = null;
        try {
            ls = OGCCommunication.splitLayerWithoutNsFix(this.getName(), false, this.getSpAbbr(), null);
        }
        catch (Exception ex) {
            return OGCCommunication.attachSp(this.getSpAbbr(), this.getName());
        }
        return OGCCommunication.buildFullLayerName(ls);
    }

    public String getCompleteTitle() {
        if (this.getTitle() == null) {
            return null;
        }
        LayerSummary ls = null;
        try {
            ls = OGCCommunication.splitLayerWithoutNsFix(this.getTitle().replace(" ", ""), false, this.getSpAbbr(), null);
        }
        catch (Exception ex) {
            return OGCCommunication.attachSp(this.getSpAbbr(), this.getTitle().replace(" ", ""));
        }
        return OGCCommunication.buildFullLayerName(ls);
    }

    public String getMetadata() {
        Set metaDataLayers = this.getLayerMetadata();
        if (metaDataLayers == null || metaDataLayers.isEmpty()) {
            return this.getOldMetadata();
        }
        for (LayerMetadata lmd : metaDataLayers) {
            if (lmd.getMetadata() == null) continue;
            return lmd.getMetadata();
        }
        return null;
    }

    public void setMetadata(String metaData) {
        if (metaData != null) {
            Set metaDataLayers = this.getLayerMetadata();
            if (metaDataLayers.isEmpty()) {
                LayerMetadata lmd = new LayerMetadata();
                lmd.setLayer(this);
                lmd.setMetadata(metaData);
                metaDataLayers.add(lmd);
            } else {
                boolean first = true;
                Iterator iterator = metaDataLayers.iterator();
                while (iterator.hasNext()) {
                    LayerMetadata lmd = (LayerMetadata)iterator.next();
                    if (first) {
                        lmd.setMetadata(metaData);
                        first = false;
                        continue;
                    }
                    iterator.remove();
                }
            }
            this.setOldMetadata(null);
        }
    }

    private String getOldMetadata() {
        return this.oldMetadata;
    }

    private void setOldMetadata(String oldMetadata) {
        this.oldMetadata = oldMetadata;
    }

    public Set getLayerMetadata() {
        if (this.layerMetadata == null) {
            this.layerMetadata = new HashSet();
        }
        return this.layerMetadata;
    }

    public void setLayerMetadata(Set layerMetadata) {
        this.layerMetadata = layerMetadata;
    }

    public Set getAuthSubLayersClone(Set authLayerIds) {
        if (authLayerIds == null || authLayerIds.isEmpty()) {
            return null;
        }
        Set subLayers = this.getLayers();
        if (subLayers == null || subLayers.isEmpty()) {
            return null;
        }
        HashSet<Layer> authSubLayers = null;
        for (Layer subLayer : subLayers) {
            Layer subLayerCloned = (Layer)subLayer.clone();
            Set authSubSubLayers = subLayerCloned.getAuthSubLayersClone(authLayerIds);
            boolean layerAuthorized = authLayerIds.contains(subLayer.getId());
            if (!layerAuthorized && (authSubSubLayers == null || authSubSubLayers.isEmpty())) continue;
            subLayerCloned.setLayers(authSubSubLayers);
            if (!layerAuthorized) {
                subLayerCloned.setName(null);
            } else {
                log.debug((Object)("layer authorized, name: " + subLayerCloned.getUniqueName()));
            }
            if (authSubLayers == null) {
                authSubLayers = new HashSet<Layer>();
            }
            authSubLayers.add(subLayerCloned);
        }
        return authSubLayers;
    }

    protected void convertValues2KB(HashMap conversionValues) {
        conversionValues.put("layerName", this.getName());
        ServiceProvider sp = this.getServiceProvider();
        if (sp != null) {
            conversionValues.put("spAbbr", sp.getAbbr());
        }
        if (null != this.getLayers() && this.getLayers().size() != 0) {
            for (Layer l : this.getLayers()) {
                l.convertValues2KB(conversionValues);
            }
        }
        if (null != this.domainResource) {
            for (LayerDomainResource ldr : this.domainResource) {
                ldr.convertValues2KB(conversionValues);
            }
        }
        if (null != this.getStyles() && this.getStyles().size() != 0) {
            for (Style style : this.styles) {
                style.convertValues2KB(conversionValues);
            }
        }
    }

    public Object clone() {
        Iterator it;
        Layer cloneLayer = new Layer();
        ServiceProvider sp = this.getServiceProvider();
        if (sp != null) {
            ServiceProvider cloneSp = sp.shallowClone();
            cloneLayer.setServiceProvider(cloneSp);
        }
        if (null != this.id) {
            cloneLayer.id = new Integer(this.id);
        }
        if (null != this.name) {
            cloneLayer.name = new String(this.name);
        }
        if (null != this.title) {
            cloneLayer.title = new String(this.title);
        }
        if (null != this.abstracts) {
            cloneLayer.abstracts = new String(this.abstracts);
        }
        if (null != this.queryable) {
            cloneLayer.queryable = new String(this.queryable);
        }
        if (null != this.cascaded) {
            cloneLayer.cascaded = new String(this.cascaded);
        }
        if (null != this.opaque) {
            cloneLayer.opaque = new String(this.opaque);
        }
        if (null != this.nosubsets) {
            cloneLayer.nosubsets = new String(this.nosubsets);
        }
        if (null != this.fixedWidth) {
            cloneLayer.fixedWidth = new String(this.fixedWidth);
        }
        if (null != this.fixedHeight) {
            cloneLayer.fixedHeight = new String(this.fixedHeight);
        }
        if (null != this.scaleHintMin) {
            cloneLayer.scaleHintMin = new String(this.scaleHintMin);
        }
        if (null != this.scaleHintMax) {
            cloneLayer.scaleHintMax = new String(this.scaleHintMax);
        }
        if (null != this.attribution) {
            cloneLayer.attribution = (Attribution)this.attribution.clone();
            cloneLayer.attribution.setLayer(cloneLayer);
        }
        if (null != this.dimensions) {
            cloneLayer.dimensions = new HashSet();
            it = this.dimensions.iterator();
            while (it.hasNext()) {
                Dimensions dim = (Dimensions)((Dimensions)it.next()).clone();
                dim.setLayer(cloneLayer);
                cloneLayer.dimensions.add(dim);
            }
        }
        if (null != this.keywordList) {
            cloneLayer.keywordList = new HashSet(this.keywordList);
        }
        if (null != this.styles) {
            cloneLayer.styles = new HashSet();
            it = this.styles.iterator();
            while (it.hasNext()) {
                Style style = (Style)((Style)it.next()).clone();
                style.setLayer(cloneLayer);
                cloneLayer.styles.add(style);
            }
        }
        if (null != this.domainResource) {
            cloneLayer.domainResource = new HashSet();
            it = this.domainResource.iterator();
            while (it.hasNext()) {
                LayerDomainResource ldr = (LayerDomainResource)((LayerDomainResource)it.next()).clone();
                ldr.setLayer(cloneLayer);
                cloneLayer.domainResource.add(ldr);
            }
        }
        if (null != this.identifiers) {
            cloneLayer.identifiers = new HashSet();
            it = this.identifiers.iterator();
            while (it.hasNext()) {
                Identifier identifier = (Identifier)((Identifier)it.next()).clone();
                identifier.setLayer(cloneLayer);
                cloneLayer.identifiers.add(identifier);
            }
        }
        if (null != this.organizationLayers) {
            cloneLayer.organizationLayers = new HashSet(this.organizationLayers);
        }
        if (null != this.srsbb) {
            cloneLayer.srsbb = new HashSet();
            it = this.srsbb.iterator();
            while (it.hasNext()) {
                SrsBoundingBox s = (SrsBoundingBox)((SrsBoundingBox)it.next()).clone();
                s.setLayer(cloneLayer);
                cloneLayer.srsbb.add(s);
            }
        }
        if (null != this.layers) {
            cloneLayer.layers = new HashSet();
            it = this.layers.iterator();
            while (it.hasNext()) {
                Layer layer = (Layer)((Layer)it.next()).clone();
                layer.setParent(cloneLayer);
                cloneLayer.layers.add(layer);
            }
        }
        return cloneLayer;
    }

    @Override
    public Element toElement(Document doc, Element rootElement) {
        Iterator it;
        Text text;
        Element layerElement = doc.createElement("Layer");
        if (null != this.getQueryable()) {
            layerElement.setAttribute("queryable", this.getQueryable());
        }
        if (null != this.getCascaded()) {
            layerElement.setAttribute("cascaded", this.getCascaded());
        }
        if (null != this.getOpaque()) {
            layerElement.setAttribute("opaque", this.getOpaque());
        }
        if (null != this.getNosubsets()) {
            layerElement.setAttribute("noSubsets", this.getNosubsets());
        }
        if (null != this.getFixedWidth()) {
            layerElement.setAttribute("fixedWidth", this.getFixedWidth());
        }
        if (null != this.getFixedHeight()) {
            layerElement.setAttribute("fixedHeight", this.getFixedHeight());
        }
        if (null != this.getName()) {
            Element nameElement = doc.createElement("Name");
            text = doc.createTextNode(this.getUniqueName());
            nameElement.appendChild(text);
            layerElement.appendChild(nameElement);
        }
        if (null != this.getTitle()) {
            Element titleElement = doc.createElement("Title");
            text = doc.createTextNode(this.getTitle());
            titleElement.appendChild(text);
            layerElement.appendChild(titleElement);
        }
        if (null != this.getAbstracts()) {
            Element abstractElement = doc.createElement("Abstract");
            text = doc.createTextNode(this.getAbstracts());
            abstractElement.appendChild(text);
            layerElement.appendChild(abstractElement);
        }
        if (null != this.getKeywordList() && this.getKeywordList().size() != 0) {
            Element keywordListElement = doc.createElement("KeywordList");
            for (String keyword : this.getKeywordList()) {
                Element keywordElement = doc.createElement("Keyword");
                Text text2 = doc.createTextNode(keyword);
                keywordElement.appendChild(text2);
                keywordListElement.appendChild(keywordElement);
            }
            layerElement.appendChild(keywordListElement);
        }
        ArrayList hlist = null;
        Hashtable<String, ArrayList> srshash = new Hashtable<String, ArrayList>();
        SrsBoundingBox srsbb2 = null;
        if (null != this.getSrsbb() && this.getSrsbb().size() != 0) {
            it = this.getSrsbb().iterator();
            while (it.hasNext()) {
                srsbb2 = (SrsBoundingBox)it.next();
                if (srsbb2.getType() == null) continue;
                hlist = (ArrayList)srshash.get(srsbb2.getType());
                if (hlist == null) {
                    hlist = new ArrayList();
                }
                hlist.add(srsbb2);
                srshash.put(srsbb2.getType(), hlist);
            }
        }
        if ((hlist = (ArrayList)srshash.get("SRS")) != null && !hlist.isEmpty()) {
            it = hlist.iterator();
            while (it.hasNext()) {
                srsbb2 = (SrsBoundingBox)it.next();
                layerElement = srsbb2.toElement(doc, layerElement);
            }
        }
        if ((hlist = (ArrayList)srshash.get("LatLonBoundingBox")) != null && !hlist.isEmpty() && (it = hlist.iterator()).hasNext()) {
            srsbb2 = (SrsBoundingBox)it.next();
            layerElement = srsbb2.toElement(doc, layerElement);
        }
        if ((hlist = (ArrayList)srshash.get("BoundingBox")) != null && !hlist.isEmpty()) {
            for (SrsBoundingBox srsbb2 : hlist) {
                layerElement = srsbb2.toElement(doc, layerElement);
            }
        }
        if (null != this.getDimensions() && this.getDimensions().size() != 0) {
            for (Dimensions dim : this.getDimensions()) {
                layerElement = dim.toElement(doc, layerElement);
            }
        }
        if (null != this.getAttribution()) {
            layerElement = this.getAttribution().toElement(doc, layerElement);
        }
        Hashtable<String, ArrayList> ldrhash = new Hashtable<String, ArrayList>();
        LayerDomainResource ldr2 = null;
        if (null != this.getDomainResource() && this.getDomainResource().size() != 0) {
            for (LayerDomainResource ldr2 : this.domainResource) {
                if (ldr2.getDomain() == null) continue;
                hlist = (ArrayList)ldrhash.get(ldr2.getDomain());
                if (hlist == null) {
                    hlist = new ArrayList();
                }
                hlist.add(ldr2);
                ldrhash.put(ldr2.getDomain(), hlist);
            }
        }
        if ((hlist = (ArrayList)ldrhash.get("AuthorityURL")) != null && !hlist.isEmpty()) {
            for (LayerDomainResource ldr2 : hlist) {
                layerElement = ldr2.toElement(doc, layerElement);
            }
        }
        if (null != this.getIdentifiers() && this.getIdentifiers().size() != 0) {
            for (Identifier i : this.identifiers) {
                layerElement = i.toElement(doc, layerElement);
            }
        }
        if ((hlist = (ArrayList)ldrhash.get("MetadataURL")) != null && !hlist.isEmpty()) {
            for (LayerDomainResource ldr2 : hlist) {
                layerElement = ldr2.toElement(doc, layerElement);
            }
        }
        if ((hlist = (ArrayList)ldrhash.get("DataURL")) != null && !hlist.isEmpty()) {
            for (LayerDomainResource ldr2 : hlist) {
                layerElement = ldr2.toElement(doc, layerElement);
            }
        }
        if ((hlist = (ArrayList)ldrhash.get("FeatureListURL")) != null && !hlist.isEmpty()) {
            for (LayerDomainResource ldr2 : hlist) {
                layerElement = ldr2.toElement(doc, layerElement);
            }
        }
        if (null != this.getStyles() && this.getStyles().size() != 0) {
            for (Style style : this.styles) {
                layerElement = style.toElement(doc, layerElement);
            }
        }
        if (null != this.getScaleHintMin() && null != this.getScaleHintMax()) {
            try {
                if (Double.parseDouble(this.getScaleHintMin()) > 0.0 || Double.parseDouble(this.getScaleHintMax()) > 0.0) {
                    Element scaleHintElement = doc.createElement("ScaleHint");
                    scaleHintElement.setAttribute("min", this.getScaleHintMin());
                    scaleHintElement.setAttribute("max", this.getScaleHintMax());
                    layerElement.appendChild(scaleHintElement);
                }
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Stored scalehint is not a number:  " + this.getScaleHintMax() + " min " + this.getScaleHintMin()));
            }
        }
        if (null != this.getLayers() && this.getLayers().size() != 0) {
            for (Layer l : this.getLayers()) {
                layerElement = l.toElement(doc, layerElement);
            }
        }
        rootElement.appendChild(layerElement);
        return rootElement;
    }

    public Layer getTopLayer() {
        Layer parent = this.getParent();
        if (parent != null) {
            return parent.getTopLayer();
        }
        return this;
    }

    public Map getIdentityMap(boolean includeServiceProviderAbbr) {
        HashMap<String, String> tuples = new HashMap<String, String>();
        tuples.put("name", this.getName());
        tuples.put("title", this.getTitle());
        tuples.put("cascaded", this.getCascaded());
        if (includeServiceProviderAbbr) {
            tuples.put("sp_abbr", this.getServiceProvider() == null ? "(null)" : this.getServiceProvider().getAbbr());
        }
        return tuples;
    }

    public boolean equals(Layer layer) {
        EqualsBuilder eb = new EqualsBuilder();
        if (this.getServiceProvider() != null) {
            eb.append((Object)this.getServiceProvider().getAbbr(), (Object)layer.getServiceProvider().getAbbr());
        }
        eb.append((Object)this.getName(), (Object)layer.getName());
        eb.append((Object)this.getTitle(), (Object)layer.getTitle());
        eb.append((Object)this.getCascaded(), (Object)layer.getCascaded());
        return eb.isEquals();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer l = (Layer)o;
        return this.equals(l);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(17, 37);
        if (this.getServiceProvider() != null) {
            hcb.append((Object)this.getServiceProvider().getAbbr());
        }
        hcb.append((Object)this.getName());
        hcb.append((Object)this.getTitle());
        hcb.append((Object)this.getCascaded());
        return hcb.toHashCode();
    }

    public boolean inList(Set layers) {
        if (layers == null) {
            return false;
        }
        for (Layer layer : layers) {
            if (!this.equals(layer)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String returnValue = "";
        if (this.getName() != null) {
            returnValue = returnValue + this.getName();
        }
        if (this.getTitle() != null) {
            returnValue = returnValue + " (" + this.getTitle() + ")";
        }
        return returnValue;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof Layer)) {
            return 1;
        }
        Layer l = (Layer)o;
        return this.toString().compareTo(l.toString());
    }
}

