/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.wms.capabilities;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.ogc.ServiceProviderInterface;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.wms.capabilities.ContactInformation;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.Roles;
import nl.b3p.wms.capabilities.ServiceDomainResource;
import nl.b3p.wms.capabilities.TileSet;
import nl.b3p.wms.capabilities.XMLElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ServiceProvider
implements XMLElement,
ServiceProviderInterface {
    private static final Log log = LogFactory.getLog(ServiceProvider.class);
    private Integer id;
    private String abbr;
    private String name;
    private String title;
    private String abstracts;
    private String fees;
    private String accessConstraints;
    private String givenName;
    private String url;
    private String wmsVersion;
    private Date updatedDate;
    private ContactInformation contactInformation;
    private Set domainResource;
    private Set serviceProviderKeywordList;
    private Set exceptions;
    private Set layers;
    private Set<TileSet> tileSets;
    private Layer topLayer;
    private Set allRoles;
    private String code;
    private boolean isSynchronized = false;
    private Date expireDate;
    private String userName;
    private String personalCode;
    private String status;
    private String password;
    private String sldUrl;
    private Boolean ignoreResource;
    private Boolean allowed = Boolean.TRUE;
    private String urlServiceProvideCode = null;

    public ServiceProvider() {
        this.name = KBConfiguration.SERVICEPROVIDER_NAME;
        this.title = KBConfiguration.SERVICEPROVIDER_TITLE;
        this.abstracts = KBConfiguration.SERVICEPROVIDER_ABSTRACT;
        this.fees = KBConfiguration.SERVICEPROVIDER_FEES;
        this.accessConstraints = KBConfiguration.SERVICEPROVIDER_ACCESSCONSTRAINTS;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    protected void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAbstracts() {
        return this.abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }

    public String getFees() {
        return this.fees;
    }

    public void setFees(String fees) {
        this.fees = fees;
    }

    public String getAccessConstraints() {
        return this.accessConstraints;
    }

    public void setAccessConstraints(String accessConstraints) {
        this.accessConstraints = accessConstraints;
    }

    @Override
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public ContactInformation getContactInformation() {
        return this.contactInformation;
    }

    public void setContactInformation(ContactInformation contactInformation) {
        this.contactInformation = contactInformation;
        if (contactInformation != null) {
            contactInformation.setServiceProvider(this);
        }
    }

    public Set getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(Set exceptions) {
        this.exceptions = exceptions;
    }

    public void addException(String except) {
        if (this.exceptions == null) {
            this.exceptions = new HashSet();
        }
        this.exceptions.add(except);
    }

    public Set getDomainResource() {
        return this.domainResource;
    }

    public void setDomainResource(Set domainResource) {
        this.domainResource = domainResource;
    }

    public void addDomainResource(ServiceDomainResource dr) {
        if (this.domainResource == null) {
            this.domainResource = new HashSet();
        }
        this.domainResource.add(dr);
        dr.setServiceProvider(this);
    }

    public void setAllRoles(Set allRoles) {
        this.allRoles = allRoles;
    }

    public Set getAllRoles() {
        return this.allRoles;
    }

    public void addRole(Roles role) {
        if (this.allRoles == null) {
            this.allRoles = new HashSet();
        }
        this.allRoles.add(role);
    }

    public String getOrganizationCode() {
        return this.code;
    }

    public void setOrganizationCode(String code) {
        this.code = code;
    }

    public Set getAllLayers() {
        if (!this.isIsSynchronized() && this.topLayer != null) {
            try {
                this.layers = this.topLayer.buildLayerSet(null, this);
            }
            catch (Exception e) {
                log.error((Object)"Can not build layer set.", (Throwable)e);
            }
            this.setIsSynchronized(true);
        }
        return this.layers;
    }

    private Layer defineTopLayer() {
        if (this.layers == null) {
            return null;
        }
        Iterator it = this.layers.iterator();
        Layer parent = null;
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (layer.getParent() != null) continue;
            if (parent != null) {
                throw new Error("inconsistente database, meerdere top layers! service provider id " + this.getId());
            }
            parent = layer;
        }
        return parent;
    }

    public Layer getTopLayer() throws Exception {
        if (!this.isIsSynchronized() && this.topLayer == null) {
            this.topLayer = this.defineTopLayer();
            if (this.topLayer != null) {
                this.topLayer.buildLayerTree(this.layers);
            }
            this.setIsSynchronized(true);
        }
        return this.topLayer;
    }

    public void setTopLayer(Layer topLayer) {
        this.setIsSynchronized(false);
        this.topLayer = topLayer;
    }

    public Set getServiceProviderKeywordList() {
        return this.serviceProviderKeywordList;
    }

    public void setServiceProviderKeywordList(Set serviceProviderKeywordList) {
        this.serviceProviderKeywordList = serviceProviderKeywordList;
    }

    public void addKeyword(String keyword) {
        if (null == this.serviceProviderKeywordList) {
            this.serviceProviderKeywordList = new HashSet();
        }
        if (keyword != null && keyword.trim().length() != 0) {
            this.serviceProviderKeywordList.add(keyword);
        }
    }

    public void convertValues2KB(HashMap conversionValues) throws Exception {
        Layer tl;
        String newUrl;
        conversionValues.put("spAbbrUrl", this.getUrlServiceProvideCode());
        this.url = newUrl = (String)conversionValues.get("url");
        if (this.domainResource != null) {
            for (ServiceDomainResource sdr : this.domainResource) {
                sdr.convertValues2KB(conversionValues);
            }
        }
        if ((tl = this.getTopLayer()) != null) {
            tl.convertValues2KB(conversionValues);
        }
    }

    @Override
    public Element toElement(Document doc, Element rootElement) {
        Text text;
        Text text2;
        Element serviceElement = doc.createElement("Service");
        if (null != this.getName()) {
            Element nameElement = doc.createElement("Name");
            text2 = doc.createTextNode(this.getName());
            nameElement.appendChild(text2);
            serviceElement.appendChild(nameElement);
        }
        if (null != this.getTitle()) {
            Element titleElement = doc.createElement("Title");
            text2 = doc.createTextNode(this.getTitle());
            titleElement.appendChild(text2);
            serviceElement.appendChild(titleElement);
        }
        if (null != this.getAbstracts()) {
            Element abstractElement = doc.createElement("Abstract");
            text2 = doc.createTextNode(this.getAbstracts());
            abstractElement.appendChild(text2);
            serviceElement.appendChild(abstractElement);
        }
        if (null != this.getServiceProviderKeywordList() && !this.getServiceProviderKeywordList().isEmpty()) {
            Element keywordListElement = doc.createElement("KeywordList");
            for (String keyword : this.getServiceProviderKeywordList()) {
                Element keywordElement = doc.createElement("Keyword");
                Text text3 = doc.createTextNode(keyword);
                keywordElement.appendChild(text3);
                keywordListElement.appendChild(keywordElement);
            }
            serviceElement.appendChild(keywordListElement);
        }
        if (null != this.getUrl()) {
            Element onlineElement = doc.createElement("OnlineResource");
            onlineElement.setAttribute("xlink:href", this.getUrl());
            onlineElement.setAttribute("xlink:type", "simple");
            onlineElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            serviceElement.appendChild(onlineElement);
        }
        if (null != this.getContactInformation()) {
            serviceElement = this.getContactInformation().toElement(doc, serviceElement);
        }
        if (null != this.getFees()) {
            Element feesElement = doc.createElement("Fees");
            text2 = doc.createTextNode(this.getFees());
            feesElement.appendChild(text2);
            serviceElement.appendChild(feesElement);
        }
        if (null != this.getAccessConstraints()) {
            Element accessElement = doc.createElement("AccessConstraints");
            text2 = doc.createTextNode(this.getAccessConstraints());
            accessElement.appendChild(text2);
            serviceElement.appendChild(accessElement);
        }
        Element capabilityElement = doc.createElement("Capability");
        Element requestElement = doc.createElement("Request");
        if (this.domainResource != null) {
            HashMap<String, ServiceDomainResource> sdrhash = new HashMap<String, ServiceDomainResource>();
            ServiceDomainResource sdr2 = null;
            for (ServiceDomainResource sdr2 : this.domainResource) {
                sdrhash.put(sdr2.getDomain(), sdr2);
            }
            sdr2 = (ServiceDomainResource)sdrhash.get("GetCapabilities");
            if (sdr2 != null) {
                requestElement = sdr2.toElement(doc, requestElement);
            }
            if ((sdr2 = (ServiceDomainResource)sdrhash.get("GetMap")) != null) {
                requestElement = sdr2.toElement(doc, requestElement);
            }
            if ((sdr2 = (ServiceDomainResource)sdrhash.get("GetFeatureInfo")) != null) {
                requestElement = sdr2.toElement(doc, requestElement);
            }
            if ((sdr2 = (ServiceDomainResource)sdrhash.get("DescribeLayer")) != null) {
                requestElement = sdr2.toElement(doc, requestElement);
            }
            if ((sdr2 = (ServiceDomainResource)sdrhash.get("GetLegendGraphic")) != null) {
                requestElement = sdr2.toElement(doc, requestElement);
            }
            if ((sdr2 = (ServiceDomainResource)sdrhash.get("GetStyles")) != null) {
                requestElement = sdr2.toElement(doc, requestElement);
            }
            capabilityElement.appendChild(requestElement);
        }
        Element exceptionElement = doc.createElement("Exception");
        if (this.exceptions != null) {
            Iterator it = this.exceptions.iterator();
            while (it.hasNext()) {
                Element formatElement = doc.createElement("Format");
                text = doc.createTextNode((String)it.next());
                formatElement.appendChild(text);
                exceptionElement.appendChild(formatElement);
            }
        }
        capabilityElement.appendChild(exceptionElement);
        Element vendorSpecificElement = doc.createElement("VendorSpecificCapabilities");
        if (this.getAllRoles() != null && !this.getAllRoles().isEmpty()) {
            for (Roles role : this.getAllRoles()) {
                Element roleElement = doc.createElement("Role");
                roleElement.setAttribute("id", role.getRole());
                vendorSpecificElement.appendChild(roleElement);
            }
        } else {
            Element roleElement = doc.createElement("Role");
            roleElement.setAttribute("id", KBConfiguration.KB_DEFAULT_ROLE);
            vendorSpecificElement.appendChild(roleElement);
        }
        if (this.getOrganizationCode() != null) {
            Element orgcode = doc.createElement("OrganizationCode");
            text = doc.createTextNode(this.getOrganizationCode());
            orgcode.appendChild(text);
            vendorSpecificElement.appendChild(orgcode);
        }
        if (this.getExpireDate() != null) {
            Element expireDate = doc.createElement("ExpireDate");
            text = doc.createTextNode(this.getExpireDate().toString());
            expireDate.appendChild(text);
            vendorSpecificElement.appendChild(expireDate);
        }
        if (this.getUserName() != null) {
            Element userName = doc.createElement("UserName");
            text = doc.createTextNode(this.getUserName());
            userName.appendChild(text);
            vendorSpecificElement.appendChild(userName);
        }
        if (this.getGivenName() != null) {
            Element givenName = doc.createElement("GivenName");
            text = doc.createTextNode(this.getGivenName());
            givenName.appendChild(text);
            vendorSpecificElement.appendChild(givenName);
        }
        if (this.getPersonalCode() != null) {
            Element pCode = doc.createElement("PersonalCode");
            text = doc.createTextNode(this.getPersonalCode());
            pCode.appendChild(text);
            vendorSpecificElement.appendChild(pCode);
        }
        if (this.getTileSets() != null) {
            for (TileSet ts : this.getTileSets()) {
                ts.setUrlServiceProvideCode(this.getUrlServiceProvideCode());
                if (ts == null) continue;
                vendorSpecificElement.appendChild(ts.toElement(doc, doc.createElement("TileSet")));
            }
        }
        capabilityElement.appendChild(vendorSpecificElement);
        if (this.topLayer != null) {
            capabilityElement = this.topLayer.toElement(doc, capabilityElement);
        }
        rootElement.appendChild(serviceElement);
        rootElement.appendChild(capabilityElement);
        return rootElement;
    }

    public String getWmsVersion() {
        return this.wmsVersion;
    }

    public void setWmsVersion(String wmsVersion) {
        this.wmsVersion = wmsVersion;
    }

    private Set getLayers() {
        return this.layers;
    }

    public void setLayers(Set layers) {
        this.layers = layers;
        this.setIsSynchronized(false);
    }

    public boolean isIsSynchronized() {
        return this.isSynchronized;
    }

    public void setIsSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    @Override
    public String getAbbr() {
        if (this.abbr == null && this.id != null) {
            return this.id.toString();
        }
        return this.abbr;
    }

    public void setAbbr(String abbr) {
        this.abbr = abbr;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public String getPersonalCode() {
        return this.personalCode;
    }

    public void setPersonalCode(String personalCode) {
        this.personalCode = personalCode;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSldUrl() {
        return this.sldUrl;
    }

    public void setSldUrl(String sldUrl) {
        this.sldUrl = sldUrl;
    }

    public ServiceProvider shallowClone() {
        ServiceProvider sc = new ServiceProvider();
        sc.setAbbr(this.getAbbr());
        sc.setAbstracts(this.getAbstracts());
        sc.setAccessConstraints(this.getAccessConstraints());
        sc.setFees(this.getFees());
        sc.setGivenName(this.getGivenName());
        sc.setIsSynchronized(false);
        sc.setName(this.getName());
        sc.setTitle(this.getTitle());
        sc.setUrl(this.getUrl());
        sc.setWmsVersion(this.getWmsVersion());
        sc.setUserName(this.getUserName());
        sc.setPassword(this.getPassword());
        sc.setUpdatedDate(this.getUpdatedDate());
        sc.setExpireDate(this.getExpireDate());
        sc.setPersonalCode(this.getPersonalCode());
        sc.setStatus(this.getStatus());
        sc.setSldUrl(this.getSldUrl());
        sc.setIgnoreResource(this.getIgnoreResource());
        sc.setAllowed(this.getAllowed());
        sc.setUrlServiceProvideCode(this.getUrlServiceProvideCode());
        HashSet dr = new HashSet();
        dr.addAll(this.getDomainResource());
        sc.setDomainResource(dr);
        return sc;
    }

    public ServiceDomainResource getServiceDomainResourceByOperationName(String operationName) {
        if (this.getDomainResource() == null) {
            return null;
        }
        Iterator sdit = this.getDomainResource().iterator();
        boolean canHandleGetLegend = false;
        while (sdit.hasNext() && !canHandleGetLegend) {
            ServiceDomainResource sdr = (ServiceDomainResource)sdit.next();
            if (!sdr.getDomain().equals(operationName)) continue;
            return sdr;
        }
        return null;
    }

    @Override
    public String getType() {
        return "WMS";
    }

    public Set<TileSet> getTileSets() {
        return this.tileSets;
    }

    public void setTileSets(Set<TileSet> tileSets) {
        this.tileSets = tileSets;
    }

    public void addTileSet(TileSet ts) {
        if (this.tileSets == null) {
            this.tileSets = new HashSet<TileSet>();
        }
        this.tileSets.add(ts);
    }

    public TileSet getTileSet(Layer layer) {
        if (this.tileSets == null) {
            return null;
        }
        for (TileSet ts : this.tileSets) {
            if (ts.getLayers() == null || ts.getLayers().size() != 1 || !ts.getLayers().contains(layer)) continue;
            return ts;
        }
        return null;
    }

    public Boolean getIgnoreResource() {
        return this.ignoreResource;
    }

    public void setIgnoreResource(Boolean ignoreResource) {
        this.ignoreResource = ignoreResource;
    }

    public B3PCredentials getCredentials() {
        B3PCredentials credentials = new B3PCredentials();
        credentials.setUserName(this.userName);
        credentials.setPassword(this.password);
        return credentials;
    }

    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public Boolean getAllowed() {
        return this.allowed;
    }

    public String getUrlServiceProvideCode() {
        return this.urlServiceProvideCode;
    }

    public void setUrlServiceProvideCode(String urlServiceProvideCode) {
        this.urlServiceProvideCode = urlServiceProvideCode;
    }
}

