/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.sld;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import nl.b3p.ogc.sld.SldLayerFeatureConstraints;
import nl.b3p.ogc.sld.SldNamedStyle;
import nl.b3p.ogc.sld.SldNode;
import nl.b3p.ogc.sld.SldUserStyle;
import nl.b3p.ogc.sld.SldWriter;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SldNamedLayer
extends SldNode {
    private static final Log log = LogFactory.getLog(SldNamedLayer.class);
    private static XPathExpression xpath_name = null;
    private static XPathExpression xpath_userStyle = null;
    private static XPathExpression xpath_namedStyle = null;
    private static XPathExpression xpath_layerFeatureConstraints = null;

    public SldNamedLayer() throws XPathExpressionException {
        this.initXpath();
    }

    public SldNamedLayer(String version) throws XPathExpressionException {
        super(version);
        this.initXpath();
    }

    private void initXpath() throws XPathExpressionException {
        if (xpath_name == null) {
            if (this.version.equalsIgnoreCase("1.0.0")) {
                xpath_name = xpath.compile("sld:Name");
            } else if (this.version.equalsIgnoreCase("1.1.0")) {
                xpath_name = xpath.compile("se:Name");
            } else {
                throw new NotImplementedException();
            }
            xpath_userStyle = xpath.compile("sld:UserStyle");
            xpath_namedStyle = xpath.compile("sld:NamedStyle");
            xpath_layerFeatureConstraints = xpath.compile("sld:LayerFeatureConstraints");
        }
    }

    public SldNamedLayer(List<SldNode> styles, String namedLayerName) throws Exception {
        this();
        this.node = this.initElement(styles, namedLayerName);
    }

    public SldNamedLayer(List<SldNode> styles, String namedLayerName, String version) throws Exception {
        this(version);
        this.node = this.initElement(styles, namedLayerName);
    }

    private Node initElement(List<SldNode> styles, String namedLayerName) throws Exception {
        String xml = "";
        xml = xml + "<sld:NamedLayer xmlns:sld=\"http://www.opengis.net/sld\">";
        if (this.version.equalsIgnoreCase("1.0.0")) {
            xml = xml + "<sld:Name>" + namedLayerName + "</sld:Name>";
        } else if (this.version.equalsIgnoreCase("1.1.0")) {
            xml = xml + "<se:Name xmlns:se=\"http://www.opengis.net/se\">" + namedLayerName + "</se:Name>";
        } else {
            throw new NotImplementedException();
        }
        for (SldNode style : styles) {
            xml = xml + style.getSldPart();
        }
        xml = xml + "</sld:NamedLayer>";
        Document doc = SldWriter.getDocument(xml, "UTF-8");
        return doc.getDocumentElement();
    }

    public SldNamedLayer(Node node) throws XPathExpressionException {
        this();
        this.node = node;
    }

    public SldNamedLayer(Node node, String version) throws XPathExpressionException {
        this(version);
        this.node = node;
    }

    @Override
    public String getName() throws XPathExpressionException {
        return xpath_name.evaluate(this.node);
    }

    public void setName(String name) throws XPathExpressionException {
        Node n = (Node)xpath_name.evaluate(this.node, XPathConstants.NODE);
        n.setTextContent(name);
    }

    public List<SldUserStyle> getUserStyles() throws Exception {
        NodeList nodeSet = (NodeList)xpath_userStyle.evaluate(this.node, XPathConstants.NODESET);
        ArrayList<SldUserStyle> userStyles = new ArrayList<SldUserStyle>();
        for (int i = 0; i < nodeSet.getLength(); ++i) {
            Node n = nodeSet.item(i);
            SldUserStyle sldUserStyle = new SldUserStyle(n);
            userStyles.add(sldUserStyle);
        }
        return userStyles;
    }

    public List<SldNamedStyle> getNamedStyles() throws Exception {
        NodeList nodeSet = (NodeList)xpath_namedStyle.evaluate(this.node, XPathConstants.NODESET);
        ArrayList<SldNamedStyle> namedStyles = new ArrayList<SldNamedStyle>();
        SldLayerFeatureConstraints constriants = this.getLayerFeatureConstraints();
        for (int i = 0; i < nodeSet.getLength(); ++i) {
            Node n = nodeSet.item(i);
            SldNamedStyle sldNamedStyle = new SldNamedStyle(n);
            sldNamedStyle.setFeatureConstraints(constriants);
            namedStyles.add(sldNamedStyle);
        }
        return namedStyles;
    }

    public SldLayerFeatureConstraints getLayerFeatureConstraints() throws Exception {
        NodeList nodeSet = (NodeList)xpath_layerFeatureConstraints.evaluate(this.node, XPathConstants.NODESET);
        SldLayerFeatureConstraints layerFeatureConstraints = null;
        if (nodeSet.getLength() > 0) {
            Node n = nodeSet.item(0);
            layerFeatureConstraints = new SldLayerFeatureConstraints(n);
        }
        return layerFeatureConstraints;
    }

    public List<SldNode> getStyles() throws Exception {
        ArrayList<SldNode> list = new ArrayList<SldNode>();
        list.addAll(this.getUserStyles());
        list.addAll(this.getNamedStyles());
        return list;
    }
}

