/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCConstants;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OGCCommunication
implements OGCConstants {
    protected HashMap nameSpaces;
    protected HashMap schemaLocations;

    public void addOrReplaceNameSpace(String prefix, String nsUrl) {
        if (prefix != null && nsUrl != null && !nsUrl.isEmpty()) {
            if (this.nameSpaces == null) {
                this.addOpengisNamespaces();
            }
            this.nameSpaces.put(prefix, nsUrl);
        }
    }

    public final void findNameSpace(Node node) {
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            for (int i = 0; map.getLength() > i; ++i) {
                String value = map.item(i).getNodeValue();
                if (value == null || value.length() == 0) continue;
                String name = map.item(i).getNodeName();
                String[] tokens = name.split(":");
                if (tokens[0].equalsIgnoreCase("xmlns")) {
                    if (tokens.length > 1) {
                        this.addOrReplaceNameSpace(tokens[1], value);
                        continue;
                    }
                    this.addOrReplaceNameSpace("", value);
                    continue;
                }
                if (tokens.length != 2 || !tokens[1].equalsIgnoreCase("SchemaLocation")) continue;
                this.addOrReplaceSchemaLocation(tokens[1], value);
            }
        }
        if (node.hasChildNodes()) {
            NodeList lijst = node.getChildNodes();
            for (int i = 0; i < lijst.getLength(); ++i) {
                this.findNameSpace(lijst.item(i));
            }
        }
    }

    protected void addOrReplaceSchemaLocation(String prefix, String location) {
        if (prefix != null && location != null) {
            if (this.schemaLocations == null) {
                this.addOpengisSchemaLocations();
            }
            this.schemaLocations.put(prefix, location);
        }
    }

    protected final void setNameSpaces(HashMap nameSpaces) {
        this.nameSpaces = nameSpaces;
    }

    protected HashMap getNameSpaces() {
        return this.nameSpaces;
    }

    protected HashMap getSchemaLocations() {
        return this.schemaLocations;
    }

    protected final void setSchemaLocations(HashMap schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    protected String getNameSpace(String param) {
        if (param == null || this.nameSpaces == null) {
            return null;
        }
        return (String)this.nameSpaces.get(param);
    }

    public String getNameSpacePrefix(String namespaceUrl) {
        return this.getNameSpacePrefix(namespaceUrl, false);
    }

    public String getNameSpacePrefix(String namespaceUrl, boolean create) {
        if (this.nameSpaces == null || this.nameSpaces.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : this.nameSpaces.entrySet()) {
            String prefix;
            if (!entry.getValue().equals(namespaceUrl) || (prefix = (String)entry.getKey()).isEmpty() && create) continue;
            return (String)entry.getKey();
        }
        String prefix = "";
        if (create) {
            int nsTeller = 1;
            String ns = this.getNameSpace("ns" + nsTeller);
            while (ns != null) {
                ns = this.getNameSpace("ns" + ++nsTeller);
            }
            prefix = "ns" + nsTeller;
        }
        this.addOrReplaceNameSpace(prefix, namespaceUrl);
        return prefix;
    }

    protected String[] getNameSpacesArray() {
        if (this.nameSpaces == null) {
            return null;
        }
        String[] returnvalue = new String[this.nameSpaces.size()];
        Set keys = this.nameSpaces.keySet();
        Iterator it = keys.iterator();
        int i = 0;
        while (it.hasNext()) {
            String prefix = (String)it.next();
            String location = (String)this.nameSpaces.get(prefix);
            returnvalue[i] = "xmlns:" + prefix + "=\"" + location + "\"";
            ++i;
        }
        return returnvalue;
    }

    protected String[] getSchemaLocationsArray() {
        if (this.schemaLocations == null) {
            return null;
        }
        String[] returnvalue = new String[this.schemaLocations.size()];
        Set keys = this.schemaLocations.keySet();
        Iterator it = keys.iterator();
        int i = 0;
        while (it.hasNext()) {
            String prefix = (String)it.next();
            String location = (String)this.schemaLocations.get(prefix);
            returnvalue[i] = prefix + ":schemaLocation=\"" + location + "\"";
            ++i;
        }
        return returnvalue;
    }

    protected final void addOpengisNamespaces() {
        if (this.nameSpaces == null) {
            this.nameSpaces = new HashMap();
        }
        if (!this.nameSpaces.containsKey("wfs")) {
            this.addOrReplaceNameSpace("wfs", "http://www.opengis.net/wfs");
        }
        if (!this.nameSpaces.containsKey("xsi")) {
            this.addOrReplaceNameSpace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (!this.nameSpaces.containsKey("gml")) {
            this.addOrReplaceNameSpace("gml", "http://www.opengis.net/gml");
        }
        if (!this.nameSpaces.containsKey("ogc")) {
            this.addOrReplaceNameSpace("ogc", "http://www.opengis.net/ogc");
        }
        if (!this.nameSpaces.containsKey("ows")) {
            this.addOrReplaceNameSpace("ows", "http://www.opengis.net/ows");
        }
    }

    protected final void addOpengisSchemaLocations() {
        if (this.schemaLocations == null) {
            this.schemaLocations = new HashMap();
        }
        if (!this.schemaLocations.containsKey("xsi")) {
            // empty if block
        }
    }

    public NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)OGCCommunication.this.nameSpaces.get(prefix);
            }

            public Iterator getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }
        };
    }

    public LayerSummary splitLayerInParts(String fullLayerName) throws Exception {
        return this.splitLayerInParts(fullLayerName, true, null, null);
    }

    public static LayerSummary splitLayerWithoutNsFix(String fullLayerName) throws Exception {
        return OGCCommunication.splitLayerWithoutNsFix(fullLayerName, true, null, null);
    }

    public LayerSummary splitLayerInParts(String fullLayerName, boolean splitName, String defaultSp, String defaultNs) throws Exception {
        LayerSummary m = OGCCommunication.splitLayerWithoutNsFix(fullLayerName, splitName, defaultSp, defaultNs);
        String tPrefix = m.getPrefix();
        String tNsUrl = m.getNsUrl();
        if (tNsUrl != null && !tNsUrl.isEmpty()) {
            tPrefix = this.getNameSpacePrefix(tNsUrl);
            m.setPrefix(tPrefix);
        } else if (tPrefix != null && !tPrefix.isEmpty()) {
            tNsUrl = this.getNameSpace(tPrefix);
            m.setNsUrl(tNsUrl);
        }
        return m;
    }

    public static LayerSummary splitLayerWithoutNsFix(String fullLayerName, boolean splitName) throws Exception {
        return OGCCommunication.splitLayerWithoutNsFix(fullLayerName, splitName, null, null);
    }

    public static LayerSummary splitLayerWithoutNsFix(String fullLayerName, boolean splitName, String defaultSp, String defaultNs) throws Exception {
        int index1;
        String tPrefix = null;
        String tLayerName = null;
        String tSpAbbr = null;
        String tSpLayerName = null;
        String tNsUrl = null;
        if (fullLayerName == null) {
            return null;
        }
        String[] temp = fullLayerName.split("}");
        if (temp.length > 1) {
            tSpLayerName = temp[1];
            index1 = fullLayerName.indexOf("{");
            int index2 = fullLayerName.indexOf("}");
            tNsUrl = fullLayerName.substring(index1 + 1, index2);
        } else {
            String[] temp2 = temp[0].split(":");
            if (temp2.length > 1) {
                tSpLayerName = temp2[1];
                tPrefix = temp2[0];
            } else {
                tSpLayerName = fullLayerName;
            }
        }
        tLayerName = tSpLayerName;
        if ((splitName || tSpLayerName.startsWith(KBConfiguration.SERVICEPROVIDER_BASE_ABBR + "_")) && (index1 = tSpLayerName.indexOf("_")) != -1) {
            tSpAbbr = tSpLayerName.substring(0, index1);
            tLayerName = tSpLayerName.substring(index1 + 1);
        }
        if (tLayerName.isEmpty()) {
            throw new Exception(KBConfiguration.REQUEST_LAYERNAME_EXCEPTION + ": " + tLayerName);
        }
        if (defaultSp != null && tSpAbbr == null) {
            tSpAbbr = defaultSp;
        }
        if (defaultNs != null && tPrefix == null) {
            tPrefix = defaultNs;
        }
        LayerSummary returnMap = new LayerSummary();
        returnMap.setPrefix(tPrefix);
        returnMap.setSpAbbr(tSpAbbr);
        returnMap.setLayerName(tLayerName);
        returnMap.setNsUrl(tNsUrl);
        return returnMap;
    }

    public static String[] toCodeAndName(String completeLayerName) throws Exception {
        LayerSummary m = OGCCommunication.splitLayerWithoutNsFix(completeLayerName);
        if (m == null) {
            return null;
        }
        String layerCode = m.getSpAbbr();
        String layerName = OGCCommunication.buildLayerNameWithoutSp(m);
        return new String[]{layerCode, layerName};
    }

    public static String getLayerName(String ln) {
        try {
            LayerSummary m = OGCCommunication.splitLayerWithoutNsFix(ln);
            return OGCCommunication.buildLayerNameWithoutNs(m);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String attachSp(String sp, String l) {
        try {
            LayerSummary m = OGCCommunication.splitLayerWithoutNsFix(l, false, sp, null);
            return OGCCommunication.buildFullLayerName(m);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String attachSpNs(String sp, String l, String ns) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        if (sp == null || sp.isEmpty()) {
            if (ns == null || ns.isEmpty()) {
                return l;
            }
            return ns + ":" + l;
        }
        if (ns == null || ns.isEmpty()) {
            return sp + "_" + l;
        }
        return ns + ":" + sp + "_" + l;
    }

    public static String buildFullLayerName(LayerSummary m) {
        String tPrefix = m.getPrefix();
        String tSpAbbr = m.getSpAbbr();
        String tLayerName = m.getLayerName();
        return OGCCommunication.attachSpNs(tSpAbbr, tLayerName, tPrefix);
    }

    public static String buildLayerNameWithoutSp(LayerSummary m) {
        String tPrefix = m.getPrefix();
        String tLayerName = m.getLayerName();
        return OGCCommunication.attachSpNs(null, tLayerName, tPrefix);
    }

    public static String buildLayerNameWithoutNs(LayerSummary m) {
        String tSpAbbr = m.getSpAbbr();
        String tLayerName = m.getLayerName();
        return OGCCommunication.attachSpNs(tSpAbbr, tLayerName, null);
    }

    public static String replaceIds(String originalId, String sp, String ns) {
        if (sp == null) {
            if (ns == null) {
                return originalId;
            }
            return ns + ":" + originalId;
        }
        String[] idSplit = originalId.split(sp + "_");
        String newId = "";
        for (int i = 0; i < idSplit.length; ++i) {
            newId = newId + idSplit[i];
            if (i >= idSplit.length - 1 || ns == null) continue;
            newId = newId + ns + ":";
        }
        return newId;
    }

    protected final String stripNs(String key) {
        String[] temp = key.split("}");
        if (temp.length == 2) {
            return temp[1];
        }
        return key;
    }

    public String fixNsPrefix(String ft) {
        int index1 = ft.indexOf("{");
        int index2 = ft.indexOf("}");
        if (index1 >= 0 && index2 >= 0) {
            String nameSpaceUri = ft.substring(index1 + 1, index2);
            String prefix = this.getNameSpacePrefix(nameSpaceUri);
            if (prefix.isEmpty()) {
                return ft.substring(index2 + 1);
            }
            return prefix + ":" + ft.substring(index2 + 1);
        }
        return ft;
    }

    protected final String determineFeatureTypeName(String spAbbr, String layer) {
        try {
            LayerSummary m = this.splitLayerInParts(layer, false, spAbbr, null);
            return OGCCommunication.buildFullLayerName(m);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static String cleanPrefixInBody(String body, String prefix, String nsUrl, String ns) {
        String old = "";
        if (nsUrl != null) {
            old = old + nsUrl;
        }
        if (prefix != null) {
            old = old + prefix;
        }
        if (old.length() == 0) {
            return body;
        }
        String nsnew = "";
        if (ns != null) {
            nsnew = nsnew + ns;
        }
        StringBuffer bBody = new StringBuffer(body);
        int start = bBody.indexOf(old);
        while (start >= 0) {
            bBody.replace(start, start + old.length(), nsnew);
        }
        return bBody.toString();
    }
}

